/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan;

import javax.annotation.Nullable;
import xbigellx.rbp.internal.level.scan.TraversedBlock;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;

public class TraversedIntegrityBlock
extends TraversedBlock<TraversedIntegrityBlock> {
    private final RPBlockContext blockContext;
    private final double baseSupportCost;
    private final double beamSupportCost;
    private final boolean isSupportPillar;
    private final double cumulativeWeight;
    private final boolean isBeingCrushed;

    public TraversedIntegrityBlock(RPBlockContext blockContext, double baseSupportCost, double beamSupportCost, double cumulativeWeight, boolean isSupportPillar, boolean isBeingCrushed, @Nullable TraversedIntegrityBlock parent) {
        super(blockContext.pos(), parent);
        this.blockContext = blockContext;
        this.baseSupportCost = baseSupportCost;
        this.beamSupportCost = beamSupportCost;
        this.cumulativeWeight = cumulativeWeight;
        this.isSupportPillar = isSupportPillar;
        this.isBeingCrushed = isBeingCrushed;
    }

    public RPBlockContext blockContext() {
        return this.blockContext;
    }

    public boolean isBeamPillar() {
        return this.beamSupportCost > 0.0;
    }

    public boolean isBeingCrushed() {
        return this.isBeingCrushed;
    }

    public boolean isSupportPillar() {
        return this.isSupportPillar && this.getIntegrity() >= 0.0;
    }

    public double beamSupportCost() {
        return this.beamSupportCost;
    }

    public double baseSupportCost() {
        return this.baseSupportCost;
    }

    public double getIntegrity() {
        if (this.parent() == null) {
            return 0.0;
        }
        return (double)this.blockContext.blockDefinition().physics().supportStrength() - ((TraversedIntegrityBlock)this.parent()).baseSupportCost();
    }

    public double cumulativeWeight() {
        return this.cumulativeWeight;
    }

    public boolean isStable() {
        return (this.isBeamPillar() || this.getIntegrity() >= 0.0) && !this.isBeingCrushed();
    }
}

