/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan.algorithm;

import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import xbigellx.rbp.internal.level.scan.BlockTraversalResult;
import xbigellx.rbp.internal.level.scan.TraversalAction;
import xbigellx.rbp.internal.level.scan.TraversalContext;
import xbigellx.rbp.internal.level.scan.TraversedBlock;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public abstract class BlockTraverseAlgorithm {
    private static final Comparator<ProcessedNode<?>> COMPARATOR = Comparator.comparingInt(ProcessedNode::cost);
    private static final ThreadLocal<ScanCache> SCAN_CACHE = ThreadLocal.withInitial(ScanCache::new);

    protected abstract int calculateNodeCost(TraversalContext<?> var1);

    public final <T extends TraversedBlock<T>> void traverse(BlockPos origin, Function<TraversalContext<T>, BlockTraversalResult<T>> scanner) {
        ScanCache scanCache = SCAN_CACHE.get();
        scanCache.prepare(new ChunkPos(origin));
        PriorityQueue<ProcessedNode<T>> openQueue = new PriorityQueue<ProcessedNode<T>>(COMPARATOR);
        AtomicBoolean abortScan = new AtomicBoolean();
        TraversalContext<T> traversalContext = new TraversalContext<T>(origin);
        traversalContext.prepare(origin, null, 0);
        this.traverseNode(traversalContext, scanCache, openQueue, scanner);
        block0: while (!openQueue.isEmpty() && !abortScan.get()) {
            ProcessedNode<T> polled = openQueue.poll();
            T polledNode = polled.traversedNode();
            for (ExtendedDirection dir : ExtendedDirection.values()) {
                BlockPos nPos = ((TraversedBlock)polledNode).blockPos().m_121955_(dir.getNormal());
                if (scanCache.isVisited(nPos)) continue;
                traversalContext.prepare(nPos, polledNode, polled.cost);
                TraversalAction action = this.traverseNode(traversalContext, scanCache, openQueue, scanner);
                if (!action.equals((Object)TraversalAction.ABORT)) continue;
                abortScan.set(true);
                continue block0;
            }
        }
    }

    private <T extends TraversedBlock<T>> TraversalAction traverseNode(TraversalContext<T> context, ScanCache scanCache, Queue<ProcessedNode<T>> openQueue, Function<TraversalContext<T>, BlockTraversalResult<T>> processor) {
        int nodeCost = context.isRoot() ? 0 : this.calculateNodeCost(context);
        if (nodeCost == Integer.MAX_VALUE) {
            return TraversalAction.REJECT_BLOCK;
        }
        BlockTraversalResult<T> result = processor.apply(context);
        TraversalAction action = result.getAction();
        if (!action.equals((Object)TraversalAction.ACCEPT_BLOCK)) {
            if (!action.equals((Object)TraversalAction.REJECT_BLOCK_ONCE)) {
                scanCache.setVisited(context.getNodePos(), true);
            }
            return action;
        }
        scanCache.setVisited(context.getNodePos(), true);
        openQueue.add(new ProcessedNode<T>(result.getNode(), nodeCost));
        return action;
    }

    private static class ScanCache {
        private final HashMap<Vec3i, ChunkSectionCache> values = new HashMap();
        private ChunkPos chunkOffset = ChunkPos.f_186419_;

        private ScanCache() {
        }

        private ChunkSectionCache getSectionCache(Vec3i pos) {
            return this.values.computeIfAbsent(pos, loc -> new ChunkSectionCache());
        }

        public void prepare(ChunkPos offset) {
            for (ChunkSectionCache cache : this.values.values()) {
                if (!cache.isDirty) continue;
                cache.resetRequired = true;
            }
            this.chunkOffset = offset;
        }

        public boolean isVisited(BlockPos pos) {
            int section;
            int x = pos.m_123341_() - (this.chunkOffset.f_45578_ << 4);
            int y = pos.m_123342_();
            int z = pos.m_123343_() - (this.chunkOffset.f_45579_ << 4);
            ChunkSectionCache cache = this.values.get(new Vec3i(x >> 4, z >> 4, section = y >> 4));
            if (cache == null) {
                return false;
            }
            if (cache.resetRequired) {
                cache.reset();
                return false;
            }
            return cache.visited[x & 0xF][y & 0xF][z & 0xF];
        }

        public void setVisited(BlockPos pos, boolean visited) {
            int x = pos.m_123341_() - (this.chunkOffset.f_45578_ << 4);
            int y = pos.m_123342_();
            int z = pos.m_123343_() - (this.chunkOffset.f_45579_ << 4);
            int section = y >> 4;
            ChunkSectionCache cache = this.getSectionCache(new Vec3i(x >> 4, z >> 4, section));
            if (cache.resetRequired) {
                cache.reset();
            }
            cache.set(x & 0xF, y & 0xF, z & 0xF, visited);
        }
    }

    record ProcessedNode<T extends TraversedBlock<T>>(T traversedNode, int cost) {
    }

    private static class ChunkSectionCache {
        final boolean[][][] visited = new boolean[16][16][16];
        boolean isDirty = false;
        boolean resetRequired = false;

        private ChunkSectionCache() {
        }

        void set(int x, int y, int z, boolean value) {
            this.visited[x][y][z] = value;
            this.isDirty = this.isDirty || value;
        }

        void reset() {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        this.visited[x][y][z] = false;
                    }
                }
            }
            this.isDirty = false;
            this.resetRequired = false;
        }
    }
}

