/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.level.scan.algorithm;

import net.minecraft.core.BlockPos;
import xbigellx.rbp.internal.level.scan.TraversalContext;
import xbigellx.rbp.internal.level.scan.algorithm.BlockTraverseAlgorithm;

public class GridTraverseAlgorithm
extends BlockTraverseAlgorithm {
    private final int vGridSize;
    private final int hGridSize;
    private final int vCost;
    private final int nonGridCost;

    public GridTraverseAlgorithm(int vGridSize, int hGridSize, int vCost, int nonGridCost) {
        this.vGridSize = vGridSize;
        this.hGridSize = hGridSize;
        this.vCost = vCost;
        this.nonGridCost = nonGridCost;
    }

    @Override
    protected int calculateNodeCost(TraversalContext<?> context) {
        boolean gridLine;
        if (context.directionToParent().getAxis().isDiagonal()) {
            return Integer.MAX_VALUE;
        }
        BlockPos origin = context.getOrigin();
        BlockPos nodePos = context.getNodePos();
        int dx = Math.abs(origin.m_123341_() - nodePos.m_123341_());
        int dy = Math.abs(origin.m_123342_() - nodePos.m_123342_());
        int dz = Math.abs(origin.m_123343_() - nodePos.m_123343_());
        int baseCost = 1;
        boolean bl = gridLine = dx % this.hGridSize == 0 && dz % this.hGridSize == 0 || (dx % this.hGridSize == 0 || dz % this.hGridSize == 0) && dy % this.vGridSize == 0;
        if (!gridLine && (baseCost = this.nonGridCost) == Integer.MAX_VALUE) {
            return baseCost;
        }
        return baseCost * Math.max(dx, Math.max(dy * this.vCost, dz));
    }
}

