/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics;

import com.mojang.logging.LogUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xbigellx.rbp.RealisticBlockPhysics;
import xbigellx.rbp.internal.config.MainConfig;
import xbigellx.rbp.internal.entity.RealisticFallingBlockEntity;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.block.RBPBlockDefinition;
import xbigellx.rbp.internal.physics.BlockOperation;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.realisticphysics.RealisticPhysics;
import xbigellx.realisticphysics.internal.config.MainConfig;
import xbigellx.realisticphysics.internal.level.RPLevelAccessor;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.level.chunk.ChunkPriority;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;
import xbigellx.realisticphysics.internal.util.LevelUtil;
import xbigellx.realisticphysics.internal.util.PriorityChunkQueue;

public class BlockOperationScheduler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HashMap<ChunkPos, BlockOperationQueue> queue = new HashMap();
    private final Level mcLevel;
    private final RBPLevel level;
    private final HashMap<Player, PlayerCache> playerCache = new HashMap();
    private final Function<ScheduledBlock, Boolean> fallingBlockOperation;
    private final Function<ScheduledBlock, Boolean> breakBlockOperation;
    long tickCounter = 0L;
    int cleanupTimer = 0;

    public BlockOperationScheduler(Level mcLevel, RBPLevel level) {
        this.mcLevel = mcLevel;
        this.level = level;
        this.fallingBlockOperation = this.createFallingBlockOperation();
        this.breakBlockOperation = this.createBreakBlockOperation();
    }

    private int getFallingBlockRate() {
        MainConfig.Model config = RealisticBlockPhysics.configManager().getConfig().main();
        return config.performance().fallingBlockRate();
    }

    private int getChunkUpdateRange() {
        MainConfig.Model config = RealisticPhysics.configManager().getConfig().main();
        return config.performance().chunkUpdateRange();
    }

    private Function<ScheduledBlock, Boolean> createFallingBlockOperation() {
        return scheduledBlock -> {
            RPBlockContext blockContext = scheduledBlock.blockContext;
            BlockDefinition blockDef = blockContext.blockDefinition();
            if (!this.level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, ExtendedDirection.DOWN)) {
                if (blockDef.physics().breaksOnFalling()) {
                    this.mcLevel.m_46961_(blockContext.pos(), true);
                } else {
                    RealisticFallingBlockEntity.summon(this.mcLevel, this.level, blockContext.pos(), blockContext.blockState(), (RBPBlockDefinition)blockContext.blockDefinition());
                }
                return true;
            }
            return false;
        };
    }

    private Function<ScheduledBlock, Boolean> createBreakBlockOperation() {
        return scheduledBlock -> {
            boolean dropResources = this.level.physicsHelper().shouldBrokenBlockDropResources(scheduledBlock.blockContext.pos());
            this.mcLevel.m_46961_(scheduledBlock.blockContext.pos(), dropResources);
            return true;
        };
    }

    public void tick() {
        long now = System.currentTimeMillis();
        int fallingBlockRate = this.getFallingBlockRate();
        int chunkUpdateRange = this.getChunkUpdateRange();
        List<? extends Player> players = this.level.players();
        AtomicInteger summonedBlocks = new AtomicInteger();
        AtomicBoolean cancel = new AtomicBoolean();
        long start = System.currentTimeMillis();
        boolean p = this.tickCounter % 5L == 0L;
        for (Player player : players) {
            if (cancel.get()) break;
            AtomicInteger progress = new AtomicInteger();
            PlayerCache cache = this.playerCache.computeIfAbsent(player, x -> new PlayerCache());
            boolean done = LevelUtil.iterateSurroundingPlayerChunks((Player)player, (int)chunkUpdateRange, c -> {
                progress.getAndIncrement();
                if (progress.get() - 1 < cache.chunkProgress) {
                    return true;
                }
                BlockOperationQueue chunkQueue = this.queue.get(c);
                if (chunkQueue == null || chunkQueue.isEmpty()) {
                    return true;
                }
                ChunkPriority chunkPriority = RealisticPhysics.physicsManager().getChunkPriority((RPLevelAccessor)this.level, c);
                boolean highPriorityRange = chunkPriority.equals((Object)ChunkPriority.HIGH);
                int maxProcessed = chunkQueue.size();
                int processed = 0;
                while (!chunkQueue.isEmpty() && processed < maxProcessed) {
                    BlockState nowState;
                    if (summonedBlocks.get() >= fallingBlockRate || !p && cache.heightPriorityUpdates && !highPriorityRange) {
                        cancel.set(true);
                        break;
                    }
                    ScheduledBlock scheduledBlock = null;
                    if (highPriorityRange && (scheduledBlock = chunkQueue.poll(player, false)) != null) {
                        cache.heightPriorityUpdates = true;
                    }
                    if (scheduledBlock == null) {
                        scheduledBlock = chunkQueue.poll(player);
                    }
                    if (scheduledBlock == null) break;
                    RPBlockContext blockContext = scheduledBlock.blockContext;
                    BlockDefinition blockDef = blockContext.blockDefinition();
                    if (blockDef == null || !(nowState = this.level.getBlockState(blockContext.pos())).m_60734_().equals(blockContext.blockState().m_60734_())) continue;
                    ++processed;
                    Function<ScheduledBlock, Boolean> operator = switch (scheduledBlock.operation) {
                        case BlockOperation.FALL -> this.fallingBlockOperation;
                        case BlockOperation.BREAK -> this.breakBlockOperation;
                        default -> throw new IllegalStateException("Unsupported block operation type.");
                    };
                    Boolean result = operator.apply(scheduledBlock);
                    if (!result.booleanValue()) {
                        int sectionY = scheduledBlock.blockContext.pos().m_123342_() >> 4;
                        int sectionIndex = sectionY - this.level.getMinSection();
                        if (scheduledBlock.nextAttempt > now) {
                            chunkQueue.add(scheduledBlock, sectionIndex);
                            continue;
                        }
                        if (scheduledBlock.retryCount++ > 5) continue;
                        scheduledBlock.nextAttempt = System.currentTimeMillis() + 500L;
                        chunkQueue.add(scheduledBlock, sectionIndex);
                    }
                    if (highPriorityRange) {
                        cache.nearPriorityUpdates = true;
                        continue;
                    }
                    if (!cache.heightPriorityUpdates) continue;
                    break;
                }
                if (cancel.get()) {
                    if (cache.heightPriorityUpdates && !highPriorityRange) {
                        cache.reset();
                    } else {
                        cache.chunkProgress = processed > 0 ? progress.get() : progress.get() - 1;
                    }
                }
                return !cancel.get();
            });
            if (!done) continue;
            cache.reset();
        }
        if (this.cleanupTimer++ > 100) {
            this.flushPlayerCache();
            this.cleanupTimer = 0;
        }
        ++this.tickCounter;
    }

    public void clear(ChunkPos pos) {
        this.queue.remove(pos);
    }

    public void schedule(BlockOperation operation, RPBlockContext blockContext) {
        this.schedule(operation, blockContext, this.level.physics().physicsEngine().getBehaviour());
    }

    public void schedule(BlockOperation operation, RPBlockContext blockContext, PhysicsEngineBehaviour behaviour) {
        BlockPos blockPos = blockContext.pos();
        ChunkPos chunkPos = new ChunkPos(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
        if (this.isOperationScheduled(chunkPos, blockContext.pos(), operation)) {
            return;
        }
        if (!this.level.chunkExists(chunkPos)) {
            LOGGER.warn("Chunk is not loaded at {}. The block will not be scheduled.", (Object)chunkPos);
            return;
        }
        RPChunkAccessor chunk = this.level.getChunk(chunkPos);
        int chunkSectionIndex = chunk.getSectionIndex(blockPos);
        this.queue.putIfAbsent(chunkPos, new BlockOperationQueue(chunk));
        BlockOperationQueue blockQueue = this.queue.get(chunkPos);
        blockQueue.add(new ScheduledBlock(operation, blockContext), chunkSectionIndex);
        int chunkUpdateRange = this.getChunkUpdateRange();
        if (LevelUtil.isAnyPlayerWithinChunkRange((RPLevelAccessor)this.level, (ChunkPos)chunkPos, (int)chunkUpdateRange)) {
            behaviour.onBlockOperationScheduled(this.level, blockContext, operation);
        }
    }

    private void flushPlayerCache() {
        PlayerCache cache;
        for (Player player : this.level.players()) {
            cache = this.playerCache.get(player);
            if (cache == null) continue;
            cache.persist = true;
        }
        for (Player player : this.playerCache.keySet()) {
            cache = this.playerCache.get(player);
            if (!cache.persist) {
                this.playerCache.remove(cache);
                continue;
            }
            cache.persist = false;
        }
    }

    public boolean isAnyOperationScheduled(BlockPos pos) {
        return this.isOperationScheduled(new ChunkPos(pos), pos, BlockOperation.FALL) || this.isOperationScheduled(new ChunkPos(pos), pos, BlockOperation.BREAK);
    }

    public boolean isOperationScheduled(BlockPos pos, BlockOperation operation) {
        return this.isOperationScheduled(new ChunkPos(pos), pos, operation);
    }

    private boolean isOperationScheduled(ChunkPos chunkPos, BlockPos pos, BlockOperation operation) {
        BlockOperationQueue chunkQueue = this.queue.get(chunkPos);
        if (chunkQueue == null) {
            return false;
        }
        RPBlockContext blockContext = this.level.getBlockContext(pos);
        ScheduledBlock entry = new ScheduledBlock(operation, blockContext);
        return chunkQueue.contains(entry);
    }

    private static class PlayerCache {
        int chunkProgress;
        boolean nearPriorityUpdates = false;
        boolean heightPriorityUpdates = false;
        boolean persist = false;

        private PlayerCache() {
        }

        void reset() {
            this.chunkProgress = 0;
            this.nearPriorityUpdates = false;
            this.heightPriorityUpdates = false;
        }
    }

    private static class BlockOperationQueue {
        private final Lock lock = new ReentrantLock(true);
        private static final Comparator<ScheduledBlock> SCHEDULE_COMPARATOR = Comparator.comparingLong(ScheduledBlock::getNextAttempt).thenComparingInt(ScheduledBlock::getOperationPriority).thenComparingInt(ScheduledBlock::getY);
        private final RPChunkAccessor chunk;
        private final HashSet<ScheduledBlock> itemSet = new HashSet();
        private final PriorityChunkQueue<ScheduledBlock> queue;

        public BlockOperationQueue(RPChunkAccessor chunk) {
            this.chunk = chunk;
            this.queue = new PriorityChunkQueue(chunk, SCHEDULE_COMPARATOR, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ScheduledBlock scheduledBlock, int sectionIndex) {
            try {
                this.lock.lock();
                boolean exists = this.contains(scheduledBlock);
                if (!exists) {
                    this.queue.add((Object)scheduledBlock, sectionIndex);
                    this.itemSet.add(scheduledBlock);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public ScheduledBlock poll(Player player) {
            try {
                this.lock.lock();
                ScheduledBlock item = (ScheduledBlock)this.queue.poll(player);
                if (item != null) {
                    this.itemSet.remove(item);
                }
                ScheduledBlock scheduledBlock = item;
                return scheduledBlock;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public ScheduledBlock poll(Player player, boolean highPriority) {
            try {
                this.lock.lock();
                ScheduledBlock item = (ScheduledBlock)this.queue.poll(player, highPriority);
                if (item != null) {
                    this.itemSet.remove(item);
                }
                ScheduledBlock scheduledBlock = item;
                return scheduledBlock;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean contains(ScheduledBlock task) {
            return this.itemSet.contains(task);
        }

        public void clear() {
            try {
                this.lock.lock();
                this.queue.clear();
                this.itemSet.clear();
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isEmpty() {
            return this.itemSet.isEmpty();
        }

        public int size() {
            return this.itemSet.size();
        }
    }

    private static class ScheduledBlock {
        private final BlockOperation operation;
        private final RPBlockContext blockContext;
        private int retryCount = 0;
        private long nextAttempt = 0L;
        private final int yPos;
        private final int opPriority;

        public ScheduledBlock(BlockOperation operation, RPBlockContext blockContext) {
            this.operation = operation;
            this.blockContext = blockContext;
            this.yPos = blockContext.pos().m_123342_();
            this.nextAttempt = System.currentTimeMillis();
            this.opPriority = switch (operation) {
                default -> throw new IncompatibleClassChangeError();
                case BlockOperation.BREAK -> 0;
                case BlockOperation.FALL -> 1;
            };
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.operation).append((Object)this.blockContext.pos()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScheduledBlock)) {
                return false;
            }
            ScheduledBlock task = (ScheduledBlock)obj;
            if (obj == this) {
                return true;
            }
            return new EqualsBuilder().append((Object)this.operation, (Object)task.operation).append((Object)this.blockContext.pos(), (Object)task.blockContext.pos()).isEquals();
        }

        public int getY() {
            return this.yPos;
        }

        public int getOperationPriority() {
            return this.opPriority;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public long getNextAttempt() {
            return this.nextAttempt;
        }
    }
}

