/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.chunk.RBPChunkData;
import xbigellx.rbp.internal.physics.ChunkAnalyser;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.realisticphysics.internal.event.ChunkTasksClearedEvent;
import xbigellx.realisticphysics.internal.level.RPLevelAccessor;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.level.chunk.RPChunk;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.physics.PhysicsHandler;

public class BlockPhysicsHandler
implements PhysicsHandler {
    private final Level mcLevel;
    private final RBPLevel level;
    private final ChunkAnalyser chunkAnalyser;

    public BlockPhysicsHandler(Level mcLevel, RBPLevel level) {
        this.mcLevel = mcLevel;
        this.level = level;
        this.chunkAnalyser = new ChunkAnalyser(this.level);
    }

    public void start() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void shutdown() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        if (!event.level.equals(this.mcLevel)) {
            return;
        }
        this.chunkAnalyser.tick();
        this.level.blockStabilityManager().tick();
        this.level.blockOperationScheduler().tick();
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!event.getLevel().equals(this.mcLevel)) {
            return;
        }
        BlockDefinition blockDef = this.level.physics().blockDefinitions().get(event.getState());
        RPBlockContext blockContext = new RPBlockContext(event.getPos(), event.getState(), blockDef);
        PhysicsEngineBehaviour behaviour = this.level.physics().physicsEngine().getBehaviour();
        behaviour.onBlockPlaced(this.level, blockContext, event.getEntity());
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getLevel().equals(this.mcLevel)) {
            return;
        }
        BlockDefinition blockDef = this.level.physics().blockDefinitions().get(event.getState());
        RPBlockContext blockContext = new RPBlockContext(event.getPos(), event.getState(), blockDef);
        PhysicsEngineBehaviour behaviour = this.level.physics().physicsEngine().getBehaviour();
        behaviour.onBlockBreak(this.level, blockContext, (Entity)event.getPlayer());
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        if (!event.getLevel().equals(this.mcLevel)) {
            return;
        }
        PhysicsEngineBehaviour behaviour = this.level.physics().physicsEngine().getBehaviour();
        behaviour.onExplosionDetonate(this.level, event.getExplosion());
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getLevel().equals(this.mcLevel)) {
            return;
        }
        RPBlockContext blockContext = this.level.getBlockContext(event.getPos());
        PhysicsEngineBehaviour behaviour = this.level.physics().physicsEngine().getBehaviour();
        behaviour.onBlockInteract(this.level, blockContext, (Entity)event.getEntity());
    }

    @SubscribeEvent
    public void onBlockNeighbourNotify(BlockEvent.NeighborNotifyEvent event) {
        if (!event.getLevel().equals(this.mcLevel)) {
            return;
        }
        BlockDefinition blockDef = this.level.physics().blockDefinitions().get(event.getState());
        RPBlockContext blockContext = new RPBlockContext(event.getPos(), event.getState(), blockDef);
        PhysicsEngineBehaviour behaviour = this.level.physics().physicsEngine().getBehaviour();
        behaviour.onBlockNeighbourNotify(this.level, blockContext);
    }

    @SubscribeEvent
    public void onChunkTasksCleared(ChunkTasksClearedEvent event) {
        this.chunkAnalyser.resetChunk(event.getChunkPos());
        this.level.blockOperationScheduler().clear(event.getChunkPos());
    }

    public void onChunkLoad(RPChunk rpChunk) {
        RBPChunkData chunkData = this.level.chunkDataManager().create((RPChunkAccessor)rpChunk);
        chunkData.setAnalysisRequired();
    }

    public void onChunkUnload(RPChunk rpChunk) {
    }

    public RPLevelAccessor getLevel() {
        return this.level;
    }
}

