/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xbigellx.rbp.RealisticBlockPhysics;
import xbigellx.rbp.internal.config.ModConfiguration;
import xbigellx.rbp.internal.config.WorldDefinitionConfig;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.RBPLevelPhysics;
import xbigellx.rbp.internal.level.RBPWorldDefinition;
import xbigellx.rbp.internal.physics.BlockPhysicsHandler;
import xbigellx.rbp.internal.physics.engine.ConfigBasedPhysicsEngine;
import xbigellx.rbp.internal.physics.engine.LegacyEngine;
import xbigellx.rbp.internal.physics.engine.PhysicsEngine;
import xbigellx.rbp.internal.physics.engine.RealisticEngine;
import xbigellx.rbp.internal.physics.engine.SimpleEngine;
import xbigellx.realisticphysics.internal.level.RPLevelAccessor;
import xbigellx.realisticphysics.internal.physics.PhysicsHandler;
import xbigellx.realisticphysics.internal.physics.PhysicsHandlerFactory;

public class BlockPhysicsHandlerFactory
implements PhysicsHandlerFactory {
    private static final String REALISTIC_ENGINE_ID = "realistic";
    private static final String LEGACY_ENGINE_ID = "legacy";
    private static final String SIMPLE_ENGINE_ID = "simple";
    private static final String HAVOC_ENGINE_ID = "havoc";

    public PhysicsHandler create(Level mcLevel, RPLevelAccessor rpLevel) {
        ResourceLocation dimensionId = mcLevel.m_220362_().m_135782_();
        ModConfiguration modConfig = RealisticBlockPhysics.configManager().getConfig();
        Optional<WorldDefinitionConfig.Model> worldDefConfig = this.findWorldDefinition(modConfig, dimensionId);
        if (worldDefConfig.isEmpty()) {
            throw new RuntimeException("There is no world definition defined for the dimension '" + dimensionId + "'.");
        }
        boolean globalChunkAnalysisEnabled = modConfig.main().chunkAnalysis().enabled();
        RBPWorldDefinition worldDef = worldDefConfig.get().worldDefinition();
        if (!globalChunkAnalysisEnabled) {
            worldDef = worldDef.with(worldDef.chunkAnalysis().withEnabled(false));
        }
        PhysicsEngine physicsEngine = this.resolvePhysicsEngine(worldDef.physics().physicsEngine(), worldDef);
        RBPLevelPhysics levelPhysics = new RBPLevelPhysics(rpLevel.physics(), new ConfigBasedPhysicsEngine(physicsEngine), worldDef);
        return new BlockPhysicsHandler(mcLevel, new RBPLevel(mcLevel, rpLevel, levelPhysics));
    }

    public boolean isLevelSupported(Level level) {
        ResourceLocation dimensionId = level.m_220362_().m_135782_();
        ModConfiguration modConfig = RealisticBlockPhysics.configManager().getConfig();
        Optional<WorldDefinitionConfig.Model> worldDef = this.findWorldDefinition(modConfig, dimensionId);
        return worldDef.map(model -> model.worldDefinition().physicsEnabled()).orElse(false);
    }

    private Optional<WorldDefinitionConfig.Model> findWorldDefinition(ModConfiguration modConfig, ResourceLocation dimensionId) {
        return modConfig.worldDefinitions().stream().filter(w -> w.dimensionIds().contains(dimensionId.toString())).findFirst();
    }

    private PhysicsEngine resolvePhysicsEngine(String engineId, RBPWorldDefinition worldDef) {
        return switch (engineId) {
            case REALISTIC_ENGINE_ID -> new RealisticEngine(worldDef);
            case LEGACY_ENGINE_ID -> new LegacyEngine(worldDef);
            case SIMPLE_ENGINE_ID -> new SimpleEngine();
            default -> throw new IllegalArgumentException("A block physics engine does not exist with ID '" + engineId + "'.");
        };
    }
}

