/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.realisticphysics.RealisticPhysics;
import xbigellx.realisticphysics.internal.level.RPLevelAccessor;
import xbigellx.realisticphysics.internal.level.chunk.ChunkPriority;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public final class BlockStabilityManager {
    private final HashMap<ChunkPos, HashMap<BlockPos, Long>> chunkMap = new HashMap();
    private final RBPLevel level;
    private final Lock lock = new ReentrantLock();
    private int cleanupTimer = 0;

    public BlockStabilityManager(RBPLevel level) {
        this.level = level;
    }

    public void tick() {
        if (this.cleanupTimer++ > 100) {
            this.cleanupChunks();
            this.cleanupTimer = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupChunks() {
        try {
            this.lock.lock();
            Iterator<Map.Entry<ChunkPos, HashMap<BlockPos, Long>>> iterator = this.chunkMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ChunkPos, HashMap<BlockPos, Long>> entry = iterator.next();
                ChunkPos key = entry.getKey();
                ChunkPriority priority = RealisticPhysics.physicsManager().getChunkPriority((RPLevelAccessor)this.level, key);
                if (!priority.equals((Object)ChunkPriority.NONE)) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstabilityTime(BlockPos pos, long duration) {
        try {
            this.lock.lock();
            ChunkPos key = new ChunkPos(pos);
            this.chunkMap.putIfAbsent(key, new HashMap());
            long time = System.currentTimeMillis() + duration;
            this.chunkMap.get(key).put(pos, time);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInstabilityTime(BlockPos pos) {
        try {
            this.lock.lock();
            ChunkPos key = new ChunkPos(pos);
            HashMap<BlockPos, Long> map = this.chunkMap.get(key);
            if (map == null) {
                return;
            }
            map.remove(pos);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void evaluateSurroundingBlocks(BlockPos pos, ExtendedDirection[] directions, BiConsumer<BlockPos, Boolean> consumer) {
        for (ExtendedDirection dir : directions) {
            BlockPos nPos;
            consumer.accept(nPos, !this.isBlockUnstable(nPos = pos.m_121955_(dir.getNormal())));
        }
    }

    public void evaluateSurroundingBlocks(BlockPos pos, BiConsumer<BlockPos, Boolean> consumer) {
        this.evaluateSurroundingBlocks(pos, ExtendedDirection.values(), consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlockUnstable(BlockPos pos) {
        ChunkPos key = new ChunkPos(pos);
        HashMap<BlockPos, Long> map = this.chunkMap.get(key);
        if (map != null) {
            Long time = map.get(pos);
            if (time == null || time < System.currentTimeMillis()) {
                try {
                    this.lock.lock();
                    map.remove(pos);
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                return true;
            }
        }
        return this.level.blockOperationScheduler().isAnyOperationScheduled(pos);
    }
}

