/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import xbigellx.rbp.RealisticBlockPhysics;
import xbigellx.rbp.internal.config.MainConfig;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.chunk.ChunkAnalysisStatus;
import xbigellx.rbp.internal.level.chunk.RBPChunkData;
import xbigellx.rbp.internal.physics.task.AnalyseChunkTask;
import xbigellx.realisticphysics.RealisticPhysics;
import xbigellx.realisticphysics.internal.config.MainConfig;
import xbigellx.realisticphysics.internal.level.RPLevelAccessor;
import xbigellx.realisticphysics.internal.level.chunk.ChunkPriority;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.physics.task.PhysicsTask;
import xbigellx.realisticphysics.internal.physics.task.TaskPriority;
import xbigellx.realisticphysics.internal.util.LevelUtil;

public class ChunkAnalyser {
    private static final int LOW_PRIORITY_TICKS = 100;
    private static final int COOL_DOWN_TICKS = 0;
    private final RBPLevel level;
    private final Set<ChunkPos> trackedChunks = new HashSet<ChunkPos>();
    private int cleanupTimer = 0;
    private int tickWait = 0;

    public ChunkAnalyser(RBPLevel level) {
        this.level = level;
    }

    public void tick() {
        MainConfig.Model rbpConfig = RealisticBlockPhysics.configManager().getConfig().main();
        MainConfig.Model rpConfig = RealisticPhysics.configManager().getConfig().main();
        List<? extends Player> players = this.level.players();
        int chunkUpdateRange = Math.min(rbpConfig.chunkAnalysis().activeRange(), rpConfig.performance().chunkUpdateRange());
        if (this.tickWait-- > 0) {
            return;
        }
        boolean highPriority = this.tickWait > -100;
        int queuedTasks = this.level.taskManager().totalQueuedTasks() - this.level.taskManager().totalQueuedTasks(ChunkPriority.NONE);
        AtomicBoolean cancel = new AtomicBoolean();
        for (Player player : players) {
            if (cancel.get() || queuedTasks > 16) break;
            LevelUtil.iterateSurroundingPlayerChunks((Player)player, (int)chunkUpdateRange, c -> {
                RBPChunkData chunkData = this.level.chunkDataManager().get((ChunkPos)c);
                if (chunkData == null || !chunkData.isAnalysisRequired()) {
                    return true;
                }
                if (!this.level.chunkExists((ChunkPos)c)) {
                    return true;
                }
                RPChunkAccessor chunk = this.level.getChunk((ChunkPos)c);
                boolean analysed = this.analyseChunk(chunk, chunkData, player, highPriority);
                this.trackedChunks.add((ChunkPos)c);
                if (analysed) {
                    this.tickWait = highPriority ? 0 : 100;
                    cancel.set(true);
                }
                return !analysed;
            });
        }
        if (this.cleanupTimer++ > 100) {
            this.flushChunks();
            this.cleanupTimer = 0;
        }
    }

    public void resetChunk(ChunkPos pos) {
        RBPChunkData chunkData = this.level.chunkDataManager().get(pos);
        if (chunkData != null) {
            chunkData.setAnalysisRequired();
        }
    }

    private void flushChunks() {
        Iterator<ChunkPos> i = this.trackedChunks.iterator();
        while (i.hasNext()) {
            ChunkPos pos = i.next();
            boolean remove = false;
            if (!this.level.chunkExists(pos)) {
                remove = true;
            } else if (!LevelUtil.isAnyPlayerWithinChunkRange((RPLevelAccessor)this.level, (ChunkPos)pos, (int)8)) {
                remove = true;
                this.resetChunk(pos);
            }
            if (!remove) continue;
            i.remove();
        }
    }

    private boolean analyseChunk(RPChunkAccessor chunk, RBPChunkData chunkData, Player player, boolean highPriority) {
        int startY = chunk.getMaxSection() - 1;
        int endY = chunk.getMinSection();
        int maxSection = this.level.physics().settings().chunkAnalysis().maxAltitude() >> 4;
        int minSection = this.level.physics().settings().chunkAnalysis().minAltitude() >> 4;
        int playerSection = player.m_20183_().m_123342_() >> 4;
        for (int i = startY; i >= endY; --i) {
            if (i < minSection || i > maxSection || highPriority && i < playerSection - 2) continue;
            int sectionIndex = chunk.getSectionIndexFromSectionY(i);
            RBPChunkData.ChunkSectionData sectionData = chunkData.getSectionData(sectionIndex);
            if (chunk.getSection(sectionIndex).hasOnlyAir()) {
                sectionData.setAnalysisStatus(ChunkAnalysisStatus.ANALYSED);
                continue;
            }
            if (!sectionData.getAnalysisStatus().equals((Object)ChunkAnalysisStatus.REQUIRED)) continue;
            if (!this.level.physics().settings().chunkAnalysis().enabled()) {
                sectionData.setAnalysisStatus(ChunkAnalysisStatus.ANALYSED);
                continue;
            }
            sectionData.setAnalysisStatus(ChunkAnalysisStatus.ANALYSING);
            this.level.taskManager().addTask((PhysicsTask)new AnalyseChunkTask(this.level, chunk, sectionIndex), TaskPriority.NORMAL);
            return true;
        }
        return false;
    }
}

