/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import xbigellx.rbp.RealisticBlockPhysics;
import xbigellx.rbp.internal.config.ModConfiguration;
import xbigellx.rbp.internal.entity.RealisticFallingBlockEntity;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.task.BlockIntegrityCheckTask;
import xbigellx.rbp.internal.util.BlockBoundsExtender;
import xbigellx.rbp.internal.util.DirectionConstants;
import xbigellx.realisticphysics.internal.level.RPDimensionType;
import xbigellx.realisticphysics.internal.level.RPLevelAccessor;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.physics.task.PhysicsTask;
import xbigellx.realisticphysics.internal.physics.task.TaskPriority;
import xbigellx.realisticphysics.internal.util.DirectionHelper;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;
import xbigellx.realisticphysics.internal.util.LevelUtil;

public class PhysicsHelper {
    private final Level mcLevel;
    private final RBPLevel level;
    private static final List<AABB> UNIT_CUBE_BOUNDS = List.of(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    private static final Direction[] SLIDE_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};

    public PhysicsHelper(Level mcLevel, RBPLevel level) {
        this.mcLevel = mcLevel;
        this.level = level;
    }

    private int getPillarYLimit(BlockPos origin, boolean up) {
        int limit;
        Direction direction;
        RPChunkAccessor chunk = this.level.getChunk(origin);
        RPDimensionType dimension = this.level.dimensionType();
        if (!up) {
            direction = Direction.DOWN;
            limit = dimension.minBuildHeight();
        } else {
            direction = Direction.UP;
            limit = dimension.maxBuildHeight();
        }
        for (int y = 0; y <= Math.abs(origin.m_123342_() - limit); ++y) {
            RPBlockContext blockContext = chunk.getBlockContext(origin.m_5484_(direction, y));
            boolean isPillarBlock = this.isBlockFaceTouchingNeighbour(blockContext, ExtendedDirection.of((Direction)direction).getOpposite());
            if (isPillarBlock) continue;
            return origin.m_5484_(direction, y - 1).m_123342_();
        }
        return limit;
    }

    public final int getPillarMaxY(BlockPos origin) {
        return this.getPillarYLimit(origin, true);
    }

    public final int getPillarMaxY(BlockPos origin, int maxSearch) {
        return this.getPillarYLimit(origin, true);
    }

    public final int getPillarMinY(BlockPos origin) {
        return this.getPillarYLimit(origin, false);
    }

    public final int getPillarMinY(BlockPos origin, int maxSearch) {
        return this.getPillarYLimit(origin, false);
    }

    public boolean isPassableBlock(RPBlockContext blockContext) {
        return FallingBlock.m_53241_((BlockState)blockContext.blockState());
    }

    public boolean isPassableBlock(BlockPos pos) {
        return this.isPassableBlock(this.level.getBlockContext(pos));
    }

    public boolean canBlockBeFallenInto(RPBlockContext blockContext, boolean ignoreLiquids) {
        return !(ignoreLiquids && blockContext.blockState().m_60767_().m_76332_() || !this.isPassableBlock(blockContext) && this.isBlockFaceAtEdge(blockContext, Direction.UP));
    }

    public boolean canBlockBeFallenInto(RPBlockContext blockContext) {
        return this.canBlockBeFallenInto(blockContext, false);
    }

    public boolean canBlockBeFallenInto(BlockPos pos, boolean ignoreLiquids) {
        return this.canBlockBeFallenInto(this.level.getBlockContext(pos), ignoreLiquids);
    }

    public boolean canBlockBeFallenInto(BlockPos pos) {
        return this.canBlockBeFallenInto(this.level.getBlockContext(pos), false);
    }

    public double getBlockVolume(RPBlockContext blockContext) {
        double total = 0.0;
        List<AABB> bounds = this.getBlockCollisionBounds(blockContext);
        for (AABB bound : bounds) {
            total += bound.m_82362_() * bound.m_82376_() * bound.m_82385_();
        }
        return Math.min(1.0, total);
    }

    public boolean isBlockFaceAtEdge(RPBlockContext blockContext, Direction face) {
        BlockDefinition blockDef = blockContext.blockDefinition();
        Direction blockDir = PhysicsHelper.getRelativeBlockDirection(blockContext, face);
        if (blockDef != null && blockDef.physics().extendedCollisionBounds().evaluate(blockDir)) {
            return true;
        }
        VoxelShape voxelShape = blockContext.blockState().m_60812_((BlockGetter)this.mcLevel, blockContext.pos()).m_83263_(face);
        if (voxelShape.m_83281_()) {
            return false;
        }
        if (face.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE)) {
            return voxelShape.m_83215_().m_82374_(blockDir.m_122434_()) == 1.0;
        }
        return voxelShape.m_83215_().m_82340_(blockDir.m_122434_()) == 0.0;
    }

    private static Direction getRelativeBlockDirection(RPBlockContext blockContext, Direction face) {
        Direction relative = face;
        if (face.m_122434_().m_122479_()) {
            Direction blockDir = LevelUtil.getBlockOrientationOrDefault((BlockState)blockContext.blockState(), (Direction)Direction.NORTH);
            relative = DirectionHelper.getRelativeDirection((Direction)blockDir, (Direction)face);
        }
        return relative;
    }

    public List<AABB> getBlockCollisionBounds(RPBlockContext blockContext) {
        BlockDefinition blockDef = blockContext.blockDefinition();
        if (blockDef != null && blockDef.physics().extendedCollisionBounds().isFullUnitCube()) {
            return UNIT_CUBE_BOUNDS;
        }
        List aabbs = blockContext.blockState().m_60812_((BlockGetter)this.mcLevel, blockContext.pos()).m_83299_();
        if (blockDef != null) {
            Direction vRelative = PhysicsHelper.getRelativeBlockDirection(blockContext, Direction.DOWN);
            Direction hRelative = PhysicsHelper.getRelativeBlockDirection(blockContext, Direction.NORTH);
            return BlockBoundsExtender.extendBounds(aabbs, vRelative, hRelative, blockDef.physics().extendedCollisionBounds().up(), blockDef.physics().extendedCollisionBounds().down(), blockDef.physics().extendedCollisionBounds().north(), blockDef.physics().extendedCollisionBounds().east(), blockDef.physics().extendedCollisionBounds().south(), blockDef.physics().extendedCollisionBounds().west());
        }
        return aabbs;
    }

    public boolean isBlockFaceTouchingNeighbour(RPBlockContext blockContext, ExtendedDirection face) {
        return this.isBlockFaceTouchingNeighbour(blockContext, face, false, false);
    }

    public boolean isBlockFaceTouchingNeighbour(RPBlockContext blockContext, ExtendedDirection face, boolean allowDiagonal) {
        return this.isBlockFaceTouchingNeighbour(blockContext, face, allowDiagonal, false);
    }

    public boolean isBlockFaceTouchingNeighbour(RPBlockContext blockContext, ExtendedDirection face, boolean allowDiagonal, boolean allowLiquids) {
        BlockDefinition blockDef = blockContext.blockDefinition();
        BlockPos nPos = blockContext.pos().m_121955_(face.getNormal());
        RPBlockContext nBlockContext = this.level.getBlockContext(nPos);
        if (allowLiquids && (blockContext.blockState().m_60767_().m_76332_() || nBlockContext.blockState().m_60767_().m_76332_())) {
            return true;
        }
        List<AABB> collisionBounds1 = this.getBlockCollisionBounds(blockContext);
        List<AABB> collisionBounds2 = this.getBlockCollisionBounds(this.level.getBlockContext(nPos));
        double m = 0.02;
        if ((blockDef == null || !allowDiagonal) && face.getAxis().isDiagonal()) {
            return false;
        }
        Vec3i n = face.getNormal();
        for (AABB bounds : collisionBounds1) {
            bounds = bounds.m_82400_(0.02);
            for (AABB nBounds : collisionBounds2) {
                if (!bounds.m_82381_(nBounds = nBounds.m_82386_((double)n.m_123341_(), (double)n.m_123342_(), (double)n.m_123343_()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldBrokenBlockDropResources(BlockPos pos) {
        ModConfiguration modConfig = RealisticBlockPhysics.configManager().getConfig();
        return Math.random() < modConfig.main().physics().brokenBlockItemDropChance();
    }

    public void scheduleBlockNeighbourFallChecks(BlockPos origin, TaskPriority priority, int integrityDistance) {
        boolean downWest;
        boolean upWest;
        ModConfiguration modConfig = RealisticBlockPhysics.configManager().getConfig();
        boolean integrityChecksEnabled = modConfig.main().performance().detailedIntegrityScans();
        boolean integrityCheck = false;
        if (integrityChecksEnabled) {
            boolean bl = integrityCheck = integrityDistance > 0 && LevelUtil.isAnyPlayerWithinChessboardDistance((RPLevelAccessor)this.level, (BlockPos)origin, (int)8);
        }
        if (integrityCheck) {
            RPBlockContext upContext = this.level.getBlockContext(origin.m_7494_());
            this.scheduleFallCheck(upContext, priority, () -> new BlockIntegrityCheckTask(this.level, upContext.pos(), true));
        } else {
            this.scheduleFallCheck(origin, ExtendedDirection.UP, priority);
        }
        boolean west = this.scheduleFallCheck(origin, ExtendedDirection.WEST, priority);
        boolean east = this.scheduleFallCheck(origin, ExtendedDirection.EAST, priority);
        boolean north = this.scheduleFallCheck(origin, ExtendedDirection.NORTH, priority);
        boolean south = this.scheduleFallCheck(origin, ExtendedDirection.SOUTH, priority);
        this.scheduleFallCheck(origin, ExtendedDirection.DOWN, priority);
        boolean northEast = !north && !east && this.scheduleFallCheck(origin, ExtendedDirection.NORTH_EAST, priority);
        boolean southEast = !east && !south && this.scheduleFallCheck(origin, ExtendedDirection.SOUTH_EAST, priority);
        boolean southWest = !south && !west && this.scheduleFallCheck(origin, ExtendedDirection.SOUTH_WEST, priority);
        boolean northWest = !west && !north && this.scheduleFallCheck(origin, ExtendedDirection.NORTH_WEST, priority);
        boolean upNorth = !north && !northWest && !northEast && this.scheduleFallCheck(origin, ExtendedDirection.UP_NORTH, priority);
        boolean upEast = !east && !northEast && !southEast && this.scheduleFallCheck(origin, ExtendedDirection.UP_EAST, priority);
        boolean upSouth = !south && !southEast && !southWest && this.scheduleFallCheck(origin, ExtendedDirection.UP_SOUTH, priority);
        boolean bl = upWest = !west && !southWest && !northWest && this.scheduleFallCheck(origin, ExtendedDirection.UP_WEST, priority);
        if (!(northEast || upNorth || upEast)) {
            this.scheduleFallCheck(origin, ExtendedDirection.UP_NORTH_EAST, priority);
        }
        if (!(southEast || upEast || upSouth)) {
            this.scheduleFallCheck(origin, ExtendedDirection.UP_SOUTH_EAST, priority);
        }
        if (!(southWest || upSouth || upWest)) {
            this.scheduleFallCheck(origin, ExtendedDirection.UP_SOUTH_WEST, priority);
        }
        if (!(northWest || upWest || upNorth)) {
            this.scheduleFallCheck(origin, ExtendedDirection.UP_NORTH_WEST, priority);
        }
        boolean downNorth = !north && !northWest && !northEast && this.scheduleFallCheck(origin, ExtendedDirection.DOWN_NORTH, priority);
        boolean downEast = !east && !northEast && !southEast && this.scheduleFallCheck(origin, ExtendedDirection.DOWN_EAST, priority);
        boolean downSouth = !south && !southEast && !southWest && this.scheduleFallCheck(origin, ExtendedDirection.DOWN_SOUTH, priority);
        boolean bl2 = downWest = !west && !southWest && !northWest && this.scheduleFallCheck(origin, ExtendedDirection.DOWN_WEST, priority);
        if (!(northEast || downNorth || downEast)) {
            this.scheduleFallCheck(origin, ExtendedDirection.DOWN_NORTH_EAST, priority);
        }
        if (!(southEast || downEast || downSouth)) {
            this.scheduleFallCheck(origin, ExtendedDirection.DOWN_SOUTH_EAST, priority);
        }
        if (!(southWest || downSouth || downWest)) {
            this.scheduleFallCheck(origin, ExtendedDirection.DOWN_SOUTH_WEST, priority);
        }
        if (!(northWest || downWest || downNorth)) {
            this.scheduleFallCheck(origin, ExtendedDirection.DOWN_NORTH_WEST, priority);
        }
    }

    private boolean scheduleFallCheck(RPBlockContext blockContext, TaskPriority taskPriority, Supplier<PhysicsTask> supplier) {
        if (blockContext.blockDefinition() == null || this.level.blockOperationScheduler().isAnyOperationScheduled(blockContext.pos())) {
            return false;
        }
        if (!this.level.chunkExists(new ChunkPos(blockContext.pos()))) {
            return false;
        }
        PhysicsTask task = supplier.get();
        this.level.taskManager().addTask(task, taskPriority);
        return true;
    }

    private boolean scheduleFallCheck(BlockPos origin, ExtendedDirection dir, TaskPriority taskPriority) {
        RPBlockContext blockContext = this.level.getBlockContext(origin.m_121955_(dir.getNormal()));
        if (dir.getAxis().isDiagonal() && !this.canBlockBeFallenInto(blockContext.pos().m_7495_())) {
            return false;
        }
        return this.scheduleFallCheck(blockContext, taskPriority, () -> new BlockIntegrityCheckTask(this.level, blockContext.pos(), false));
    }

    public boolean isBlockEncased(RPBlockContext blockContext) {
        return this.isBlockEncased(blockContext, ExtendedDirection.ADJACENT_VALUES, false);
    }

    public boolean isBlockEncased(RPBlockContext blockContext, boolean allowLiquids) {
        return this.isBlockEncased(blockContext, ExtendedDirection.ADJACENT_VALUES, allowLiquids);
    }

    public boolean isBlockEncased(RPBlockContext blockContext, ExtendedDirection[] directions) {
        return this.isBlockEncased(blockContext, directions, false);
    }

    public boolean isBlockEncased(RPBlockContext blockContext, ExtendedDirection[] directions, boolean allowLiquids) {
        for (ExtendedDirection dir : directions) {
            BlockPos nPos = blockContext.pos().m_121955_(dir.getNormal());
            if (!this.level.blockStabilityManager().isBlockUnstable(nPos) && !this.canBlockBeFallenInto(nPos, allowLiquids)) continue;
            return false;
        }
        return true;
    }

    public int countEncasingBlocks(BlockPos pos, ExtendedDirection[] directions) {
        return this.countEncasingBlocks(this.level.getBlockContext(pos), directions, false);
    }

    public int countEncasingBlocks(RPBlockContext blockContext, ExtendedDirection[] directions) {
        return this.countEncasingBlocks(blockContext, directions, false);
    }

    public int countEncasingBlocks(RPBlockContext blockContext, ExtendedDirection[] directions, boolean allowLiquids) {
        int count = 0;
        for (ExtendedDirection dir : directions) {
            if (this.canBlockBeFallenInto(blockContext.pos().m_121955_(dir.getNormal()), allowLiquids)) continue;
            ++count;
        }
        return count;
    }

    @Nullable
    public Direction getRandomBlockSlideDirection(BlockPos pos, double baseChance) {
        return this.getRandomBlockSlideDirection(pos, baseChance, true);
    }

    @Nullable
    public Direction getRandomBlockSlideDirection(BlockPos pos, double baseChance, boolean requireDrop) {
        if (Math.random() > baseChance) {
            return null;
        }
        ArrayList<Direction> potentialResults = new ArrayList<Direction>();
        for (Direction dir : SLIDE_DIRECTIONS) {
            if (!this.isPassableBlock(pos.m_121945_(dir)) || requireDrop && !this.canBlockBeFallenInto(pos.m_121945_(dir).m_7495_())) continue;
            potentialResults.add(dir);
        }
        if (potentialResults.size() == 0) {
            return null;
        }
        return (Direction)potentialResults.get(this.level.getRandom().m_188503_(potentialResults.size()));
    }

    public boolean isBlockSupportedByLiquid(RPBlockContext blockContext) {
        if (!blockContext.hasBlockDefinition()) {
            return false;
        }
        BlockDefinition blockDef = blockContext.blockDefinition();
        RPBlockContext upContext = this.level.getBlockContext(blockContext.pos().m_7494_());
        RPBlockContext downContext = this.level.getBlockContext(blockContext.pos().m_7495_());
        return blockDef.physics().floatsOnLiquid() && !upContext.blockState().m_60767_().m_76332_() && downContext.blockState().m_60767_().m_76332_();
    }

    public int getBlockSupportStrength(RPBlockContext blockContext) {
        double strength = blockContext.blockDefinition().physics().supportStrength();
        double count = 1.0;
        for (ExtendedDirection dir : DirectionConstants.HORIZONTAL_ADJACENT) {
            BlockPos nPos = blockContext.pos().m_121955_(dir.getNormal());
            RPBlockContext nBlockContext = this.level.getBlockContext(nPos);
            if (!nBlockContext.hasBlockDefinition()) continue;
            count += 1.0;
        }
        return (int)(strength * count);
    }

    public double calculateImpactForce(double mass, double velocity, double hardness) {
        return 0.5 * mass * (velocity * velocity) / hardness;
    }

    public double calculateFallingBlockImpactForce(RealisticFallingBlockEntity entity, BlockPos target) {
        double mass = entity.blockDefinition().physics().mass();
        double velocity = entity.m_20184_().f_82480_ * 20.0;
        RPBlockContext collidingWith = this.level.getBlockContext(target);
        BlockDefinition collidingBlockDef = collidingWith.blockDefinition();
        if (this.isPassableBlock(target)) {
            return 0.0;
        }
        double sourceHardness = entity.blockDefinition().physics().hardness();
        double targetHardness = collidingBlockDef != null ? collidingBlockDef.physics().hardness() : 0.985;
        double hardness = Mth.m_14008_((double)(1.0 - sourceHardness + (1.0 - targetHardness)), (double)0.015, (double)0.985);
        return this.calculateImpactForce(mass, velocity, hardness);
    }
}

