/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.engine;

import java.util.function.Consumer;
import xbigellx.rbp.RealisticBlockPhysics;
import xbigellx.rbp.internal.config.MainConfig;
import xbigellx.rbp.internal.config.ModConfiguration;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.BlockProcessingOptions;
import xbigellx.rbp.internal.physics.ProcessedBlock;
import xbigellx.rbp.internal.physics.ProcessedBlockOperation;
import xbigellx.rbp.internal.physics.engine.PhysicsEngine;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class ConfigBasedPhysicsEngine
implements PhysicsEngine {
    private final PhysicsEngine impl;

    public ConfigBasedPhysicsEngine(PhysicsEngine impl) {
        this.impl = impl;
    }

    @Override
    public boolean isBlockConnectableToNeighbour(RBPLevel level, RPBlockContext blockContext, ExtendedDirection face) {
        ModConfiguration modConfig = RealisticBlockPhysics.configManager().getConfig();
        if (!modConfig.main().physics().diagonalBlockConnections() && face.getAxis().isDiagonal()) {
            return false;
        }
        return this.impl.isBlockConnectableToNeighbour(level, blockContext, face);
    }

    @Override
    public boolean shouldForceBreakBlock(RBPLevel level, RPBlockContext blockContext, int force) {
        MainConfig.Model modConfig = RealisticBlockPhysics.configManager().getConfig().main();
        if (!modConfig.physics().blocksCanBeCrushed()) {
            return false;
        }
        return this.impl.shouldForceBreakBlock(level, blockContext, force);
    }

    @Override
    public PhysicsEngineBehaviour getBehaviour() {
        return this.impl.getBehaviour();
    }

    @Override
    public ProcessedBlockOperation processBlock(RBPLevel level, RPBlockContext blockContext, BlockProcessingOptions processingOptions, Consumer<ProcessedBlock> consumer) {
        return this.impl.processBlock(level, blockContext, processingOptions, consumer);
    }
}

