/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.engine;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.chunk.ChunkAnalysisStatus;
import xbigellx.rbp.internal.level.chunk.RBPChunkData;
import xbigellx.rbp.internal.physics.BlockOperation;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.rbp.internal.physics.task.BlockIntegrityCheckTask;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.physics.task.PhysicsTask;
import xbigellx.realisticphysics.internal.physics.task.TaskPriority;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class DefaultPhysicsEngineBehaviour
implements PhysicsEngineBehaviour {
    private static final int INTEGRITY_DISTANCE = 8;
    private static final ExtendedDirection[] DIRECTIONS = new ExtendedDirection[]{ExtendedDirection.NORTH, ExtendedDirection.SOUTH, ExtendedDirection.EAST, ExtendedDirection.WEST, ExtendedDirection.UP, ExtendedDirection.NORTH_EAST, ExtendedDirection.NORTH_WEST, ExtendedDirection.SOUTH_EAST, ExtendedDirection.SOUTH_WEST, ExtendedDirection.UP_NORTH, ExtendedDirection.UP_SOUTH, ExtendedDirection.UP_EAST, ExtendedDirection.UP_WEST, ExtendedDirection.UP_NORTH_EAST, ExtendedDirection.UP_NORTH_WEST, ExtendedDirection.UP_SOUTH_EAST, ExtendedDirection.UP_SOUTH_WEST};

    @Override
    public void onBlockNeighbourNotify(RBPLevel level, RPBlockContext blockContext) {
        ChunkAnalysisStatus analysisStatus;
        RBPChunkData chunkData = level.chunkDataManager().get(new ChunkPos(blockContext.pos()));
        ChunkAnalysisStatus chunkAnalysisStatus = analysisStatus = chunkData != null ? chunkData.getAnalysisStatus() : ChunkAnalysisStatus.NONE;
        if (!analysisStatus.equals((Object)ChunkAnalysisStatus.ANALYSED)) {
            return;
        }
        if (level.physicsHelper().isPassableBlock(blockContext)) {
            level.physicsHelper().scheduleBlockNeighbourFallChecks(blockContext.pos(), TaskPriority.NORMAL, 8);
        } else {
            level.taskManager().addTask((PhysicsTask)new BlockIntegrityCheckTask(level, blockContext.pos(), false), TaskPriority.NORMAL);
        }
    }

    @Override
    public void onBlockInteract(RBPLevel level, RPBlockContext blockContext, Entity owningEntity) {
        if (blockContext.blockDefinition() == null) {
            return;
        }
        level.taskManager().addTask((PhysicsTask)new BlockIntegrityCheckTask(level, blockContext.pos(), false), TaskPriority.NORMAL);
        level.physicsHelper().scheduleBlockNeighbourFallChecks(blockContext.pos(), TaskPriority.NORMAL, 0);
        level.blockStabilityManager().clearInstabilityTime(blockContext.pos());
    }

    @Override
    public void onExplosionDetonate(RBPLevel level, Explosion explosion) {
        for (BlockPos affectedBlock : explosion.m_46081_()) {
            level.blockStabilityManager().setInstabilityTime(affectedBlock, 10000L);
        }
        for (BlockPos affectedBlock : explosion.m_46081_()) {
            RPBlockContext nBlockContext;
            if (affectedBlock.m_123341_() % 2 != 0 || affectedBlock.m_123342_() % 2 != 0 || affectedBlock.m_123343_() % 2 != 0 || !(nBlockContext = level.getBlockContext(affectedBlock)).hasBlockDefinition()) continue;
            level.physicsHelper().scheduleBlockNeighbourFallChecks(affectedBlock, TaskPriority.HIGH, 0);
        }
    }

    @Override
    public void onBlockBreak(RBPLevel level, RPBlockContext blockContext, Entity owningEntity) {
        level.physicsHelper().scheduleBlockNeighbourFallChecks(blockContext.pos(), TaskPriority.HIGH, 8);
        this.updatePillarBottom(level, blockContext.pos().m_7495_());
        this.updatePillarTop(level, blockContext.pos().m_7494_());
    }

    @Override
    public void onBlockPlaced(RBPLevel level, RPBlockContext blockContext, Entity owningEntity) {
        if (blockContext.blockDefinition() == null) {
            return;
        }
        boolean abovePassable = level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, ExtendedDirection.UP);
        if (!abovePassable) {
            level.taskManager().addTask((PhysicsTask)new BlockIntegrityCheckTask(level, blockContext.pos(), false), TaskPriority.NORMAL);
        } else {
            new BlockIntegrityCheckTask(level, blockContext.pos(), false).run();
        }
        level.blockStabilityManager().clearInstabilityTime(blockContext.pos());
        for (ExtendedDirection dir : ExtendedDirection.values()) {
            level.blockStabilityManager().clearInstabilityTime(blockContext.pos().m_121955_(dir.getNormal()));
        }
        this.updatePillarBottom(level, blockContext.pos().m_7495_());
    }

    @Override
    public void onBlockOperationScheduled(RBPLevel level, RPBlockContext blockContext, BlockOperation operation) {
        level.blockStabilityManager().setInstabilityTime(blockContext.pos(), 30000L);
        if (operation.equals((Object)BlockOperation.FALL)) {
            level.physicsHelper().scheduleBlockNeighbourFallChecks(blockContext.pos(), TaskPriority.NORMAL, 0);
        }
        this.updatePillarTop(level, blockContext.pos().m_7494_());
    }

    @Override
    public void onBlockAnalysis(RBPLevel level, RPBlockContext blockContext) {
        if (this.isBlockPotentiallySupported(level, blockContext)) {
            level.taskManager().addTask((PhysicsTask)new BlockIntegrityCheckTask(level, blockContext.pos(), false), TaskPriority.NORMAL);
        } else {
            level.blockOperationScheduler().schedule(BlockOperation.FALL, blockContext);
        }
    }

    private void updatePillarBottom(RBPLevel level, BlockPos origin) {
        BlockPos bPos;
        RPBlockContext bContext;
        int bottomY = level.physicsHelper().getPillarMinY(origin);
        if (bottomY != origin.m_123342_() && (bContext = level.getBlockContext(bPos = origin.m_175288_(bottomY))).hasBlockDefinition() && !level.blockStabilityManager().isBlockUnstable(bPos)) {
            level.taskManager().addTask((PhysicsTask)new BlockIntegrityCheckTask(level, bContext.pos(), false), TaskPriority.NORMAL);
        }
    }

    private void updatePillarTop(RBPLevel level, BlockPos origin) {
        BlockPos tPos;
        RPBlockContext tContext;
        int topY = level.physicsHelper().getPillarMaxY(origin);
        if (topY != origin.m_123342_() && (tContext = level.getBlockContext(tPos = origin.m_175288_(topY))).hasBlockDefinition() && !level.blockStabilityManager().isBlockUnstable(tPos)) {
            level.taskManager().addTask((PhysicsTask)new BlockIntegrityCheckTask(level, tContext.pos(), false), TaskPriority.NORMAL);
        }
    }

    private boolean isBlockPotentiallySupported(RBPLevel level, RPBlockContext blockContext) {
        for (ExtendedDirection direction : DIRECTIONS) {
            if (!level.physics().physicsEngine().isBlockConnectableToNeighbour(level, blockContext, direction)) continue;
            return true;
        }
        return false;
    }
}

