/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.engine;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.BlockOperation;
import xbigellx.rbp.internal.physics.BlockProcessingOptions;
import xbigellx.rbp.internal.physics.ProcessedBlock;
import xbigellx.rbp.internal.physics.ProcessedBlockOperation;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBase;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.physics.task.TaskPriority;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class HavocEngine
extends PhysicsEngineBase {
    private static final PhysicsEngineBehaviour BEHAVIOUR = new EngineBehaviour();

    public HavocEngine() {
        super(BEHAVIOUR);
    }

    @Override
    public boolean isBlockConnectableToNeighbour(RBPLevel level, RPBlockContext blockContext, ExtendedDirection face) {
        return false;
    }

    @Override
    public boolean shouldForceBreakBlock(RBPLevel level, RPBlockContext blockContext, int force) {
        return false;
    }

    @Override
    public ProcessedBlockOperation processBlock(RBPLevel level, RPBlockContext blockContext, BlockProcessingOptions processingOptions, Consumer<ProcessedBlock> consumer) {
        if (!level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, ExtendedDirection.DOWN)) {
            return ProcessedBlockOperation.FALL;
        }
        return ProcessedBlockOperation.NONE;
    }

    private static class EngineBehaviour
    implements PhysicsEngineBehaviour {
        private EngineBehaviour() {
        }

        @Override
        public void onBlockNeighbourNotify(RBPLevel level, RPBlockContext blockContext) {
            if (level.physicsHelper().isPassableBlock(blockContext)) {
                this.publishBlockNeighbourFallChecks(level, blockContext.pos(), TaskPriority.NORMAL);
            }
        }

        @Override
        public void onBlockBreak(RBPLevel level, RPBlockContext blockContext, Entity owningEntity) {
            this.publishBlockNeighbourFallChecks(level, blockContext.pos(), TaskPriority.HIGH);
        }

        @Override
        public void onBlockPlaced(RBPLevel level, RPBlockContext blockContext, Entity owningEntity) {
            if (blockContext.blockDefinition() != null) {
                this.publishFallCheck(level, blockContext, TaskPriority.HIGH);
            }
        }

        @Override
        public void onBlockOperationScheduled(RBPLevel level, RPBlockContext blockContext, BlockOperation operation) {
        }

        private void publishFallCheck(RBPLevel level, RPBlockContext blockContext, TaskPriority taskPriority) {
            if (blockContext.blockDefinition() == null || level.blockStabilityManager().isBlockUnstable(blockContext.pos())) {
                return;
            }
            if (!level.chunkExists(new ChunkPos(blockContext.pos()))) {
                return;
            }
            level.blockOperationScheduler().schedule(BlockOperation.FALL, blockContext);
        }

        @Override
        public void onBlockAnalysis(RBPLevel level, RPBlockContext blockContext) {
            level.blockOperationScheduler().schedule(BlockOperation.FALL, blockContext);
        }

        private void publishBlockNeighbourFallChecks(RBPLevel level, BlockPos origin, TaskPriority taskPriority) {
            for (ExtendedDirection direction : ExtendedDirection.values()) {
                BlockPos nPos = origin.m_121955_(direction.getNormal());
                RPBlockContext nBlockContext = level.getBlockContext(nPos);
                this.publishFallCheck(level, nBlockContext, taskPriority);
            }
        }
    }
}

