/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.engine;

import net.minecraft.core.BlockPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.engine.PhysicsEngine;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.rbp.internal.util.DirectionConstants;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public abstract class PhysicsEngineBase
implements PhysicsEngine {
    private final PhysicsEngineBehaviour behaviour;

    public PhysicsEngineBase(PhysicsEngineBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    @Override
    public boolean shouldForceBreakBlock(RBPLevel level, RPBlockContext blockContext, int force) {
        if (!blockContext.hasBlockDefinition()) {
            return false;
        }
        double totalStrength = this.getStrength(level, blockContext);
        return (double)force > totalStrength && !level.physicsHelper().canBlockBeFallenInto(blockContext.pos().m_7495_()) && !level.physicsHelper().isBlockEncased(blockContext, ExtendedDirection.values());
    }

    private double getStrength(RBPLevel level, RPBlockContext blockContext) {
        double strength = blockContext.blockDefinition().physics().strength();
        double count = 1.0;
        for (ExtendedDirection dir : DirectionConstants.HORIZONTAL_ADJACENT) {
            BlockPos nPos = blockContext.pos().m_121955_(dir.getNormal());
            RPBlockContext nBlockContext = level.getBlockContext(nPos);
            if (!nBlockContext.hasBlockDefinition()) continue;
            count += 1.0;
        }
        return strength * count;
    }

    @Override
    public PhysicsEngineBehaviour getBehaviour() {
        return this.behaviour;
    }
}

