/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.engine;

import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.RBPWorldDefinition;
import xbigellx.rbp.internal.physics.engine.DefaultPhysicsEngineBehaviour;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.rbp.internal.physics.engine.RuleBasedPhysicsEngine;
import xbigellx.rbp.internal.physics.rule.AggregateCaveCeilingRule;
import xbigellx.rbp.internal.physics.rule.BasicNeighbourConnectionRule;
import xbigellx.rbp.internal.physics.rule.BlockPhysicsRules;
import xbigellx.rbp.internal.physics.rule.BlockPhysicsRulesProvider;
import xbigellx.rbp.internal.physics.rule.CaveCeilingRule;
import xbigellx.rbp.internal.physics.rule.NeighbourConnectionRule;
import xbigellx.rbp.internal.physics.rule.NoopCaveCeilingRule;
import xbigellx.rbp.internal.physics.rule.SimpleCaveCeilingRule;
import xbigellx.rbp.internal.physics.rule.SupportPillarRule;
import xbigellx.rbp.internal.physics.rule.WeightBasedSupportPillarRule;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class RealisticEngine
extends RuleBasedPhysicsEngine {
    private static final PhysicsEngineBehaviour BEHAVIOUR = new DefaultPhysicsEngineBehaviour();

    public RealisticEngine(RBPWorldDefinition worldDef) {
        super(new RulesProvider(worldDef), BEHAVIOUR);
    }

    static class RulesProvider
    implements BlockPhysicsRulesProvider {
        private static final SupportPillarRule SUPPORT_PILLAR_RULE = new WeightBasedSupportPillarRule();
        private static final NeighbourConnectionRule CONNECTION_RULE = new BasicNeighbourConnectionRule();
        private static final CaveCeilingRule NOOP_CAVE_CEILING_RULE = new NoopCaveCeilingRule();
        private static final ExtendedDirection[] DIRECTIONS = new ExtendedDirection[]{ExtendedDirection.NORTH, ExtendedDirection.EAST, ExtendedDirection.SOUTH, ExtendedDirection.WEST};
        private final BlockPhysicsRules rules1;
        private final BlockPhysicsRules rules2;
        private final BlockPhysicsRules rules3;

        public RulesProvider(RBPWorldDefinition worldDef) {
            this.rules1 = new BlockPhysicsRules(SUPPORT_PILLAR_RULE, AggregateCaveCeilingRule.of(worldDef), CONNECTION_RULE);
            this.rules2 = new BlockPhysicsRules(SUPPORT_PILLAR_RULE, SimpleCaveCeilingRule.of(worldDef), CONNECTION_RULE);
            this.rules3 = new BlockPhysicsRules(SUPPORT_PILLAR_RULE, NOOP_CAVE_CEILING_RULE, CONNECTION_RULE);
        }

        @Override
        public BlockPhysicsRules get(RBPLevel level, RPBlockContext originContext) {
            int rootEncase = level.physicsHelper().countEncasingBlocks(originContext, DIRECTIONS);
            if (rootEncase == 2) {
                return this.rules2;
            }
            if (rootEncase < 2) {
                return this.rules3;
            }
            return this.rules1;
        }
    }
}

