/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.engine;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.scan.BlockScanOptions;
import xbigellx.rbp.internal.level.scan.RuleBasedIntegrityBlockScanner;
import xbigellx.rbp.internal.level.scan.ScanAction;
import xbigellx.rbp.internal.level.scan.TraversedIntegrityBlock;
import xbigellx.rbp.internal.physics.BlockProcessingDetail;
import xbigellx.rbp.internal.physics.BlockProcessingOptions;
import xbigellx.rbp.internal.physics.ProcessedBlock;
import xbigellx.rbp.internal.physics.ProcessedBlockOperation;
import xbigellx.rbp.internal.physics.engine.DefaultPhysicsEngineBehaviour;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBase;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.rbp.internal.physics.rule.BlockPhysicsRules;
import xbigellx.rbp.internal.physics.rule.BlockPhysicsRulesProvider;
import xbigellx.rbp.internal.physics.task.BlockIntegrityCheckTask;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.physics.task.PhysicsTask;
import xbigellx.realisticphysics.internal.physics.task.TaskPriority;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class RuleBasedPhysicsEngine
extends PhysicsEngineBase {
    private final RuleBasedIntegrityBlockScanner integrityScanner;
    private final BlockPhysicsRulesProvider rulesProvider;
    private static final BlockScanOptions SCAN_0 = new BlockScanOptions(0);
    private static final BlockScanOptions SCAN_100 = new BlockScanOptions(100);
    private static final BlockScanOptions SCAN_150 = new BlockScanOptions(150);
    private static final BlockScanOptions SCAN_250 = new BlockScanOptions(250);

    public RuleBasedPhysicsEngine(BlockPhysicsRules rules) {
        this((level, originContext) -> rules, new DefaultPhysicsEngineBehaviour());
    }

    public RuleBasedPhysicsEngine(BlockPhysicsRulesProvider rulesProvider, PhysicsEngineBehaviour engineBehaviour) {
        this(rulesProvider, engineBehaviour, new RuleBasedIntegrityBlockScanner(rulesProvider));
    }

    private RuleBasedPhysicsEngine(BlockPhysicsRulesProvider rulesProvider, PhysicsEngineBehaviour engineBehaviour, RuleBasedIntegrityBlockScanner integrityScanner) {
        super(engineBehaviour);
        this.rulesProvider = rulesProvider;
        this.integrityScanner = integrityScanner;
    }

    private static BlockScanOptions resolveScanOptions(RBPLevel level, RPBlockContext blockContext) {
        AtomicInteger unsupported = new AtomicInteger();
        level.blockStabilityManager().evaluateSurroundingBlocks(blockContext.pos(), (pos, isStable) -> {
            if (!isStable.booleanValue()) {
                unsupported.getAndIncrement();
            }
        });
        boolean blockBelowPassable = level.physicsHelper().canBlockBeFallenInto(blockContext.pos().m_7495_());
        if (blockBelowPassable && (unsupported.get() >= 16 || unsupported.get() >= 12 && Math.random() < 0.5)) {
            return SCAN_0;
        }
        if (unsupported.get() >= 12) {
            return SCAN_100;
        }
        if (unsupported.get() >= 8) {
            return SCAN_150;
        }
        return SCAN_250;
    }

    @Override
    public ProcessedBlockOperation processBlock(RBPLevel level, RPBlockContext blockContext, BlockProcessingOptions processingOptions, Consumer<ProcessedBlock> consumer) {
        AtomicBoolean supportPillarFound = new AtomicBoolean(false);
        if (!blockContext.hasBlockDefinition() || level.physicsHelper().isBlockEncased(blockContext)) {
            return ProcessedBlockOperation.NONE;
        }
        BlockScanOptions scanOptions = RuleBasedPhysicsEngine.resolveScanOptions(level, blockContext);
        this.integrityScanner.scan(level, blockContext.pos(), scanOptions, scannedBlock -> {
            if (scannedBlock.isSupportPillar()) {
                supportPillarFound.set(true);
                if (processingOptions.getDetail().equals((Object)BlockProcessingDetail.HIGH)) {
                    return ScanAction.REJECT_BLOCK;
                }
                return ScanAction.ABORT;
            }
            if (processingOptions.getDetail().equals((Object)BlockProcessingDetail.HIGH) && this.isDetailedCandidate(level, (TraversedIntegrityBlock)scannedBlock)) {
                level.taskManager().addTask((PhysicsTask)new BlockIntegrityCheckTask(level, scannedBlock.blockContext().pos(), false), TaskPriority.NORMAL);
            }
            if (!scannedBlock.isStable()) {
                if (scannedBlock.isBeingCrushed()) {
                    consumer.accept(new ProcessedBlock(scannedBlock.blockContext(), ProcessedBlockOperation.CRUSH));
                    return ScanAction.REJECT_BLOCK;
                }
                if (!scannedBlock.isBeamPillar()) {
                    return ScanAction.REJECT_BLOCK;
                }
            }
            return ScanAction.ACCEPT_BLOCK;
        });
        if (!supportPillarFound.get()) {
            return ProcessedBlockOperation.FALL;
        }
        return ProcessedBlockOperation.NONE;
    }

    @Override
    public boolean isBlockConnectableToNeighbour(RBPLevel level, RPBlockContext blockContext, ExtendedDirection face) {
        return this.rulesProvider.get(level, blockContext).isConnectableToNeighbour().evaluate(level, blockContext, face);
    }

    public BlockPhysicsRulesProvider getRulesProvider() {
        return this.rulesProvider;
    }

    private boolean isDetailedCandidate(RBPLevel level, TraversedIntegrityBlock scannedBlock) {
        if (scannedBlock.parent() == null) {
            return false;
        }
        int count = 0;
        for (ExtendedDirection dir : ExtendedDirection.ADJACENT_VALUES) {
            if (dir.equals((Object)scannedBlock.directionToParent())) continue;
            if (level.physics().physicsEngine().isBlockConnectableToNeighbour(level, scannedBlock.blockContext(), dir)) {
                ++count;
            }
            if (count <= 2) continue;
            return false;
        }
        return true;
    }
}

