/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.engine;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.scan.BlockScanOptions;
import xbigellx.rbp.internal.level.scan.BlockScanResult;
import xbigellx.rbp.internal.level.scan.ScanAction;
import xbigellx.rbp.internal.level.scan.ScanResultType;
import xbigellx.rbp.internal.level.scan.SimpleIntegrityBlockScanner;
import xbigellx.rbp.internal.level.scan.TraversedIntegrityBlock;
import xbigellx.rbp.internal.level.scan.algorithm.BlockTraverseAlgorithm;
import xbigellx.rbp.internal.level.scan.algorithm.BreadthFirstTraverseAlgorithm;
import xbigellx.rbp.internal.physics.BlockOperation;
import xbigellx.rbp.internal.physics.BlockProcessingOptions;
import xbigellx.rbp.internal.physics.ProcessedBlock;
import xbigellx.rbp.internal.physics.ProcessedBlockOperation;
import xbigellx.rbp.internal.physics.engine.DefaultPhysicsEngineBehaviour;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBase;
import xbigellx.rbp.internal.physics.engine.PhysicsEngineBehaviour;
import xbigellx.rbp.internal.physics.rule.BasicNeighbourConnectionRule;
import xbigellx.rbp.internal.physics.rule.NeighbourConnectionRule;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class SimpleEngine
extends PhysicsEngineBase {
    private static final SimpleIntegrityBlockScanner INTEGRITY_BLOCK_SCANNER = new SimpleIntegrityBlockScanner((BlockTraverseAlgorithm)new BreadthFirstTraverseAlgorithm(12, 4), true);
    private static final BlockScanOptions SCAN_OPTIONS = new BlockScanOptions(16384);
    private static final NeighbourConnectionRule CONNECTION_RULE = new BasicNeighbourConnectionRule();
    private static final PhysicsEngineBehaviour BEHAVIOUR = new EngineBehaviour();

    public SimpleEngine() {
        super(BEHAVIOUR);
    }

    @Override
    public boolean isBlockConnectableToNeighbour(RBPLevel level, RPBlockContext blockContext, ExtendedDirection face) {
        return CONNECTION_RULE.evaluate(level, blockContext, face);
    }

    @Override
    public ProcessedBlockOperation processBlock(RBPLevel level, RPBlockContext blockContext, BlockProcessingOptions processingOptions, Consumer<ProcessedBlock> consumer) {
        AtomicBoolean supportPillarFound = new AtomicBoolean(false);
        if (!blockContext.hasBlockDefinition() || level.physicsHelper().isBlockEncased(blockContext)) {
            return ProcessedBlockOperation.NONE;
        }
        BlockScanResult<TraversedIntegrityBlock> scanResult = INTEGRITY_BLOCK_SCANNER.scan(level, blockContext.pos(), SCAN_OPTIONS, scannedBlock -> {
            if (scannedBlock.isSupportPillar()) {
                supportPillarFound.set(true);
                return ScanAction.ABORT;
            }
            if (!scannedBlock.isStable() && !scannedBlock.isBeamPillar()) {
                return ScanAction.REJECT_BLOCK;
            }
            return ScanAction.ACCEPT_BLOCK;
        });
        if (!supportPillarFound.get() && !scanResult.getImplResult().equals((Object)ScanResultType.PARTIAL)) {
            return ProcessedBlockOperation.FALL;
        }
        return ProcessedBlockOperation.NONE;
    }

    private static class EngineBehaviour
    extends DefaultPhysicsEngineBehaviour {
        private EngineBehaviour() {
        }

        @Override
        public void onBlockOperationScheduled(RBPLevel level, RPBlockContext blockContext, BlockOperation operation) {
            super.onBlockOperationScheduled(level, blockContext, operation);
        }

        private boolean triggerNeighboursToFall(RBPLevel level, RPBlockContext blockContext) {
            BlockPos origin = blockContext.pos();
            BlockDefinition blockDef = blockContext.blockDefinition();
            if (!blockDef.physics().canHang() || !blockDef.physics().canAttach()) {
                return false;
            }
            for (ExtendedDirection direction : ExtendedDirection.values()) {
                BlockPos nPos = origin.m_121955_(direction.getNormal());
                RPBlockContext nBlockContext = level.getBlockContext(nPos);
                if (nBlockContext.blockDefinition() == null || level.blockStabilityManager().isBlockUnstable(blockContext.pos()) || !level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, direction, blockDef.physics().canAttachDiagonally()) || !level.chunkExists(new ChunkPos(nPos))) continue;
                BlockPos below = nPos.m_7495_();
                if (!level.blockStabilityManager().isBlockUnstable(below) && !level.physicsHelper().canBlockBeFallenInto(below)) continue;
                level.blockOperationScheduler().schedule(BlockOperation.FALL, nBlockContext);
            }
            return true;
        }
    }
}

