/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.rule;

import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.RBPWorldDefinition;
import xbigellx.rbp.internal.physics.rule.CaveCeilingRule;
import xbigellx.rbp.internal.physics.rule.SimpleCaveCeilingRule;
import xbigellx.rbp.internal.physics.rule.WeightBasedCaveCeilingRule;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;

public class AggregateCaveCeilingRule
implements CaveCeilingRule {
    private final WeightBasedCaveCeilingRule weightRule;
    private final SimpleCaveCeilingRule simpleRule;

    public AggregateCaveCeilingRule(int maxVerticalOverhang, int maxHorizontalOverhang, boolean ignoreLiquidPockets) {
        this.weightRule = new WeightBasedCaveCeilingRule(ignoreLiquidPockets);
        this.simpleRule = new SimpleCaveCeilingRule(maxVerticalOverhang, maxHorizontalOverhang, ignoreLiquidPockets);
    }

    public static AggregateCaveCeilingRule of(RBPWorldDefinition worldDef) {
        int strengthenFactor = worldDef.physics().caveStrengthening().strengthenFactor();
        boolean ignoreLiquidPockets = worldDef.physics().caveStrengthening().ignoreLiquidPockets();
        int maxVerticalOverhang = strengthenFactor >> 1 << 1;
        int maxHorizontalOverhang = strengthenFactor << 4;
        return new AggregateCaveCeilingRule(maxVerticalOverhang, maxHorizontalOverhang, ignoreLiquidPockets);
    }

    @Override
    public boolean isResultCacheable() {
        return false;
    }

    @Override
    public boolean evaluate(RBPLevel level, RPBlockContext blockContext) {
        if (this.weightRule.evaluate(level, blockContext)) {
            return true;
        }
        return this.simpleRule.evaluate(level, blockContext);
    }
}

