/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.rule;

import java.util.function.Predicate;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.rule.NeighbourConnectionRule;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class BasicNeighbourConnectionRule
implements NeighbourConnectionRule {
    private final Predicate<ExtendedDirection> predicate;

    public BasicNeighbourConnectionRule(Predicate<ExtendedDirection> predicate) {
        this.predicate = predicate;
    }

    public BasicNeighbourConnectionRule() {
        this(d -> true);
    }

    @Override
    public boolean isResultCacheable() {
        return false;
    }

    @Override
    public boolean evaluate(RBPLevel level, RPBlockContext blockContext, ExtendedDirection direction) {
        if (!this.predicate.test(direction)) {
            return false;
        }
        BlockDefinition blockDefinition = blockContext.blockDefinition();
        boolean canAttachDiagonally = blockDefinition.physics().canAttachDiagonally();
        if (!level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, direction, canAttachDiagonally)) {
            return false;
        }
        if (direction.equals((Object)ExtendedDirection.UP) && !blockDefinition.physics().canHang()) {
            return false;
        }
        if (!direction.getAxis().isVertical() && !blockDefinition.physics().canAttach()) {
            return false;
        }
        RPBlockContext nBlockContext = level.getBlockContext(blockContext.pos().m_121955_(direction.getNormal()));
        if (!direction.equals((Object)ExtendedDirection.DOWN) && nBlockContext.blockDefinition() == null) {
            return false;
        }
        return !level.blockStabilityManager().isBlockUnstable(nBlockContext.pos());
    }
}

