/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.rule;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.RBPWorldDefinition;
import xbigellx.rbp.internal.level.scan.ScanAction;
import xbigellx.rbp.internal.level.scan.SimpleIntegrityBlockScanner;
import xbigellx.rbp.internal.level.scan.algorithm.GridTraverseAlgorithm;
import xbigellx.rbp.internal.physics.rule.CaveCeilingRule;
import xbigellx.rbp.internal.physics.rule.WeightBasedCaveCeilingRule;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class SimpleCaveCeilingRule
implements CaveCeilingRule {
    private static final ExtendedDirection[] DIRECTIONS = new ExtendedDirection[]{ExtendedDirection.WEST, ExtendedDirection.EAST, ExtendedDirection.NORTH, ExtendedDirection.SOUTH};
    private static final ExtendedDirection[] DIRECTIONS_2 = new ExtendedDirection[]{ExtendedDirection.NORTH_EAST, ExtendedDirection.SOUTH_EAST, ExtendedDirection.SOUTH_WEST, ExtendedDirection.NORTH_WEST};
    private final int maxVerticalOverhang;
    private final WeightBasedCaveCeilingRule weightRule;
    private final SimpleIntegrityBlockScanner scanner;
    private final boolean ignoreLiquidPockets;

    public SimpleCaveCeilingRule(int maxVerticalOverhang, int maxHorizontalOverhang, boolean ignoreLiquidPockets) {
        this.maxVerticalOverhang = maxVerticalOverhang;
        this.scanner = new SimpleIntegrityBlockScanner(new GridTraverseAlgorithm(2, 8, 2, Integer.MAX_VALUE), maxVerticalOverhang, maxHorizontalOverhang, false);
        this.weightRule = new WeightBasedCaveCeilingRule(ignoreLiquidPockets);
        this.ignoreLiquidPockets = ignoreLiquidPockets;
    }

    public static SimpleCaveCeilingRule of(RBPWorldDefinition worldDef) {
        int strengthenFactor = worldDef.physics().caveStrengthening().strengthenFactor();
        boolean ignoreLiquidPockets = worldDef.physics().caveStrengthening().ignoreLiquidPockets();
        int maxVerticalOverhang = strengthenFactor >> 1 << 1;
        int maxHorizontalOverhang = strengthenFactor << 4;
        return new SimpleCaveCeilingRule(maxVerticalOverhang, maxHorizontalOverhang, ignoreLiquidPockets);
    }

    @Override
    public boolean isResultCacheable() {
        return false;
    }

    @Override
    public boolean evaluate(RBPLevel level, RPBlockContext blockContext) {
        if (!this.isPotentialCaveCeiling(level, blockContext)) {
            return false;
        }
        if (level.dimensionType().hasCeiling()) {
            int maxY = level.dimensionType().maxBuildHeight();
            int topY = level.physicsHelper().getPillarMaxY(blockContext.pos());
            RPBlockContext tBlockContext = level.getBlockContext(blockContext.pos().m_175288_(topY));
            if (tBlockContext.hasBlockDefinition() && topY == maxY) {
                return true;
            }
        }
        AtomicBoolean supported = new AtomicBoolean();
        this.scanner.scan(level, blockContext.pos(), scannedBlock -> {
            if (scannedBlock.isSupportPillar()) {
                supported.set(true);
                return ScanAction.ABORT;
            }
            if (!scannedBlock.isStable()) {
                return ScanAction.REJECT_BLOCK;
            }
            return ScanAction.ACCEPT_BLOCK;
        });
        return supported.get();
    }

    private boolean isPotentialCaveCeiling(RBPLevel level, RPBlockContext blockContext) {
        BlockPos pos = blockContext.pos();
        if (blockContext.pos().m_123342_() == level.dimensionType().minBuildHeight()) {
            return false;
        }
        if (!level.physicsHelper().canBlockBeFallenInto(pos.m_7495_())) {
            return false;
        }
        if (!level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, ExtendedDirection.UP, false, this.ignoreLiquidPockets)) {
            return false;
        }
        boolean potential = false;
        for (ExtendedDirection dir : DIRECTIONS_2) {
            BlockPos nPos = blockContext.pos().m_121955_(dir.getNormal());
            BlockPos bottomPos = this.findBottom(level, nPos);
            if (bottomPos == null) {
                BlockPos topPos = this.findTop(level, nPos);
                if (topPos == null) continue;
                nPos = topPos;
            } else {
                nPos = bottomPos;
            }
            RPBlockContext nBlockContext = level.getBlockContext(nPos);
            if (!this.weightRule.evaluate(level, nBlockContext)) continue;
            potential = true;
            break;
        }
        return potential;
    }

    @Nullable
    private BlockPos findTop(RBPLevel level, BlockPos origin) {
        int maxY = Math.min(level.dimensionType().maxBuildHeight(), origin.m_123342_() + this.maxVerticalOverhang);
        for (int y = origin.m_123342_(); y <= maxY; ++y) {
            BlockPos nPos = origin.m_175288_(y);
            RPBlockContext nBlockContext = level.getBlockContext(nPos);
            if (level.physicsHelper().canBlockBeFallenInto(nBlockContext)) continue;
            return nPos;
        }
        return null;
    }

    @Nullable
    private BlockPos findBottom(RBPLevel level, BlockPos origin) {
        int minY = Math.min(level.dimensionType().minBuildHeight(), origin.m_123342_() - this.maxVerticalOverhang);
        for (int y = origin.m_123342_(); y >= minY; --y) {
            BlockPos nPos = origin.m_175288_(y);
            RPBlockContext nBlockContext = level.getBlockContext(nPos);
            if (!level.physicsHelper().canBlockBeFallenInto(nBlockContext)) continue;
            if (y == origin.m_123342_()) {
                return null;
            }
            return origin.m_175288_(y + 1);
        }
        return null;
    }
}

