/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.rule;

import net.minecraft.core.BlockPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.rule.CaveCeilingRule;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class WeightBasedCaveCeilingRule
implements CaveCeilingRule {
    private static final ExtendedDirection[] DIRECTIONS = new ExtendedDirection[]{ExtendedDirection.WEST, ExtendedDirection.EAST, ExtendedDirection.NORTH, ExtendedDirection.SOUTH};
    private final boolean ignoreLiquidPockets;

    public WeightBasedCaveCeilingRule(boolean ignoreLiquidPockets) {
        this.ignoreLiquidPockets = ignoreLiquidPockets;
    }

    @Override
    public boolean evaluate(RBPLevel level, RPBlockContext blockContext) {
        BlockDefinition blockDef = blockContext.blockDefinition();
        if (blockDef == null) {
            return false;
        }
        if (!this.isPotentialCaveCeiling(level, blockContext)) {
            return false;
        }
        int maxY = level.dimensionType().minBuildHeight();
        int topY = level.physicsHelper().getPillarMaxY(blockContext.pos());
        RPBlockContext tBlockContext = level.getBlockContext(blockContext.pos().m_175288_(topY));
        if (level.dimensionType().hasCeiling() && tBlockContext.hasBlockDefinition() && topY == maxY) {
            return true;
        }
        return this.checkPillar(level, blockContext);
    }

    @Override
    public boolean isResultCacheable() {
        return false;
    }

    private boolean checkPillar(RBPLevel level, RPBlockContext blockContext) {
        BlockPos blockPos = blockContext.pos();
        RPChunkAccessor chunk = level.getChunk(blockPos);
        double currentWeight = 0.0;
        int xPos = blockPos.m_123341_();
        int yPos = blockPos.m_123342_();
        int zPos = blockPos.m_123343_();
        BlockDefinition currentBlockDef = blockContext.blockDefinition();
        for (int i = yPos; i <= chunk.getMaxSection() << 4; ++i) {
            RPBlockContext pBlockContext = chunk.getBlockContext(new BlockPos(xPos, i, zPos));
            BlockDefinition pBlockDef = pBlockContext.blockDefinition();
            boolean isLiquid = pBlockContext.blockState().m_60767_().m_76332_();
            if (this.ignoreLiquidPockets && isLiquid) continue;
            if (pBlockDef == null) {
                return false;
            }
            if (i != yPos && !level.physicsHelper().isBlockFaceTouchingNeighbour(pBlockContext, ExtendedDirection.DOWN, pBlockDef.physics().canAttachDiagonally(), this.ignoreLiquidPockets)) {
                return false;
            }
            if (!level.physicsHelper().isBlockEncased(pBlockContext, this.ignoreLiquidPockets) && !isLiquid) {
                currentWeight = 0.0;
            }
            if (isLiquid) continue;
            if (currentWeight > (double)pBlockDef.physics().supportStrength() && level.physics().getBlockWeight(blockContext) <= currentWeight) {
                return true;
            }
            currentWeight += level.physics().getBlockWeight(pBlockContext);
        }
        return false;
    }

    private boolean isPotentialCaveCeiling(RBPLevel level, RPBlockContext blockContext) {
        BlockPos pos = blockContext.pos();
        if (blockContext.pos().m_123342_() == level.dimensionType().minBuildHeight()) {
            return false;
        }
        if (!level.physicsHelper().canBlockBeFallenInto(pos.m_7495_())) {
            return false;
        }
        if (!level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, ExtendedDirection.UP)) {
            return false;
        }
        return level.physicsHelper().countEncasingBlocks(blockContext, DIRECTIONS, this.ignoreLiquidPockets) >= 2;
    }
}

