/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.rule;

import net.minecraft.core.BlockPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.rule.SupportPillarRule;
import xbigellx.realisticphysics.internal.level.RPDimensionType;
import xbigellx.realisticphysics.internal.level.block.BlockDefinition;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class WeightBasedSupportPillarRule
implements SupportPillarRule {
    @Override
    public boolean evaluate(RBPLevel level, RPBlockContext blockContext, int initialWeight) {
        BlockDefinition blockDef = blockContext.blockDefinition();
        if (blockDef == null) {
            return false;
        }
        BlockPos blockPos = blockContext.pos();
        RPChunkAccessor chunk = level.getChunk(blockPos);
        RPDimensionType dimension = level.dimensionType();
        int currentWeight = 0;
        int totalWeight = initialWeight;
        BlockDefinition currentBlockDef = blockDef;
        int xPos = blockPos.m_123341_();
        int yPos = blockPos.m_123342_();
        int zPos = blockPos.m_123343_();
        for (int i = yPos; i >= dimension.minBuildHeight(); --i) {
            RPBlockContext pBlockContext = chunk.getBlockContext(new BlockPos(xPos, i, zPos));
            BlockDefinition pBlockDef = pBlockContext.blockDefinition();
            if (i != yPos && !level.physicsHelper().isBlockFaceTouchingNeighbour(pBlockContext, ExtendedDirection.UP)) {
                return false;
            }
            if (pBlockDef == null) {
                return true;
            }
            boolean crushResult = level.physics().physicsEngine().shouldForceBreakBlock(level, pBlockContext, totalWeight);
            if (crushResult) {
                return false;
            }
            if (pBlockDef.physics().mass() != currentBlockDef.physics().mass() || !this.isBlockSurrounded(level, pBlockContext)) {
                currentBlockDef = pBlockDef;
                currentWeight = 0;
            }
            if (level.physicsHelper().isBlockSupportedByLiquid(blockContext)) {
                return true;
            }
            if (currentWeight > pBlockDef.physics().supportStrength() && level.physics().getBlockWeight(blockContext) <= (double)currentWeight) {
                return true;
            }
            double blockWeight = level.physics().getBlockWeight(pBlockContext);
            currentWeight = (int)((double)currentWeight + blockWeight);
            totalWeight = (int)((double)totalWeight + blockWeight);
        }
        return false;
    }

    private boolean isBlockSurrounded(RBPLevel level, RPBlockContext blockContext) {
        return level.physicsHelper().isBlockEncased(blockContext);
    }

    @Override
    public boolean isResultCacheable() {
        return true;
    }
}

