/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.task;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.level.block.RBPBlockDefinition;
import xbigellx.rbp.internal.level.chunk.ChunkAnalysisStatus;
import xbigellx.rbp.internal.level.chunk.RBPChunkData;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.physics.PhysicsCategory;
import xbigellx.realisticphysics.internal.physics.task.PhysicsTask;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class AnalyseChunkTask
implements PhysicsTask {
    private final RBPLevel level;
    private final RPChunkAccessor chunk;
    private final int section;

    public AnalyseChunkTask(RBPLevel level, RPChunkAccessor chunk, int section) {
        this.level = level;
        this.chunk = chunk;
        this.section = section;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.section).append((Object)this.chunk.pos()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnalyseChunkTask)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AnalyseChunkTask task = (AnalyseChunkTask)obj;
        return new EqualsBuilder().append(this.section, task.section).append((Object)this.chunk.pos(), (Object)task.chunk.pos()).isEquals();
    }

    public PhysicsCategory getCategory() {
        return PhysicsCategory.BLOCK;
    }

    public ChunkPos chunkPos() {
        return this.chunk.pos();
    }

    public int chunkSection() {
        return this.section;
    }

    public boolean preValidate() {
        return true;
    }

    public void run() {
        ChunkPos chunkPos = this.chunk.pos();
        int startY = this.chunk.getSectionYFromSectionIndex(this.section) << 4;
        int endY = startY + 15;
        int startX = chunkPos.f_45578_ << 4;
        int endX = startX + 15;
        int startZ = chunkPos.f_45579_ << 4;
        int endZ = startZ + 15;
        int maxAltitude = this.level.physics().settings().chunkAnalysis().maxAltitude();
        int minAltitude = this.level.physics().settings().chunkAnalysis().minAltitude();
        RBPChunkData chunkData = this.level.chunkDataManager().get(this.chunk.pos());
        if (chunkData == null) {
            return;
        }
        for (int chunkY = startY; chunkY <= endY; ++chunkY) {
            if (!this.level.chunkExists(chunkPos) || chunkY < minAltitude || chunkY > maxAltitude) continue;
            for (int chunkX = startX; chunkX <= endX; ++chunkX) {
                int incZ;
                for (int chunkZ = startZ; chunkZ <= endZ; chunkZ += incZ) {
                    BlockPos pos = new BlockPos(chunkX, chunkY, chunkZ);
                    RPBlockContext context = this.chunk.getBlockContext(pos);
                    RBPBlockDefinition blockDef = (RBPBlockDefinition)context.blockDefinition();
                    if (blockDef == null || !blockDef.chunkAnalysis().enabled()) {
                        incZ = 1;
                        continue;
                    }
                    incZ = 3;
                    if (this.level.physicsHelper().isBlockFaceTouchingNeighbour(context, ExtendedDirection.DOWN)) continue;
                    this.level.physics().physicsEngine().getBehaviour().onBlockAnalysis(this.level, context);
                }
            }
        }
        chunkData.getSectionData(this.section).setAnalysisStatus(ChunkAnalysisStatus.ANALYSED);
    }
}

