/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.task;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.BlockOperation;
import xbigellx.rbp.internal.physics.BlockProcessingDetail;
import xbigellx.rbp.internal.physics.BlockProcessingOptions;
import xbigellx.rbp.internal.physics.ProcessedBlockOperation;
import xbigellx.rbp.internal.physics.engine.PhysicsEngine;
import xbigellx.rbp.internal.physics.task.BlockPhysicsTask;
import xbigellx.rbp.internal.physics.task.PhysicsTaskType;
import xbigellx.realisticphysics.internal.level.block.RPBlockContext;
import xbigellx.realisticphysics.internal.level.chunk.RPChunkAccessor;
import xbigellx.realisticphysics.internal.util.ExtendedDirection;

public class BlockIntegrityCheckTask
extends BlockPhysicsTask {
    private static final BlockProcessingOptions NORMAL_OPTIONS = new BlockProcessingOptions(BlockProcessingDetail.NORMAL);
    private static final BlockProcessingOptions DETAILED_OPTIONS = new BlockProcessingOptions(BlockProcessingDetail.HIGH);
    private final PhysicsEngine physicsEngine;
    private final BlockPos pos;
    private final BlockProcessingOptions processingOptions;

    public BlockIntegrityCheckTask(RBPLevel level, BlockPos pos, boolean detailed) {
        super(PhysicsTaskType.BLOCK_INTEGRITY_CHECK, level, pos);
        this.processingOptions = !detailed ? NORMAL_OPTIONS : DETAILED_OPTIONS;
        this.physicsEngine = level.physics().physicsEngine();
        this.pos = pos;
    }

    public void run() {
        boolean fall;
        if (!this.preValidate()) {
            return;
        }
        RPBlockContext blockContext = this.level.getBlockContext(this.pos);
        boolean obstructed = this.level.physicsHelper().isBlockFaceTouchingNeighbour(blockContext, ExtendedDirection.DOWN);
        AtomicReference crushed = new AtomicReference();
        ProcessedBlockOperation result = this.physicsEngine.processBlock(this.level, blockContext, this.processingOptions, processedBlock -> {
            if (processedBlock.operation().equals((Object)ProcessedBlockOperation.CRUSH) && crushed.get() == null) {
                crushed.set(processedBlock.blockContext());
            }
        });
        boolean bl = fall = result == ProcessedBlockOperation.FALL;
        if (fall && crushed.get() != null) {
            this.level.blockOperationScheduler().schedule(BlockOperation.BREAK, (RPBlockContext)crushed.get());
        }
        if (fall && this.level.chunkExists(this.chunkPos())) {
            if (obstructed) {
                BlockPos pPos;
                RPBlockContext pBlockContext;
                RPChunkAccessor chunk = this.level.getChunk(this.chunkPos());
                for (int i = blockContext.pos().m_123342_() - 1; i >= this.level.dimensionType().minBuildHeight() && (pBlockContext = chunk.getBlockContext(pPos = blockContext.pos().m_175288_(i))).hasBlockDefinition() && !this.level.blockStabilityManager().isBlockUnstable(pPos) && (crushed.get() == null || ((RPBlockContext)crushed.get()).pos().m_123342_() < i); --i) {
                    this.level.blockOperationScheduler().schedule(BlockOperation.FALL, pBlockContext);
                }
            }
            this.level.blockOperationScheduler().schedule(BlockOperation.FALL, blockContext);
        }
    }

    @Override
    public boolean preValidate() {
        RPBlockContext nowContext = this.level.getBlockContext(this.pos);
        return nowContext.hasBlockDefinition() && this.level.chunkExists(this.chunkPos());
    }
}

