/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.physics.task;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import xbigellx.rbp.internal.level.RBPLevel;
import xbigellx.rbp.internal.physics.task.PhysicsTaskBase;
import xbigellx.rbp.internal.physics.task.PhysicsTaskType;
import xbigellx.realisticphysics.internal.physics.PhysicsCategory;

public abstract class BlockPhysicsTask
extends PhysicsTaskBase {
    protected final BlockPos pos;
    private final ChunkPos chunkPos;

    public BlockPhysicsTask(PhysicsTaskType taskType, RBPLevel level, BlockPos pos) {
        super(taskType, level);
        this.pos = pos;
        this.chunkPos = new ChunkPos(pos);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 31).appendSuper(super.hashCode()).append((Object)this.pos).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockPhysicsTask)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BlockPhysicsTask task = (BlockPhysicsTask)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.pos, (Object)task.pos).isEquals();
    }

    public final PhysicsCategory getCategory() {
        return PhysicsCategory.BLOCK;
    }

    public final ChunkPos chunkPos() {
        return this.chunkPos;
    }

    public final int chunkSection() {
        return (this.pos.m_123342_() >> 4) - this.level.getMinSection();
    }

    public boolean preValidate() {
        return true;
    }
}

