/*
 * Decompiled with CFR 0.152.
 */
package xbigellx.rbp.internal.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class BlockBoundsExtender {
    public static List<AABB> extendBounds(List<AABB> aabbs, Direction vRelative, Direction hRelative, boolean up, boolean down, boolean north, boolean east, boolean south, boolean west) {
        if (!aabbs.isEmpty()) {
            return BlockBoundsExtender.extendFromExisting(aabbs, vRelative, hRelative, up, down, north, east, south, west);
        }
        return BlockBoundsExtender.extendFromEmpty(vRelative, hRelative, up, down, north, east, south, west);
    }

    private static List<AABB> extendFromExisting(List<AABB> aabbs, Direction vRelative, Direction hRelative, boolean up, boolean down, boolean north, boolean east, boolean south, boolean west) {
        int aabb;
        Direction upDir = vRelative.m_122424_();
        Direction eastDir = hRelative.m_122427_();
        Direction southDir = hRelative.m_122424_();
        Direction westDir = hRelative.m_122428_();
        if (up) {
            aabb = BlockBoundsExtender.getFarthestBound(aabbs, upDir);
            aabbs.set(aabb, BlockBoundsExtender.extendAABB(aabbs.get(aabb), upDir));
        }
        if (down) {
            aabb = BlockBoundsExtender.getFarthestBound(aabbs, vRelative);
            aabbs.set(aabb, BlockBoundsExtender.extendAABB(aabbs.get(aabb), vRelative));
        }
        if (north) {
            aabb = BlockBoundsExtender.getFarthestBound(aabbs, hRelative);
            aabbs.set(aabb, BlockBoundsExtender.extendAABB(aabbs.get(aabb), hRelative));
        }
        if (east) {
            aabb = BlockBoundsExtender.getFarthestBound(aabbs, eastDir);
            aabbs.set(aabb, BlockBoundsExtender.extendAABB(aabbs.get(aabb), eastDir));
        }
        if (south) {
            aabb = BlockBoundsExtender.getFarthestBound(aabbs, southDir);
            aabbs.set(aabb, BlockBoundsExtender.extendAABB(aabbs.get(aabb), southDir));
        }
        if (west) {
            aabb = BlockBoundsExtender.getFarthestBound(aabbs, westDir);
            aabbs.set(aabb, BlockBoundsExtender.extendAABB(aabbs.get(aabb), westDir));
        }
        return aabbs;
    }

    private static List<AABB> extendFromEmpty(Direction vRelative, Direction hRelative, boolean up, boolean down, boolean north, boolean east, boolean south, boolean west) {
        boolean relativeUp = vRelative == Direction.DOWN ? up : down;
        boolean relativeDown = vRelative == Direction.DOWN ? down : up;
        boolean relativeNorth = false;
        boolean relativeEast = false;
        boolean relativeSouth = false;
        boolean relativeWest = false;
        switch (hRelative) {
            case NORTH: {
                relativeNorth = north;
                relativeEast = east;
                relativeSouth = south;
                relativeWest = west;
                break;
            }
            case EAST: {
                relativeNorth = west;
                relativeEast = north;
                relativeSouth = east;
                relativeWest = south;
                break;
            }
            case SOUTH: {
                relativeNorth = south;
                relativeEast = west;
                relativeSouth = north;
                relativeWest = east;
                break;
            }
            case WEST: {
                relativeNorth = east;
                relativeEast = south;
                relativeSouth = west;
                relativeWest = north;
            }
        }
        boolean upNorth = relativeUp && relativeNorth;
        boolean upEast = relativeUp && relativeEast;
        boolean upSouth = relativeUp && relativeSouth;
        boolean upWest = relativeUp && relativeWest;
        boolean downNorth = relativeDown && relativeNorth;
        boolean downEast = relativeDown && relativeEast;
        boolean downSouth = relativeDown && relativeSouth;
        boolean downWest = relativeDown && relativeWest;
        boolean northEast = relativeNorth && relativeEast;
        boolean northWest = relativeNorth && relativeWest;
        boolean southEast = relativeSouth && relativeEast;
        boolean southWest = relativeSouth && relativeWest;
        int count = (relativeUp ? 1 : 0) + (relativeDown ? 1 : 0) + (relativeNorth ? 1 : 0) + (relativeEast ? 1 : 0) + (relativeSouth ? 1 : 0) + (relativeWest ? 1 : 0);
        ArrayList<AABB> aabbs = new ArrayList<AABB>(count);
        if (relativeUp) {
            aabbs.add(new AABB(upWest ? 0.0 : 0.02, 0.98, upNorth ? 0.0 : 0.02, upEast ? 1.0 : 0.98, 1.0, upSouth ? 1.0 : 0.98));
        }
        if (relativeDown) {
            aabbs.add(new AABB(downWest ? 0.0 : 0.02, 0.0, downNorth ? 0.0 : 0.02, downEast ? 1.0 : 0.98, 0.02, downSouth ? 1.0 : 0.98));
        }
        if (relativeNorth) {
            aabbs.add(new AABB(northWest ? 0.0 : 0.02, 0.02, 0.0, northEast ? 1.0 : 0.98, 0.98, 0.02));
        }
        if (relativeEast) {
            aabbs.add(new AABB(1.0, 0.02, 0.02, 0.98, 0.98, 0.98));
        }
        if (relativeSouth) {
            aabbs.add(new AABB(southWest ? 0.0 : 0.02, 0.02, 0.98, southEast ? 1.0 : 0.02, 0.98, 1.0));
        }
        if (relativeWest) {
            aabbs.add(new AABB(0.0, 0.02, 0.02, 0.02, 0.98, 0.98));
        }
        return aabbs;
    }

    private static AABB extendAABB(AABB aabb, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> aabb.m_165887_(0.0);
            case Direction.UP -> aabb.m_165893_(1.0);
            case Direction.NORTH -> aabb.m_165889_(0.0);
            case Direction.EAST -> aabb.m_165891_(1.0);
            case Direction.SOUTH -> aabb.m_165895_(1.0);
            case Direction.WEST -> aabb.m_165880_(0.0);
        };
    }

    private static int getFarthestBound(List<AABB> aabbs, Direction face) {
        assert (aabbs.size() > 0);
        if (aabbs.size() == 1) {
            return 0;
        }
        int step = face.m_122421_().m_122540_();
        Double bestStep = null;
        int best = -1;
        for (int i = 0; i < aabbs.size(); ++i) {
            AABB bounds = aabbs.get(i);
            double result = BlockBoundsExtender.getBoundsLimit(bounds, face);
            if (best != -1 && !(Math.abs((double)step - bestStep) < Math.abs((double)step - result))) continue;
            best = i;
            bestStep = result;
        }
        return best;
    }

    private static double getBoundsLimit(AABB bounds, Direction face) {
        if (face.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE)) {
            return bounds.m_82374_(face.m_122434_());
        }
        return bounds.m_82340_(face.m_122434_());
    }
}

