/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.stellarity.block_entity;

import java.util.Iterator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2881;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5743;
import net.minecraft.class_5894;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import xyz.kohara.stellarity.StellarityBlockEntityTypes;
import xyz.kohara.stellarity.StellarityRecipeTypes;
import xyz.kohara.stellarity.block.AltarOfTheAccursed;
import xyz.kohara.stellarity.interface_injection.ExtEndDragonFight;
import xyz.kohara.stellarity.interface_injection.ExtItemEntity;
import xyz.kohara.stellarity.recipe.AltarRecipe;

public class AltarOfTheAccursedBlockEntity
extends class_2586 {
    private long ticksPassed = 0L;

    public AltarOfTheAccursedBlockEntity(class_2338 pos, class_2680 state) {
        this(StellarityBlockEntityTypes.ALTAR_OF_THE_ACCURSED, pos, state);
    }

    public AltarOfTheAccursedBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, T blockEntity) {
        AltarOfTheAccursed.State state = (AltarOfTheAccursed.State)((Object)blockState.method_11654(AltarOfTheAccursed.STATE));
        if (blockEntity instanceof AltarOfTheAccursedBlockEntity) {
            AltarOfTheAccursedBlockEntity entity = (AltarOfTheAccursedBlockEntity)blockEntity;
            ++entity.ticksPassed;
            double x = (double)blockPos.method_10263() + 0.5;
            double y = (double)blockPos.method_10264() + 0.5;
            double z = (double)blockPos.method_10260() + 0.5;
            if (level.method_8608()) {
                if (state.isLocked()) {
                    return;
                }
                float angle = (float)entity.ticksPassed / 20.0f;
                double dx = class_3532.method_15362((float)angle);
                double dz = class_3532.method_15374((float)angle);
                class_5743 purpleParticle = new class_5743(new Vector3f(0.733f, 0.0f, 1.0f), new Vector3f(0.106f, 0.0f, 0.145f), 1.4f);
                level.method_8406((class_2394)purpleParticle, x + dx, y, z + dz, 0.0, 0.0, 0.0);
                level.method_8406((class_2394)purpleParticle, x - dx, y, z - dz, 0.0, 0.0, 0.0);
                dx = (double)class_3532.method_15362((float)(-angle)) * 1.5;
                dz = (double)class_3532.method_15374((float)(-angle)) * 1.5;
                level.method_8406((class_2394)purpleParticle, x + dx, y, z + dz, 0.0, 0.0, 0.0);
                level.method_8406((class_2394)purpleParticle, x - dx, y, z - dz, 0.0, 0.0, 0.0);
                if (entity.ticksPassed % 3L == 0L) {
                    dx = level.field_9229.method_43059() * 0.5;
                    dz = level.field_9229.method_43059() * 0.5;
                    level.method_8406((class_2394)class_2398.field_11215, x + dx, y + 1.5, z + dz, dx * 2.0, -1.5, dz * 2.0);
                }
                level.method_8406((class_2394)class_2398.field_11249, x, y + 0.5, z, 0.0, 0.0, 0.0);
            } else if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (!state.isCreative()) {
                    AltarOfTheAccursed.State newState;
                    class_3218 end = serverLevel.method_8503().method_3847(class_1937.field_25181);
                    class_2881 dragonFight = end == null ? null : end.method_29198();
                    AltarOfTheAccursed.State state2 = newState = dragonFight != null && dragonFight.method_12536() && ((ExtEndDragonFight)dragonFight).stellarity$dragonKilled() ? AltarOfTheAccursed.State.UNLOCKED : AltarOfTheAccursed.State.LOCKED;
                    if (state != newState) {
                        serverLevel.method_8501(blockPos, (class_2680)blockState.method_11657(AltarOfTheAccursed.STATE, (Comparable)((Object)newState)));
                    }
                }
                if (entity.ticksPassed % 10L == 0L) {
                    entity.handleItems(serverLevel, x, y, z, blockState);
                }
            }
        }
    }

    private void handleItems(class_3218 serverLevel, double x, double y, double z, class_2680 blockState) {
        AltarOfTheAccursed.State state = (AltarOfTheAccursed.State)((Object)blockState.method_11654(AltarOfTheAccursed.STATE));
        List itemEntities = serverLevel.method_8390(class_1542.class, new class_238(x - 0.5, y + 0.75 - 0.5, z - 0.5, x + 0.5, y + 0.75 + 0.5, z + 0.5), entity -> ((ExtItemEntity)entity).stellarity$getItemMode() != ExtItemEntity.ItemMode.RESULT);
        class_1657 player = serverLevel.method_18459(x, y, z, 10.0, false);
        if (state.isLocked()) {
            if (!itemEntities.isEmpty() && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"message.stellarity.altar_of_the_accursed_locked").method_27692(class_124.field_1064)));
            }
            return;
        }
        List<class_1799> itemStacks = itemEntities.stream().map(class_1542::method_6983).toList();
        ExtItemEntity.ItemMode itemMode = player != null && player.method_18276() ? ExtItemEntity.ItemMode.PICKUP : ExtItemEntity.ItemMode.CRAFTING;
        for (class_1542 entity2 : itemEntities) {
            ExtItemEntity itemEntity = (ExtItemEntity)entity2;
            itemEntity.stellarity$setItemMode(itemMode);
        }
        if (itemEntities.size() < 2) {
            return;
        }
        AltarRecipe.Output output = null;
        AltarRecipe hitRecipe = null;
        if (itemMode == ExtItemEntity.ItemMode.CRAFTING) {
            List allRecipes = serverLevel.method_8433().method_30027(StellarityRecipeTypes.ALTAR_RECIPE);
            Iterator iterator = allRecipes.iterator();
            while (iterator.hasNext()) {
                class_8786 recipeHolder = (class_8786)iterator.next();
                AltarRecipe recipe = (AltarRecipe)recipeHolder.comp_1933();
                output = recipe.craft(itemStacks);
                if (output == null) continue;
                hitRecipe = recipe;
                break;
            }
        }
        if (output == null) {
            return;
        }
        for (class_1542 entity3 : itemEntities) {
            ExtItemEntity itemEntity = (ExtItemEntity)entity3;
            itemEntity.stellarity$updateResults(output.remainders());
        }
        class_1542 resultItem = new class_1542((class_1937)serverLevel, x, y + 0.75, z, output.result());
        ((ExtItemEntity)resultItem).stellarity$setItemMode(ExtItemEntity.ItemMode.RESULT);
        serverLevel.method_8649((class_1297)resultItem);
    }
}

