/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.stellarity.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import xyz.kohara.stellarity.Stellarity;
import xyz.kohara.stellarity.StellarityRecipeSerializers;
import xyz.kohara.stellarity.recipe.AltarRecipe;

public record AltarSimpleRecipe(class_2960 id, HashMap<class_1856, Integer> ingredients, class_1799 result) implements AltarRecipe
{
    public AltarSimpleRecipe(class_2960 id, HashMap<class_1856, Integer> ingredients, class_1799 result) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
        HashSet<class_1792> items = new HashSet<class_1792>();
        for (class_1856 entry : ingredients.keySet()) {
            for (class_1799 stack : entry.method_8105()) {
                if (items.add(stack.method_7909())) continue;
                Stellarity.LOGGER.error("Ingredients are overlapping and may not work correctly. Altar Recipe ID: {}", (Object)id);
            }
        }
    }

    @Override
    public AltarRecipe.Output craft(List<class_1799> itemStacks) {
        HashMap<class_1856, Integer> required = new HashMap<class_1856, Integer>(this.ingredients);
        HashMap<class_1799, Integer> available = new HashMap<class_1799, Integer>();
        for (class_1799 itemStack : itemStacks) {
            int availableCount = itemStack.method_7947();
            available.put(itemStack, itemStack.method_7947());
            boolean exists = false;
            for (class_1856 requirement : this.ingredients.keySet()) {
                Integer requiredCount = required.get(requirement);
                if (!requirement.method_8093(itemStack)) continue;
                exists = true;
                if (requiredCount == 0) break;
                if (availableCount == requiredCount) {
                    required.put(requirement, 0);
                    available.remove(itemStack);
                    break;
                }
                if (availableCount > requiredCount) {
                    required.put(requirement, 0);
                    available.put(itemStack, availableCount - requiredCount);
                    break;
                }
                required.put(requirement, requiredCount - availableCount);
            }
            if (exists) continue;
            return null;
        }
        for (Integer counts : required.values()) {
            if (counts <= 0) continue;
            return null;
        }
        return new AltarRecipe.Output(available, this.result.method_7972());
    }

    @NotNull
    public class_1865<? extends class_1860<AltarRecipe.Input>> method_8119() {
        return StellarityRecipeSerializers.ALTAR_SIMPLE;
    }

    public static class Serializer
    implements class_1865<AltarSimpleRecipe> {
        public AltarSimpleRecipe fromJson(class_2960 resourceLocation, JsonObject jsonObject) {
            HashMap<class_1856, Integer> ingredients = Serializer.ingredientsFromJson(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients"));
            class_1799 itemStack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            return new AltarSimpleRecipe(resourceLocation, ingredients, itemStack);
        }

        private static HashMap<class_1856, Integer> ingredientsFromJson(JsonArray jsonArray) {
            if (jsonArray.isEmpty()) {
                throw new JsonParseException("No ingredients for altar recipe");
            }
            HashMap<class_1856, Integer> ingredients = new HashMap<class_1856, Integer>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject entry = jsonArray.get(i).getAsJsonObject();
                int count = 1;
                if (entry.has("count")) {
                    count = entry.get("count").getAsInt();
                }
                class_1856 ingredient = class_1856.method_52177((JsonElement)entry.get("ingredient"));
                ingredients.put(ingredient, count);
            }
            return ingredients;
        }

        public AltarSimpleRecipe fromNetwork(class_2960 resourceLocation, class_2540 buf) {
            int size = buf.readInt();
            HashMap<class_1856, Integer> ingredients = new HashMap<class_1856, Integer>();
            for (int i = 0; i < size; ++i) {
                class_1856 ingredient = class_1856.method_8086((class_2540)buf);
                int count = buf.readInt();
                ingredients.put(ingredient, count);
            }
            class_1799 itemStack = buf.method_10819();
            return new AltarSimpleRecipe(resourceLocation, ingredients, itemStack);
        }

        public void toNetwork(class_2540 buf, AltarSimpleRecipe recipe) {
            buf.writeInt(recipe.ingredients.size());
            for (Map.Entry<class_1856, Integer> entry : recipe.ingredients.entrySet()) {
                entry.getKey().method_8088(buf);
                buf.writeInt(entry.getValue().intValue());
            }
            buf.method_10793(recipe.result);
        }
    }
}

