/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.stellarity.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import xyz.kohara.stellarity.Stellarity;
import xyz.kohara.stellarity.StellarityRecipeSerializers;
import xyz.kohara.stellarity.recipe.AltarRecipe;

public record AltarSimpleRecipe(class_2960 id, HashMap<class_1856, Integer> ingredients, class_1799 result) implements AltarRecipe
{
    public AltarSimpleRecipe(class_2960 id, HashMap<class_1856, Integer> ingredients, class_1799 result) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
        Stellarity.LOGGER.info("For the sake of convience, recipe validation is skipped. Please confirm on older versions!");
    }

    @Override
    public AltarRecipe.Output craft(List<class_1799> itemStacks) {
        HashMap<class_1856, Integer> required = new HashMap<class_1856, Integer>(this.ingredients);
        HashMap<class_1799, Integer> available = new HashMap<class_1799, Integer>();
        for (class_1799 itemStack : itemStacks) {
            int availableCount = itemStack.method_7947();
            available.put(itemStack, itemStack.method_7947());
            boolean exists = false;
            for (class_1856 requirement : this.ingredients.keySet()) {
                Integer requiredCount = required.get(requirement);
                if (!requirement.method_8093(itemStack)) continue;
                exists = true;
                if (requiredCount == 0) break;
                if (availableCount == requiredCount) {
                    required.put(requirement, 0);
                    available.remove(itemStack);
                    break;
                }
                if (availableCount > requiredCount) {
                    required.put(requirement, 0);
                    available.put(itemStack, availableCount - requiredCount);
                    break;
                }
                required.put(requirement, requiredCount - availableCount);
            }
            if (exists) continue;
            return null;
        }
        for (Integer counts : required.values()) {
            if (counts <= 0) continue;
            return null;
        }
        return new AltarRecipe.Output(available, this.result.method_7972());
    }

    @NotNull
    public class_1865<? extends class_1860<AltarRecipe.Input>> method_8119() {
        return StellarityRecipeSerializers.ALTAR_SIMPLE;
    }

    @NotNull
    public class_1799 assemble(AltarRecipe.Input recipeInput, class_7225.class_7874 provider) {
        return this.getResultItem(provider);
    }

    public static class Serializer
    implements class_1865<AltarSimpleRecipe> {
        private static final MapCodec<Map.Entry<class_1856, Integer>> INGREDIENT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("ingredient").forGetter(Map.Entry::getKey), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(Map.Entry::getValue)).apply((Applicative)instance, Map::entry));
        public static final class_9139<class_9129, AltarSimpleRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);
        public static final MapCodec<AltarSimpleRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)INGREDIENT_CODEC.codec().listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients.entrySet().stream().toList()), (App)class_1799.field_24671.fieldOf("result").forGetter(AltarRecipe::result)).apply((Applicative)instance, (ingredients, result) -> {
            HashMap<class_1856, Integer> ingredientMap = new HashMap<class_1856, Integer>();
            for (Map.Entry ingredient : ingredients) {
                ingredientMap.put((class_1856)ingredient.getKey(), (Integer)ingredient.getValue());
            }
            return new AltarSimpleRecipe(null, ingredientMap, (class_1799)result);
        }));

        @NotNull
        public MapCodec<AltarSimpleRecipe> method_53736() {
            return CODEC;
        }

        @NotNull
        public class_9139<class_9129, AltarSimpleRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static AltarSimpleRecipe fromNetwork(class_9129 buf) {
            int size = buf.readInt();
            HashMap<class_1856, Integer> ingredients = new HashMap<class_1856, Integer>();
            for (int i = 0; i < size; ++i) {
                class_1856 ingredient = (class_1856)class_1856.field_48355.decode((Object)buf);
                int count = buf.readInt();
                ingredients.put(ingredient, count);
            }
            class_1799 itemStack = (class_1799)class_1799.field_48349.decode((Object)buf);
            return new AltarSimpleRecipe(null, ingredients, itemStack);
        }

        private static void toNetwork(class_9129 buf, AltarSimpleRecipe recipe) {
            buf.method_53002(recipe.ingredients.size());
            for (Map.Entry<class_1856, Integer> entry : recipe.ingredients.entrySet()) {
                class_1856.field_48355.encode((Object)buf, (Object)entry.getKey());
                buf.method_53002(entry.getValue().intValue());
            }
            class_1799.field_48349.encode((Object)buf, (Object)recipe.result);
        }
    }
}

