/*
 * Decompiled with CFR 0.152.
 */
package lgbt.mykel.qol.listener;

import java.util.HashMap;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BetterTotemListener
implements Listener {
    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.getHealth() <= event.getFinalDamage() && this.hasTotem(player) && player.getInventory().getItemInOffHand().getType() != Material.TOTEM_OF_UNDYING) {
            event.setCancelled(true);
            this.consumeItem(player, 1, Material.TOTEM_OF_UNDYING);
            player.playEffect(EntityEffect.TOTEM_RESURRECT);
            this.applyTotemEffects(player);
            player.damage(event.getFinalDamage() * 0.9 > player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() ? player.getHealth() - 1.0 : event.getFinalDamage() / 3.0);
        }
    }

    public boolean hasTotem(Player player) {
        return player.getInventory().contains(Material.TOTEM_OF_UNDYING);
    }

    private void applyTotemEffects(Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 300, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 2400, 0));
        player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 2700, 1));
    }

    public boolean consumeItem(Player player, int count, Material mat) {
        HashMap ammo = player.getInventory().all(mat);
        int found = 0;
        for (ItemStack stack : ammo.values()) {
            found += stack.getAmount();
        }
        if (count > found) {
            return false;
        }
        for (Integer index : ammo.keySet()) {
            ItemStack stack2 = (ItemStack)ammo.get(index);
            int removed = Math.min(count, stack2.getAmount());
            count -= removed;
            if (stack2.getAmount() == removed) {
                player.getInventory().setItem(index.intValue(), null);
            } else {
                stack2.setAmount(stack2.getAmount() - removed);
            }
            if (count > 0) continue;
            break;
        }
        player.updateInventory();
        return true;
    }
}

