/*
 * Decompiled with CFR 0.152.
 */
package lgbt.mykel.qol.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RecipeLoader {
    private final JavaPlugin plugin;

    public RecipeLoader(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadRecipes(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            this.plugin.getLogger().warning("Recipe directory not found: " + dir.getPath());
            return;
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                this.parseAndRegister(json);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load recipe from " + file.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void parseAndRegister(JsonObject json) {
        String id = this.getOrThrow(json, "id").toLowerCase(Locale.ROOT);
        String mode = json.has("mode") ? json.get("mode").getAsString().toUpperCase(Locale.ROOT) : "CRAFTING";
        String type = json.has("type") ? json.get("type").getAsString().toUpperCase(Locale.ROOT) : "SHAPED";
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        switch (mode) {
            case "CRAFTING": {
                this.registerCraftingRecipe(json, key, type);
                break;
            }
            case "STONECUTTER": {
                this.registerStonecutterRecipe(json, key);
                break;
            }
            case "FURNACE": 
            case "BLAST": 
            case "BLAST_FURNACE": {
                this.registerFurnaceRecipe(json, key, mode);
                break;
            }
            default: {
                this.plugin.getLogger().warning("Unknown mode in recipe " + id + ": " + mode);
            }
        }
    }

    private void registerCraftingRecipe(JsonObject json, NamespacedKey key, String type) {
        HashMap<Character, Material> shapedIngredients = new HashMap<Character, Material>();
        ArrayList<Material> shapelessIngredients = new ArrayList<Material>();
        JsonElement ingredientsEl = json.get("ingredients");
        if (ingredientsEl == null) {
            this.plugin.getLogger().warning("Missing ingredients in recipe: " + String.valueOf(key));
            return;
        }
        if (ingredientsEl.isJsonObject()) {
            JsonObject ingredientsObj = ingredientsEl.getAsJsonObject();
            for (Map.Entry entry : ingredientsObj.entrySet()) {
                String symbol = (String)entry.getKey();
                String matName = ((JsonElement)entry.getValue()).getAsString();
                Material mat = Material.matchMaterial((String)matName.toUpperCase(Locale.ROOT));
                if (mat == null) {
                    this.plugin.getLogger().warning("Unknown material '" + matName + "' in recipe " + String.valueOf(key));
                    continue;
                }
                if (symbol.length() == 1) {
                    shapedIngredients.put(Character.valueOf(symbol.charAt(0)), mat);
                    continue;
                }
                this.plugin.getLogger().warning("Invalid ingredient key '" + symbol + "' in " + String.valueOf(key));
            }
        } else if (ingredientsEl.isJsonArray()) {
            JsonArray arr = ingredientsEl.getAsJsonArray();
            for (JsonElement el : arr) {
                String matName = el.getAsString();
                Material mat = Material.matchMaterial((String)matName.toUpperCase(Locale.ROOT));
                if (mat == null) {
                    this.plugin.getLogger().warning("Unknown material '" + matName + "' in recipe " + String.valueOf(key));
                    continue;
                }
                shapelessIngredients.add(mat);
            }
        } else {
            this.plugin.getLogger().warning("Invalid ingredients format in recipe " + String.valueOf(key));
            return;
        }
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        count = Math.max(1, Math.min(count, 64));
        Material resultMat = Material.matchMaterial((String)json.get("id").getAsString().toUpperCase(Locale.ROOT));
        if (resultMat == null) {
            this.plugin.getLogger().warning("Unknown result material for " + String.valueOf(key));
            return;
        }
        ItemStack result = new ItemStack(resultMat, count);
        if (type.equals("SHAPELESS") || !json.has("shape")) {
            ShapelessRecipe recipe = new ShapelessRecipe(key, result);
            if (!shapelessIngredients.isEmpty()) {
                for (Material mat : shapelessIngredients) {
                    recipe.addIngredient(mat);
                }
            } else {
                for (Material mat : shapedIngredients.values()) {
                    recipe.addIngredient(mat);
                }
            }
            Bukkit.addRecipe((Recipe)recipe);
        } else {
            JsonArray shapeArr = json.getAsJsonArray("shape");
            if (shapeArr.size() < 1 || shapeArr.size() > 3) {
                this.plugin.getLogger().warning("Invalid shape size in " + String.valueOf(key));
                return;
            }
            ShapedRecipe recipe = new ShapedRecipe(key, result);
            String[] shape = new String[shapeArr.size()];
            for (int i = 0; i < shapeArr.size(); ++i) {
                String line = shapeArr.get(i).getAsString();
                if (line.length() > 3) {
                    this.plugin.getLogger().warning("Invalid shape line length in " + String.valueOf(key));
                    return;
                }
                shape[i] = line;
            }
            recipe.shape(shape);
            for (Map.Entry entry : shapedIngredients.entrySet()) {
                recipe.setIngredient(((Character)entry.getKey()).charValue(), (Material)entry.getValue());
            }
            Bukkit.addRecipe((Recipe)recipe);
        }
        this.plugin.getLogger().info("Registered crafting recipe: " + String.valueOf(key));
    }

    private void registerStonecutterRecipe(JsonObject json, NamespacedKey key) {
        String resultName = this.getOrThrow(json, "result");
        Material resultMat = Material.matchMaterial((String)resultName.toUpperCase(Locale.ROOT));
        if (resultMat == null) {
            this.plugin.getLogger().warning("Invalid result material for stonecutter recipe: " + String.valueOf(key));
            return;
        }
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        count = Math.max(1, Math.min(count, 64));
        ItemStack result = new ItemStack(resultMat, count);
        ArrayList<String> ingredientNames = new ArrayList<String>();
        if (json.has("ingredient")) {
            ingredientNames.add(json.get("ingredient").getAsString());
        } else if (json.has("ingredients")) {
            JsonArray arr = json.getAsJsonArray("ingredients");
            for (JsonElement el : arr) {
                ingredientNames.add(el.getAsString());
            }
        } else {
            this.plugin.getLogger().warning("Missing ingredient(s) in stonecutter recipe: " + String.valueOf(key));
            return;
        }
        int index = 0;
        for (String ingredientName : ingredientNames) {
            NamespacedKey namespacedKey;
            Material ingredientMat = Material.matchMaterial((String)ingredientName.toUpperCase(Locale.ROOT));
            if (ingredientMat == null) {
                this.plugin.getLogger().warning("Unknown stonecutter ingredient '" + ingredientName + "' in " + String.valueOf(key));
                continue;
            }
            if (ingredientNames.size() > 1) {
                ++index;
                namespacedKey = new NamespacedKey((Plugin)this.plugin, key.getKey() + "_" + index);
            } else {
                namespacedKey = key;
            }
            NamespacedKey uniqueKey = namespacedKey;
            StonecuttingRecipe recipe = new StonecuttingRecipe(uniqueKey, result, ingredientMat);
            Bukkit.addRecipe((Recipe)recipe);
        }
        this.plugin.getLogger().info("Registered stonecutter recipe: " + String.valueOf(key) + " (" + ingredientNames.size() + " ingredient(s))");
    }

    private void registerFurnaceRecipe(JsonObject json, NamespacedKey key, String mode) {
        String resultName = this.getOrThrow(json, "result");
        String ingredientName = this.getOrThrow(json, "ingredient");
        Material resultMat = Material.matchMaterial((String)resultName.toUpperCase(Locale.ROOT));
        Material ingredientMat = Material.matchMaterial((String)ingredientName.toUpperCase(Locale.ROOT));
        if (resultMat == null || ingredientMat == null) {
            this.plugin.getLogger().warning("Invalid " + mode + " recipe: " + String.valueOf(key));
            return;
        }
        float exp = json.has("experience") ? json.get("experience").getAsFloat() : 0.0f;
        int cookTime = json.has("cookTime") ? json.get("cookTime").getAsInt() : 200;
        ItemStack result = new ItemStack(resultMat);
        Bukkit.addRecipe((Recipe)(switch (mode) {
            case "BLAST", "BLAST_FURNACE" -> new BlastingRecipe(key, result, ingredientMat, exp, cookTime);
            default -> new FurnaceRecipe(key, result, ingredientMat, exp, cookTime);
        }));
        this.plugin.getLogger().info("Registered " + mode.toLowerCase() + " recipe: " + String.valueOf(key));
    }

    private String getOrThrow(JsonObject obj, String key) {
        if (!obj.has(key)) {
            throw new IllegalArgumentException("Missing required field: " + key);
        }
        return obj.get(key).getAsString();
    }
}

