/*
 * Decompiled with CFR 0.152.
 */
package lgbt.mykel.qol.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import org.bukkit.plugin.java.JavaPlugin;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static void saveResource(JavaPlugin plugin, String resourcePath, File targetFile, boolean replace) {
        try (InputStream in = plugin.getResource(resourcePath);){
            if (in == null) {
                plugin.getLogger().warning("Resource not found in JAR: " + resourcePath);
                return;
            }
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            if (!targetFile.exists() || replace) {
                Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                plugin.getLogger().info("Saved resource: " + targetFile.getPath());
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe("Failed to save resource: " + resourcePath + " (" + e.getMessage() + ")");
        }
    }

    public static void saveResourceFolder(JavaPlugin plugin, String sourcePath, File targetDir, boolean replace) {
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        try {
            URI uri = plugin.getClass().getClassLoader().getResource(sourcePath).toURI();
            if ("jar".equals(uri.getScheme())) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    Path root = fs.getPath(sourcePath, new String[0]);
                    ResourceUtils.walkAndCopy(plugin, sourcePath, root, targetDir, replace);
                }
            } else {
                Path root = Paths.get(uri);
                ResourceUtils.walkAndCopy(plugin, sourcePath, root, targetDir, replace);
            }
            plugin.getLogger().info("Extracted folder: " + sourcePath);
        }
        catch (Exception e) {
            plugin.getLogger().severe("Failed to extract folder " + sourcePath + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void copyIfMissing(File source, File target) {
        if (target.exists()) {
            return;
        }
        try {
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void walkAndCopy(JavaPlugin plugin, String sourcePath, Path root, File targetDir, boolean replace) throws IOException {
        Files.walk(root, new FileVisitOption[0]).forEach(path -> {
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                String relative = root.relativize((Path)path).toString().replace("\\", "/");
                File outFile = new File(targetDir, relative);
                outFile.getParentFile().mkdirs();
                try (InputStream in = plugin.getResource(sourcePath + "/" + relative);){
                    if (in == null) {
                        plugin.getLogger().warning("Could not find resource inside JAR: " + sourcePath + "/" + relative);
                        return;
                    }
                    if (!outFile.exists() || replace) {
                        Files.copy(in, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            }
            catch (IOException e) {
                plugin.getLogger().warning("Failed to copy " + String.valueOf(path) + ": " + e.getMessage());
            }
        });
    }
}

