/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.clt;

import dev.norska.clt.bukkit.Metrics;
import dev.norska.clt.commands.CLTAdminCommands;
import dev.norska.clt.commands.CLTAdminTabComplete;
import dev.norska.clt.commands.CLTUserCommands;
import dev.norska.clt.listeners.JoinUpdateNotifier;
import dev.norska.clt.ndev.NorskaHandler;
import dev.norska.clt.ndev.NorskaUtils;
import dev.norska.clt.perms.CLTPermHandler;
import dev.norska.clt.tasks.CLTTaskHandler;
import dev.norska.niridiumcolorapi.IridiumColorAPI;
import java.io.File;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ClearLagTimer
extends JavaPlugin {
    private static ClearLagTimer instance;
    public int interval;
    private int counter;
    public String prefix;
    private CLTTaskHandler taskHandler = new CLTTaskHandler(this);
    private NorskaHandler nHandler = new NorskaHandler();
    private NorskaUtils nUtils = new NorskaUtils();
    private CLTPermHandler permHandler = new CLTPermHandler();
    private File file = new File("plugins/ClearLag/config.yml");

    public ClearLagTimer() {
        instance = this;
    }

    public static ClearLagTimer getInstance() {
        return instance;
    }

    public void onEnable() {
        this.generateFiles();
        this.cache();
        this.getNHandler().getMessageFeedbackHandler().loadConsoleMessages();
        this.checkUpdates();
        String string = this.prefix = Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17") || Bukkit.getVersion().contains("1.18") || Bukkit.getVersion().contains("1.19") || Bukkit.getVersion().contains("1.20") || Bukkit.getVersion().contains("1.21") ? IridiumColorAPI.process("&8[<GRADIENT:ff0000>ClearLagTimer</GRADIENT:ffe42b>&8]") : IridiumColorAPI.process("&8[&eClearLagTimer&8]");
        if (Bukkit.getServer().getPluginManager().getPlugin("ClearLag") == null) {
            this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("STARTUP_FAIL", this.prefix);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("STARTUP", this.prefix, this.getDescription().getVersion());
        this.fetchAliases();
        this.checkHooks();
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.file);
        this.counter = this.interval = configuration.getInt("auto-removal.autoremoval-interval");
        this.registerCommands();
        this.registerEvents();
        this.getTaskHandler().startCounter();
        this.startMetricsService();
        this.getNHandler().getMessageFeedbackHandler().loadTextComponents(this);
        this.getPermHandler().loadPerms();
    }

    public void generateFiles() {
        this.getNHandler().getConfigurationHandler().generateFiles(instance);
    }

    public void cache() {
        this.getNHandler().getCacheHandler().cache(instance);
    }

    private void checkUpdates() {
        this.getNHandler().getUpdateHandler().fetchVersionFromServer(instance);
        this.getNHandler().getUpdateHandler().checkForUpdates(instance);
    }

    private void checkHooks() {
        this.getNHandler().getHooksHandler().checkForHooks(instance);
    }

    private void fetchAliases() {
        this.getNUtils().fetchAliases(instance);
    }

    private void startMetricsService() {
        Metrics metrics = new Metrics(this, 6041);
    }

    private void registerCommands() {
        Objects.requireNonNull(this.getCommand("clearlagtimer")).setExecutor((CommandExecutor)new CLTAdminCommands(this));
        Objects.requireNonNull(this.getCommand("clearlagtimer")).setTabCompleter((TabCompleter)new CLTAdminTabComplete(this));
    }

    private void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new JoinUpdateNotifier(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CLTUserCommands(this), (Plugin)this);
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public CLTTaskHandler getTaskHandler() {
        return this.taskHandler;
    }

    public NorskaHandler getNHandler() {
        return this.nHandler;
    }

    public NorskaUtils getNUtils() {
        return this.nUtils;
    }

    public CLTPermHandler getPermHandler() {
        return this.permHandler;
    }
}

