/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.clt;

import dev.norska.clt.reflection.XReflection;
import dev.norska.clt.reflection.jvm.MethodMemberHandle;
import dev.norska.clt.reflection.minecraft.MinecraftClassHandle;
import dev.norska.clt.reflection.minecraft.MinecraftConnection;
import dev.norska.clt.reflection.minecraft.MinecraftMapping;
import dev.norska.clt.reflection.minecraft.MinecraftPackage;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Duration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XWorldBorder {
    public static final int ABSOLUTE_MAX_SIZE = 29999984;
    public static final double MAX_SIZE = 5.9999968E7;
    public static final double MAX_CENTER_COORDINATE = 2.9999984E7;
    private static final boolean SUPPORTS_NATIVE_WORLDBORDERS = ((MethodMemberHandle)XReflection.of(Player.class).method().named("setWorldBorder").returns((Class)Void.TYPE)).parameters(WorldBorder.class).exists();
    protected BorderBounds borderBounds;

    public abstract double getDamageBuffer();

    public abstract double getSizeLerpTarget();

    public abstract double getSize();

    public abstract boolean isWithinBorder(Location var1);

    public abstract int getWarningDistance();

    public abstract Duration getWarningTime();

    public abstract Location getCenter();

    public abstract void setFor(Player var1, boolean var2);

    public final BorderBounds getBorderBounds() {
        return this.borderBounds;
    }

    public abstract XWorldBorder copy();

    public abstract XWorldBorder setDamageBuffer(double var1);

    public abstract XWorldBorder setWarningTime(Duration var1);

    public abstract XWorldBorder setWarningDistance(int var1);

    public abstract XWorldBorder setSize(double var1, @NotNull Duration var3);

    public abstract XWorldBorder setCenter(double var1, double var3);

    public abstract XWorldBorder setSizeLerpTarget(double var1);

    public final double getDistanceToBorder(Location location) {
        if (this.borderBounds == null) {
            return this.getCenter().distanceSquared(location);
        }
        double x = location.getX();
        double z = location.getZ();
        double d2 = z - this.borderBounds.minZ;
        double d3 = this.borderBounds.maxZ - z;
        double d4 = x - this.borderBounds.minX;
        double d5 = this.borderBounds.maxX - x;
        double d6 = Math.min(d4, d5);
        d6 = Math.min(d6, d2);
        return Math.min(d6, d3);
    }

    protected void updateBorderBounds() {
        Location center = this.getCenter();
        this.borderBounds = new BorderBounds(center.getWorld(), center.getX(), center.getZ(), this.getSize());
    }

    public static XWorldBorder create() {
        if (SUPPORTS_NATIVE_WORLDBORDERS) {
            return new BukkitWorldBorder(Bukkit.createWorldBorder());
        }
        return new NMSWorldBorder();
    }

    public static XWorldBorder getOrCreate(Player player) {
        XWorldBorder wb = XWorldBorder.get(player);
        if (wb != null) {
            return wb;
        }
        wb = XWorldBorder.create();
        wb.setFor(player, true);
        if (!SUPPORTS_NATIVE_WORLDBORDERS) {
            NMSWorldBorder.WORLD_BORDERS.put(player.getUniqueId(), wb);
        }
        return wb;
    }

    @Nullable
    public static XWorldBorder get(Player player) {
        if (SUPPORTS_NATIVE_WORLDBORDERS) {
            WorldBorder worldBorder = player.getWorldBorder();
            return worldBorder == null ? null : new BukkitWorldBorder(worldBorder);
        }
        return (XWorldBorder)NMSWorldBorder.WORLD_BORDERS.get(player.getUniqueId());
    }

    public static XWorldBorder from(WorldBorder bukkitWb) {
        if (SUPPORTS_NATIVE_WORLDBORDERS) {
            return new BukkitWorldBorder(bukkitWb).copy();
        }
        NMSWorldBorder wb = new NMSWorldBorder();
        wb.world = bukkitWb.getCenter().getWorld();
        wb.centerX = bukkitWb.getCenter().getX();
        wb.centerZ = bukkitWb.getCenter().getZ();
        wb.size = bukkitWb.getSize();
        wb.sizeLerpTime = Duration.ZERO;
        wb.damagePerBlock = bukkitWb.getDamageAmount();
        wb.damageSafeZone = bukkitWb.getDamageBuffer();
        wb.warningTime = Duration.ofSeconds(bukkitWb.getWarningTime());
        wb.warningBlocks = bukkitWb.getWarningDistance();
        wb.handle = wb.createHandle();
        return wb;
    }

    public static final class BorderBounds {
        protected final World lastCenterWorld;
        protected final double lastCenterX;
        protected final double lastCenterZ;
        public final double minX;
        public final double minZ;
        public final double maxX;
        public final double maxZ;

        private static double clamp(double var0, double var2, double var4) {
            return var0 < var2 ? var2 : Math.min(var0, var4);
        }

        public boolean isCenterSame(World world, double centerX, double centerZ) {
            return this.lastCenterWorld == world && this.lastCenterX == centerX && this.lastCenterZ == centerZ;
        }

        public BorderBounds(World centerWorld, double centerX, double centerZ, double size) {
            this.lastCenterWorld = centerWorld;
            this.lastCenterX = centerX;
            this.lastCenterZ = centerZ;
            this.minX = BorderBounds.clamp(centerX - size / 2.0, -2.9999984E7, 2.9999984E7);
            this.minZ = BorderBounds.clamp(centerZ - size / 2.0, -2.9999984E7, 2.9999984E7);
            this.maxX = BorderBounds.clamp(centerX + size / 2.0, -2.9999984E7, 2.9999984E7);
            this.maxZ = BorderBounds.clamp(centerZ + size / 2.0, -2.9999984E7, 2.9999984E7);
        }
    }

    private static final class BukkitWorldBorder
    extends XWorldBorder {
        private final WorldBorder worldBorder;

        private BukkitWorldBorder(WorldBorder worldBorder) {
            this.worldBorder = worldBorder;
        }

        @Override
        public double getDamageBuffer() {
            return this.worldBorder.getDamageBuffer();
        }

        @Override
        public double getSizeLerpTarget() {
            return 0.0;
        }

        @Override
        public double getSize() {
            return this.worldBorder.getSize();
        }

        @Override
        public int getWarningDistance() {
            return this.worldBorder.getWarningDistance();
        }

        @Override
        public Duration getWarningTime() {
            return Duration.ofSeconds(this.worldBorder.getWarningTime());
        }

        @Override
        public void setFor(Player player, boolean forceInit) {
            player.setWorldBorder(this.worldBorder);
        }

        @Override
        public XWorldBorder setDamageBuffer(double blocks) {
            this.worldBorder.setDamageBuffer(blocks);
            return this;
        }

        @Override
        public XWorldBorder setWarningDistance(int blocks) {
            this.worldBorder.setWarningDistance(blocks);
            return this;
        }

        @Override
        public XWorldBorder setWarningTime(Duration time) {
            this.worldBorder.setWarningTime((int)time.getSeconds());
            return this;
        }

        @Override
        public XWorldBorder setSize(double newSize, @NotNull Duration duration) {
            this.worldBorder.setSize(newSize);
            return this;
        }

        @Override
        public XWorldBorder setCenter(double x, double z) {
            this.worldBorder.setCenter(x, z);
            return this;
        }

        @Override
        public XWorldBorder setSizeLerpTarget(double sizeLerpTarget) {
            return this;
        }

        @Override
        public Location getCenter() {
            Location center = this.worldBorder.getCenter();
            if (this.borderBounds == null || this.borderBounds.isCenterSame(center.getWorld(), center.getX(), center.getZ())) {
                this.updateBorderBounds();
            }
            return center;
        }

        @Override
        public boolean isWithinBorder(Location location) {
            return this.worldBorder.isInside(location);
        }

        @Override
        public XWorldBorder copy() {
            WorldBorder border = Bukkit.createWorldBorder();
            border.setCenter(this.worldBorder.getCenter());
            border.setSize(this.worldBorder.getSize());
            border.setDamageBuffer(this.worldBorder.getDamageBuffer());
            border.setDamageAmount(this.worldBorder.getDamageAmount());
            border.setWarningDistance(this.worldBorder.getWarningDistance());
            border.setWarningTime(this.worldBorder.getWarningTime());
            return new BukkitWorldBorder(border);
        }
    }

    private static final class NMSWorldBorder
    extends XWorldBorder {
        private static final MethodHandle WORLD_HANDLE;
        private static final MethodHandle WORLDBORDER;
        private static final MethodHandle WORLDBORDER_WORLD;
        private static final MethodHandle CENTER;
        private static final MethodHandle WARNING_DISTANCE;
        private static final MethodHandle WARNING_TIME;
        private static final MethodHandle SIZE;
        private static final MethodHandle TRANSITION;
        private static final MethodHandle PACKET_WARNING_DISTANCE;
        private static final MethodHandle PACKET_WARNING_DELAY;
        private static final MethodHandle PACKET_LERP_SIZE;
        private static final MethodHandle PACKET_INIT;
        private static final MethodHandle PACKET_CENTER;
        private static final MethodHandle PACKET_SIZE;
        private static final Object INITIALIZE;
        private static final boolean SUPPORTS_SEPARATE_PACKETS;
        private static final Map<UUID, XWorldBorder> WORLD_BORDERS;
        private Object handle;
        private double damagePerBlock = 0.2;
        private double damageSafeZone = 5.0;
        private double size = 100.0;
        private double sizeLerpTarget = 0.0;
        private Duration warningTime = Duration.ofSeconds(15L);
        private Duration sizeLerpTime = Duration.ZERO;
        private int warningBlocks = 5;
        private World world;
        private double centerX;
        private double centerZ;
        private final Set<Component> updateRequired = EnumSet.noneOf(Component.class);
        private boolean init = true;

        private NMSWorldBorder() {
        }

        @Override
        public NMSWorldBorder copy() {
            NMSWorldBorder wb = new NMSWorldBorder();
            wb.world = this.world;
            wb.centerX = this.centerX;
            wb.centerZ = this.centerZ;
            wb.size = this.size;
            wb.sizeLerpTime = this.sizeLerpTime;
            wb.damagePerBlock = this.damagePerBlock;
            wb.damageSafeZone = this.damageSafeZone;
            wb.warningTime = this.warningTime;
            wb.warningBlocks = this.warningBlocks;
            wb.handle = wb.createHandle();
            return wb;
        }

        public XWorldBorder setDamageAmount(double damage) {
            this.damagePerBlock = damage;
            return this;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        public double getDamageAmount() {
            return this.damagePerBlock;
        }

        @Override
        public XWorldBorder setDamageBuffer(double blocks) {
            this.damageSafeZone = blocks;
            return this;
        }

        @Override
        public double getDamageBuffer() {
            return this.damageSafeZone;
        }

        @Override
        public XWorldBorder setWarningTime(Duration time) {
            if (this.warningTime == time) {
                return this;
            }
            this.warningTime = time;
            this.update(Component.WARNING_DELAY);
            return this;
        }

        @Override
        public Duration getWarningTime() {
            return this.warningTime;
        }

        @Override
        public XWorldBorder setWarningDistance(int blocks) {
            if (this.warningBlocks == blocks) {
                return this;
            }
            this.warningBlocks = blocks;
            this.update(Component.WARNING_DISTANCE);
            return this;
        }

        @Override
        public double getSizeLerpTarget() {
            return this.sizeLerpTarget;
        }

        @Override
        public XWorldBorder setSizeLerpTarget(double sizeLerpTarget) {
            if (this.sizeLerpTarget == sizeLerpTarget) {
                return this;
            }
            this.sizeLerpTarget = sizeLerpTarget;
            this.update(Component.SIZE_LERP);
            return this;
        }

        @Override
        public int getWarningDistance() {
            return this.warningBlocks;
        }

        @Override
        public XWorldBorder setCenter(double x, double z) {
            if (this.centerX == x && this.centerZ == z) {
                return this;
            }
            this.centerX = x;
            this.centerZ = z;
            this.updateBorderBounds();
            this.update(Component.CENTER);
            return this;
        }

        @Override
        public Location getCenter() {
            return new Location(this.world, this.centerX, 0.0, this.centerZ);
        }

        @Override
        public XWorldBorder setSize(double newSize, @NotNull Duration duration) {
            if (this.size == newSize && this.sizeLerpTime.equals(duration)) {
                return this;
            }
            this.size = newSize;
            this.sizeLerpTime = duration;
            this.updateBorderBounds();
            this.update(Component.SIZE);
            if (!duration.isZero()) {
                this.update(Component.SIZE_LERP);
            }
            return this;
        }

        private void update(Component comp) {
            if (SUPPORTS_SEPARATE_PACKETS) {
                this.updateRequired.add(comp);
            }
        }

        @Override
        public boolean isWithinBorder(Location location) {
            if (this.borderBounds == null) {
                return false;
            }
            if (this.world != location.getWorld()) {
                return false;
            }
            return location.getX() + 1.0 > this.borderBounds.minX && location.getX() < this.borderBounds.maxX && location.getZ() + 1.0 > this.borderBounds.minZ && location.getZ() < this.borderBounds.maxZ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFor(Player player, boolean forceInit) {
            boolean init = forceInit || this.init;
            this.init = false;
            try {
                if (SUPPORTS_SEPARATE_PACKETS && !init) {
                    Object[] packets = new Object[this.updateRequired.size()];
                    int i = 0;
                    for (Component component : this.updateRequired) {
                        component.setHandle(this);
                        packets[i++] = component.createPacket(this);
                    }
                    MinecraftConnection.sendPacket(player, packets);
                } else {
                    for (Component component : this.updateRequired) {
                        component.setHandle(this);
                    }
                    Object packet = XReflection.supports(17) ? PACKET_INIT.invoke(this.handle) : PACKET_INIT.invoke(this.handle, INITIALIZE);
                    MinecraftConnection.sendPacket(player, packet);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                this.updateRequired.clear();
            }
        }

        private Object createHandle() {
            Objects.requireNonNull(this.world, "No world specified");
            try {
                Object worldBorder = WORLDBORDER.invoke();
                Object world = WORLD_HANDLE.invoke(this.world);
                WORLDBORDER_WORLD.invoke(worldBorder, world);
                return worldBorder;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        static {
            WORLD_BORDERS = new HashMap<UUID, XWorldBorder>();
            if (!SUPPORTS_NATIVE_WORLDBORDERS) {
                boolean supportsSeperatePackets;
                MinecraftClassHandle craftWorld;
                MinecraftClassHandle worldServer;
                MinecraftClassHandle wb;
                MethodHandle packetSize;
                MethodHandle packetCenter;
                MethodHandle packetLerpSize;
                MethodHandle packetWarnDelay;
                MethodHandle packetWarnDist;
                MethodHandle packetInit;
                Object initialize;
                block9: {
                    initialize = null;
                    packetInit = null;
                    packetWarnDist = null;
                    packetWarnDelay = null;
                    packetLerpSize = null;
                    packetCenter = null;
                    packetSize = null;
                    MethodHandles.Lookup lookup = MethodHandles.lookup();
                    wb = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level.border").named("WorldBorder");
                    worldServer = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "ServerLevel").map(MinecraftMapping.SPIGOT, "WorldServer");
                    craftWorld = XReflection.ofMinecraft().inPackage(MinecraftPackage.CB).named("CraftWorld");
                    try {
                        Class wbType;
                        if (XReflection.supports(17)) break block9;
                        try {
                            wbType = Class.forName("EnumWorldBorderAction");
                        }
                        catch (ClassNotFoundException e) {
                            wbType = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS).named("PacketPlayOutWorldBorder$EnumWorldBorderAction").unreflect();
                        }
                        packetInit = lookup.findConstructor((Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS).named("PacketPlayOutWorldBorder").unreflect(), MethodType.methodType(Void.TYPE, wb.reflect(), new Class[]{wbType}));
                        for (Object type : wbType.getEnumConstants()) {
                            if (!type.toString().equals("INITIALIZE")) continue;
                            initialize = type;
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    Function<String, MethodHandle> getPacket = packet -> (MethodHandle)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").named((String)packet).constructor(wb).unreflect();
                    packetWarnDist = getPacket.apply("ClientboundSetBorderWarningDistancePacket");
                    packetWarnDelay = getPacket.apply("ClientboundSetBorderWarningDelayPacket");
                    packetLerpSize = getPacket.apply("ClientboundSetBorderLerpSizePacket");
                    packetInit = getPacket.apply("ClientboundInitializeBorderPacket");
                    packetCenter = getPacket.apply("ClientboundSetBorderCenterPacket");
                    packetSize = getPacket.apply("ClientboundSetBorderSizePacket");
                    supportsSeperatePackets = true;
                }
                catch (Throwable ignored) {
                    supportsSeperatePackets = false;
                }
                PACKET_INIT = packetInit;
                PACKET_SIZE = packetSize;
                PACKET_CENTER = packetCenter;
                PACKET_LERP_SIZE = packetLerpSize;
                PACKET_WARNING_DELAY = packetWarnDelay;
                PACKET_WARNING_DISTANCE = packetWarnDist;
                SUPPORTS_SEPARATE_PACKETS = supportsSeperatePackets;
                WORLD_HANDLE = (MethodHandle)craftWorld.method().named("getHandle").returns(worldServer).unreflect();
                INITIALIZE = initialize;
                WORLDBORDER = (MethodHandle)wb.constructor().unreflect();
                WORLDBORDER_WORLD = (MethodHandle)wb.field().setter().named("world").returns(worldServer).unreflect();
                CENTER = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(18, "c").orElse("setCenter")).returns((Class)Void.TYPE)).parameters(Double.TYPE, Double.TYPE).unreflect();
                SIZE = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(18, "a").orElse("setSize")).returns((Class)Void.TYPE)).parameters(Double.TYPE).unreflect();
                WARNING_TIME = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(18, "b").orElse("setWarningTime")).returns((Class)Void.TYPE)).parameters(Integer.TYPE).unreflect();
                WARNING_DISTANCE = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(20, "c").v(18, "b").orElse("setWarningDistance")).returns((Class)Void.TYPE)).parameters(Integer.TYPE).unreflect();
                TRANSITION = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(18, "a").orElse("transitionSizeBetween")).returns((Class)Void.TYPE)).parameters(Double.TYPE, Double.TYPE, Long.TYPE).unreflect();
            } else {
                PACKET_SIZE = null;
                PACKET_CENTER = null;
                PACKET_INIT = null;
                PACKET_LERP_SIZE = null;
                PACKET_WARNING_DELAY = null;
                PACKET_WARNING_DISTANCE = null;
                TRANSITION = null;
                SIZE = null;
                WARNING_TIME = null;
                WARNING_DISTANCE = null;
                CENTER = null;
                WORLDBORDER_WORLD = null;
                WORLDBORDER = null;
                WORLD_HANDLE = null;
                INITIALIZE = null;
                SUPPORTS_SEPARATE_PACKETS = true;
            }
        }

        private static enum Component {
            SIZE{

                @Override
                protected void setHandle(NMSWorldBorder wb) throws Throwable {
                    SIZE.invoke(wb.handle, wb.size);
                }

                @Override
                protected Object createPacket(NMSWorldBorder wb) throws Throwable {
                    return PACKET_SIZE.invoke(wb.handle);
                }
            }
            ,
            SIZE_LERP{

                @Override
                protected void setHandle(NMSWorldBorder wb) throws Throwable {
                    TRANSITION.invoke(wb.handle, wb.sizeLerpTarget, wb.size, wb.sizeLerpTime.toMillis());
                }

                @Override
                protected Object createPacket(NMSWorldBorder wb) throws Throwable {
                    return PACKET_LERP_SIZE.invoke(wb.handle);
                }
            }
            ,
            WARNING_DISTANCE{

                @Override
                protected void setHandle(NMSWorldBorder wb) throws Throwable {
                    WARNING_DISTANCE.invoke(wb.handle, wb.warningBlocks);
                }

                @Override
                protected Object createPacket(NMSWorldBorder wb) throws Throwable {
                    return PACKET_WARNING_DISTANCE.invoke(wb.handle);
                }
            }
            ,
            WARNING_DELAY{

                @Override
                protected void setHandle(NMSWorldBorder wb) throws Throwable {
                    WARNING_TIME.invoke(wb.handle, wb.warningBlocks);
                }

                @Override
                protected Object createPacket(NMSWorldBorder wb) throws Throwable {
                    return PACKET_WARNING_DELAY.invoke(wb.handle);
                }
            }
            ,
            CENTER{

                @Override
                protected void setHandle(NMSWorldBorder wb) throws Throwable {
                    CENTER.invoke(wb.handle, wb.centerX, wb.centerZ);
                }

                @Override
                protected Object createPacket(NMSWorldBorder wb) throws Throwable {
                    return PACKET_CENTER.invoke(wb.handle);
                }
            };


            protected abstract void setHandle(NMSWorldBorder var1) throws Throwable;

            protected abstract Object createPacket(NMSWorldBorder var1) throws Throwable;
        }
    }

    public static final class Events
    implements Listener {
        @EventHandler
        public void onJoin(PlayerMoveEvent event) {
            XWorldBorder wb = XWorldBorder.get(event.getPlayer());
            if (wb == null) {
                return;
            }
            Player p = event.getPlayer();
            Location loc = p.getLocation();
            if (wb.isWithinBorder(loc)) {
                return;
            }
            double distance = wb.getDistanceToBorder(loc);
            if (distance < wb.getDamageBuffer()) {
                return;
            }
            p.damage(wb.getDamageBuffer() * distance);
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            XWorldBorder wb = XWorldBorder.get(player);
            if (wb == null) {
                return;
            }
            wb.setFor(player, true);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onWorldChange(PlayerChangedWorldEvent event) {
            Player player = event.getPlayer();
            XWorldBorder wb = XWorldBorder.get(player);
            if (wb == null) {
                return;
            }
            wb.setFor(player, true);
        }
    }
}

