/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.clt.ndev.handlers;

import dev.norska.clt.ClearLagTimer;
import dev.norska.clt.ndev.handlers.NDebug;
import dev.norska.clt.ndev.objects.MessageObject;
import dev.norska.clt.ndev.objects.SoundObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class CacheHandler {
    private HashMap<String, MessageObject> messageMap = new HashMap();
    private HashMap<String, SoundObject> soundMap = new HashMap();
    private String editablePrefix;
    private String days;
    private String day;
    private String hours;
    private String hour;
    private String minutes;
    private String minute;
    private String seconds;
    private String second;
    private String splitter;
    private String today;
    private Boolean formattedIntervalEnabled;
    private Boolean soundsAtIntervalsEnabled;
    private Boolean messagesAtIntervalsEnabled;
    private List<String> commands;
    private List<String> soundIntervals;
    private List<String> messageIntervals;
    private List<String> commandsOnEntityClear;
    private Boolean stripConsole;
    private Boolean notifyForUpdates;

    public void cache(ClearLagTimer main) {
        this.cacheMessageFeedback(main);
        this.cacheSoundFeedback(main);
        this.editablePrefix = main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages.prefix");
        this.stripConsole = main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("stripConsole");
        File debugEnabled = new File(main.getDataFolder(), "ndev.debug");
        NDebug.setEnabled(debugEnabled.exists());
        this.notifyForUpdates = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("updates.notifications");
        this.days = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.days");
        this.day = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.day");
        this.hours = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.hours");
        this.hour = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.hour");
        this.minutes = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.minutes");
        this.minute = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.minute");
        this.seconds = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.seconds");
        this.second = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.second");
        this.splitter = main.getNHandler().getConfigurationHandler().getConfigFile().getString("format.splitter");
        this.formattedIntervalEnabled = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.formatted");
        this.soundsAtIntervalsEnabled = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.soundsAtIntervals.enabled");
        this.messagesAtIntervalsEnabled = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.messagesAtIntervals.enabled");
        this.commands = main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.commands");
        this.soundIntervals = main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.soundsAtIntervals.intervals");
        this.messageIntervals = main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.messagesAtIntervals.intervals");
        this.commandsOnEntityClear = main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.commandsOnEntityClear");
    }

    private void cacheMessageFeedback(ClearLagTimer main) {
        if (!this.messageMap.isEmpty()) {
            this.messageMap.clear();
        }
        for (String section : Objects.requireNonNull(main.getNHandler().getConfigurationHandler().getMsgFile().getConfigurationSection("messages")).getKeys(false)) {
            MessageObject message = new MessageObject();
            this.messageMap.put(section, message);
            message = this.messageMap.get(section);
            message.setChatMessageEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".chatMessage.enabled"));
            message.setChatMessageCentered(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".chatMessage.centered"));
            message.setActionbarEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".actionbar.enabled"));
            message.setTitleEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".titles.enabled"));
            message.setChatMessageContent(main.getNHandler().getConfigurationHandler().getMsgFile().getStringList("messages." + section + ".chatMessage.content"));
            message.setActionbarContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".actionbar.content"));
            message.setTitleContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".titles.titleContent"));
            message.setSubtitleContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".titles.subtitleContent"));
        }
    }

    private void cacheSoundFeedback(ClearLagTimer main) {
        if (!this.soundMap.isEmpty()) {
            this.soundMap.clear();
        }
        for (String section : Objects.requireNonNull(main.getNHandler().getConfigurationHandler().getSoundsFile().getConfigurationSection("sounds")).getKeys(false)) {
            SoundObject sound = new SoundObject();
            this.soundMap.put(section, sound);
            sound = this.soundMap.get(section);
            sound.setEnabled(main.getNHandler().getConfigurationHandler().getSoundsFile().getBoolean("sounds." + section + ".enabled"));
            sound.setName(main.getNHandler().getConfigurationHandler().getSoundsFile().getString("sounds." + section + ".sound"));
            sound.setVolume((float)main.getNHandler().getConfigurationHandler().getSoundsFile().getDouble("sounds." + section + ".volume"));
            sound.setPitch((float)main.getNHandler().getConfigurationHandler().getSoundsFile().getDouble("sounds." + section + ".pitch"));
        }
    }

    public HashMap<String, MessageObject> getMessageMap() {
        return this.messageMap;
    }

    public HashMap<String, SoundObject> getSoundMap() {
        return this.soundMap;
    }

    public String getEditablePrefix() {
        return this.editablePrefix;
    }

    public String getDays() {
        return this.days;
    }

    public String getDay() {
        return this.day;
    }

    public String getHours() {
        return this.hours;
    }

    public String getHour() {
        return this.hour;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public String getSecond() {
        return this.second;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public String getToday() {
        return this.today;
    }

    public Boolean getFormattedIntervalEnabled() {
        return this.formattedIntervalEnabled;
    }

    public Boolean getSoundsAtIntervalsEnabled() {
        return this.soundsAtIntervalsEnabled;
    }

    public Boolean getMessagesAtIntervalsEnabled() {
        return this.messagesAtIntervalsEnabled;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getSoundIntervals() {
        return this.soundIntervals;
    }

    public List<String> getMessageIntervals() {
        return this.messageIntervals;
    }

    public List<String> getCommandsOnEntityClear() {
        return this.commandsOnEntityClear;
    }

    public Boolean getStripConsole() {
        return this.stripConsole;
    }

    public Boolean getNotifyForUpdates() {
        return this.notifyForUpdates;
    }
}

