/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.clt.ndev.handlers;

import dev.norska.clt.ClearLagTimer;
import dev.norska.clt.messages.ActionBar;
import dev.norska.clt.ndev.handlers.DefaultFontInfo;
import dev.norska.clt.ndev.handlers.MessageFeedbackPAPI;
import dev.norska.niridiumcolorapi.IridiumColorAPI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MessageFeedbackHandler {
    private HashMap<String, List<String>> consoleMessages = new HashMap();
    private TextComponent version;
    private TextComponent reload;
    private TextComponent wiki_text;
    private TextComponent resourcepages_text;

    public void loadConsoleMessages() {
        this.consoleMessages.put("STARTUP", Collections.singletonList("{0}&r &f{1}, a &afree &fresource by &7Norska &f- Thanks for downloading!"));
        this.consoleMessages.put("STARTUP_FAIL", Collections.singletonList("{0}&r &fRequires ClearLagg in order to function. Shutting down!"));
        this.consoleMessages.put("HOOK_START", Collections.singletonList("{0}&r &fAttempting hooks..."));
        this.consoleMessages.put("HOOK_SUCCESS", Collections.singletonList("{0}&r &fHooked into &a{1}&f!"));
        this.consoleMessages.put("HOOK_FAIL", Collections.singletonList("{0}&r &fFound &c{1}&f but the hook is disabled!"));
        this.consoleMessages.put("HOOK_END_SUCCESS", Collections.singletonList("{0}&r &fSuccessfully performed &a{1} hooks&f!"));
        this.consoleMessages.put("HOOK_END_FAIL", Collections.singletonList("{0}&r &fDid not find any plugins to hook into!"));
        this.consoleMessages.put("ERROR_SOUND", Collections.singletonList("{0}&r &cError (Sound not found or supported in this server version). Recheck entry: &f{1}"));
        this.consoleMessages.put("UPDATE_AVAILABLE", Arrays.asList(" ", " {0}&r &7New update available!", " &7Current version: &c{1} &7with latest being &a{2}&7!", " ", " &eSpigotMC &f-> &7{3}", " &9Polymart &f-> &7{4}", " &bBuiltByBit &f-> &7{5}", " &aModrinth &f-> &7{6}", " "));
        this.consoleMessages.put("UPDATE_UNAVAILABLE", Arrays.asList(" ", " {0}&r &7Running on latest &a{1}&7!", " "));
        this.consoleMessages.put("UPDATE_TIMEOUT", Collections.singletonList("{0}&r &cFailed to check for latest update, request timed out."));
    }

    public void sendConsoleMessage(String type, String ... placeholders) {
        for (String line : this.consoleMessages.get(type)) {
            int placeholderAmount = 0;
            for (String placeholder : placeholders) {
                if (placeholder.isEmpty()) break;
                if (placeholderAmount == 0 && ClearLagTimer.getInstance().getNHandler().getCacheHandler().getStripConsole().booleanValue()) {
                    placeholder = "[ClearLagTimer]";
                }
                line = line.replace("{" + placeholderAmount + "}", placeholder);
                if (ClearLagTimer.getInstance().getNHandler().getCacheHandler().getStripConsole().booleanValue()) {
                    line = line.replace("&r", "");
                }
                ++placeholderAmount;
            }
            Bukkit.getConsoleSender().sendMessage(ClearLagTimer.getInstance().getNHandler().getCacheHandler().getStripConsole() != false ? IridiumColorAPI.stripColorFormatting(line) : IridiumColorAPI.process(line));
        }
    }

    public void loadTextComponents(ClearLagTimer main) {
        this.version = new TextComponent("  \u00a7e\u00a7l\u2022\u00a7r \u00a77/clt version");
        this.version.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clt version"));
        this.version.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7f[/clt version] \u00a77Run command...").create()));
        this.reload = new TextComponent("  \u00a7e\u00a7l\u2022\u00a7r \u00a77/clt reload");
        this.reload.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clt reload"));
        this.reload.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7f[/clt reload] \u00a77Run command...").create()));
        this.wiki_text = new TextComponent("  \u00a76\u00a7l\u2022\u00a7r \u00a77Wiki");
        TextComponent wiki_buttondocs = new TextComponent(" \u00a7f[Docs]");
        wiki_buttondocs.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://norska.dev/docs/free/clt/cmds/"));
        wiki_buttondocs.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a76\u00a7l\u2022 \u00a77Go to \u00a7fDocs\u00a77...").create()));
        TextComponent wiki_buttonjavadocs = new TextComponent(" \u00a7c[JavaDocs]");
        wiki_buttonjavadocs.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://javadocs.norska.dev/clt/"));
        wiki_buttonjavadocs.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a76\u00a7l\u2022 \u00a77Go to \u00a7cJavaDocs\u00a77...").create()));
        this.wiki_text.addExtra((BaseComponent)wiki_buttondocs);
        this.wiki_text.addExtra((BaseComponent)wiki_buttonjavadocs);
        this.resourcepages_text = new TextComponent("  \u00a7a\u00a7l\u2022\u00a7r \u00a77Resource Page");
        TextComponent resourcepages_buttonspigot = new TextComponent(" \u00a7e[SpigotMC]");
        resourcepages_buttonspigot.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, main.getNHandler().getUpdateHandler().getDownloadLinkSpigot()));
        resourcepages_buttonspigot.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7a\u00a7l\u2022 \u00a77Go to \u00a7eSpigotMC \u00a77Resource Page...").create()));
        this.resourcepages_text.addExtra((BaseComponent)resourcepages_buttonspigot);
        TextComponent resourcepages_buttonpolymart = new TextComponent(" \u00a79[Polymart]");
        resourcepages_buttonpolymart.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, main.getNHandler().getUpdateHandler().getDownloadLinkPolymart()));
        resourcepages_buttonpolymart.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7a\u00a7l\u2022 \u00a77Go to \u00a79Polymart \u00a77Resource Page...").create()));
        this.resourcepages_text.addExtra((BaseComponent)resourcepages_buttonpolymart);
        TextComponent resourcepages_buttonbbb = new TextComponent(" \u00a7b[BuiltByBit]");
        resourcepages_buttonbbb.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, main.getNHandler().getUpdateHandler().getDownloadLinkBBB()));
        resourcepages_buttonbbb.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7a\u00a7l\u2022 \u00a77Go to \u00a7bBuiltByBit \u00a77Resource Page...").create()));
        this.resourcepages_text.addExtra((BaseComponent)resourcepages_buttonbbb);
        TextComponent resourcepages_buttonmodrinth = new TextComponent(" \u00a7a[Modrinth]");
        resourcepages_buttonmodrinth.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, main.getNHandler().getUpdateHandler().getDownloadLinkModrinth()));
        resourcepages_buttonmodrinth.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7a\u00a7l\u2022 \u00a77Go to \u00a7aModrinth \u00a77Resource Page...").create()));
        this.resourcepages_text.addExtra((BaseComponent)resourcepages_buttonmodrinth);
    }

    public void sendMenu(ClearLagTimer main, CommandSender cms) {
        if (cms instanceof Player) {
            Player p = (Player)cms;
            cms.sendMessage("\u00a78\u00a7m----------------------------------------+");
            cms.sendMessage(main.getNHandler().getUpdateHandler().getUpdateAvailable() != false ? IridiumColorAPI.process(" " + main.prefix + " &f- &7&oRunning on &c" + main.getNHandler().getUpdateHandler().getCurrentVersion() + " (Outdated) \u274c") : IridiumColorAPI.process(" " + main.prefix + " &f- &7&oRunning on &a" + main.getNHandler().getUpdateHandler().getLatestVersion() + " (Latest) \u2714"));
            cms.sendMessage("");
            cms.sendMessage("  \u00a7f\u00a7nAvailable Commands:\u00a7r \u00a77[] = Required, <> = Optional");
            cms.sendMessage("");
            p.spigot().sendMessage((BaseComponent)this.reload);
            p.spigot().sendMessage((BaseComponent)this.version);
            cms.sendMessage("");
            p.spigot().sendMessage((BaseComponent)this.wiki_text);
            p.spigot().sendMessage((BaseComponent)this.resourcepages_text);
            cms.sendMessage("");
            cms.sendMessage("\u00a78\u00a7m----------------------------------------+");
        } else if (main.getNHandler().getCacheHandler().getStripConsole().booleanValue()) {
            String prefix = "[ClearLagTimer]";
            cms.sendMessage("----------------------------------------+");
            cms.sendMessage(main.getNHandler().getUpdateHandler().getUpdateAvailable() != false ? IridiumColorAPI.process(" " + prefix + " - Running on " + main.getNHandler().getUpdateHandler().getCurrentVersion() + " (Outdated)") : IridiumColorAPI.process(" " + prefix + " - Running on " + main.getNHandler().getUpdateHandler().getLatestVersion() + " (Latest)"));
            cms.sendMessage("");
            cms.sendMessage("  Available Commands: [] = Required, <> = Optional");
            cms.sendMessage("");
            cms.sendMessage("  \u2022 /clt reload");
            cms.sendMessage("  \u2022 /clt version");
            cms.sendMessage("");
            cms.sendMessage("  \u2022 Visit wiki // https://norska.dev/docs/free/clt/cmds/");
            cms.sendMessage("  \u2022 Visit Resource Page // " + main.getNHandler().getUpdateHandler().getDownloadLinkSpigot() + ", " + main.getNHandler().getUpdateHandler().getDownloadLinkPolymart() + ", " + main.getNHandler().getUpdateHandler().getDownloadLinkBBB() + ", " + main.getNHandler().getUpdateHandler().getDownloadLinkModrinth());
            cms.sendMessage("");
            cms.sendMessage("----------------------------------------+");
        } else {
            cms.sendMessage("\u00a78\u00a7m----------------------------------------+");
            cms.sendMessage(main.getNHandler().getUpdateHandler().getUpdateAvailable() != false ? IridiumColorAPI.process(" " + main.prefix + " &f- &7&oRunning on &c" + main.getNHandler().getUpdateHandler().getCurrentVersion() + " (Outdated)") : IridiumColorAPI.process(" " + main.prefix + " &f- &7&oRunning on &a" + main.getNHandler().getUpdateHandler().getLatestVersion() + " (Latest)"));
            cms.sendMessage("");
            cms.sendMessage("  \u00a7f\u00a7nAvailable Commands:\u00a7r \u00a77[] = Required, <> = Optional");
            cms.sendMessage("");
            cms.sendMessage("  \u00a7e\u00a7l\u2022\u00a7r \u00a77/clt reload");
            cms.sendMessage("  \u00a7e\u00a7l\u2022\u00a7r \u00a77/clt version");
            cms.sendMessage("");
            cms.sendMessage("  \u00a79\u00a7l\u2022\u00a7r \u00a77Visit wiki \u00a7f// \u00a79https://norska.dev/docs/free/clt/cmds/");
            cms.sendMessage("  \u00a7d\u00a7l\u2022\u00a7r \u00a77Visit Resource Page \u00a7f// \u00a7e" + main.getNHandler().getUpdateHandler().getDownloadLinkSpigot() + "\u00a7f, \u00a79" + main.getNHandler().getUpdateHandler().getDownloadLinkPolymart() + "\u00a7f, \u00a7b" + main.getNHandler().getUpdateHandler().getDownloadLinkBBB() + "\u00a7f, \u00a7a" + main.getNHandler().getUpdateHandler().getDownloadLinkModrinth());
            cms.sendMessage("");
            cms.sendMessage("\u00a78\u00a7m----------------------------------------+");
        }
    }

    private String sendCenteredMessage(String message) {
        if (message == null || message.equals("")) {
            return "";
        }
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int CENTER_PX = 154;
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = CENTER_PX - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb + message;
    }

    public void sendMessage(ClearLagTimer main, CommandSender cms, String message, String ... placeholders) {
        try {
            Player p;
            int placeholderAmount;
            if (main.getNHandler().getCacheHandler().getMessageMap().get(message).getChatMessageEnabled().booleanValue()) {
                for (String messageLine : main.getNHandler().getCacheHandler().getMessageMap().get(message).getChatMessageContent()) {
                    placeholderAmount = 0;
                    for (String placeholder : placeholders) {
                        if (placeholder.isEmpty()) break;
                        messageLine = messageLine.replace("{" + placeholderAmount + "}", placeholder);
                        ++placeholderAmount;
                    }
                    messageLine = messageLine.replace("{PREFIX}", main.getNHandler().getCacheHandler().getEditablePrefix());
                    if (cms instanceof Player) {
                        messageLine = IridiumColorAPI.process(messageLine);
                        if (main.getNHandler().getHooksHandler().getPlaceholderAPIAvailable().booleanValue()) {
                            messageLine = MessageFeedbackPAPI.replacePlaceholders((Player)cms, messageLine);
                        }
                        if (main.getNHandler().getCacheHandler().getMessageMap().get(message).getChatMessageCentered().booleanValue()) {
                            cms.sendMessage(this.sendCenteredMessage(messageLine));
                            continue;
                        }
                        cms.sendMessage(messageLine);
                        continue;
                    }
                    if (main.getNHandler().getCacheHandler().getStripConsole().booleanValue()) {
                        messageLine = IridiumColorAPI.stripColorFormatting(messageLine);
                        messageLine = messageLine.replace("&r", "");
                    } else {
                        messageLine = IridiumColorAPI.process(messageLine);
                    }
                    cms.sendMessage(messageLine);
                }
            }
            if (main.getNHandler().getCacheHandler().getMessageMap().get(message).getActionbarEnabled().booleanValue() && cms instanceof Player) {
                int duration;
                String messageLine;
                p = (Player)cms;
                messageLine = main.getNHandler().getCacheHandler().getMessageMap().get(message).getActionbarContent();
                placeholderAmount = 0;
                for (String placeholder : placeholders) {
                    if (placeholder.isEmpty()) break;
                    messageLine = messageLine.replace("{" + placeholderAmount + "}", placeholder);
                    ++placeholderAmount;
                }
                messageLine = messageLine.replace("{PREFIX}", main.getNHandler().getCacheHandler().getEditablePrefix());
                messageLine = IridiumColorAPI.process(messageLine);
                if (main.getNHandler().getHooksHandler().getPlaceholderAPIAvailable().booleanValue()) {
                    messageLine = MessageFeedbackPAPI.replacePlaceholders(p, messageLine);
                }
                if ((duration = main.getNHandler().getCacheHandler().getMessageMap().get(message).getActionbarDuration()) > 0) {
                    ActionBar.sendActionBar((Plugin)main, p, IridiumColorAPI.process(messageLine), (long)duration * 20L);
                } else {
                    ActionBar.sendActionBar((Plugin)main, p, IridiumColorAPI.process(messageLine));
                }
            }
            if (main.getNHandler().getCacheHandler().getMessageMap().get(message).getTitleEnabled().booleanValue() && cms instanceof Player) {
                p = (Player)cms;
                String titleLine = main.getNHandler().getCacheHandler().getMessageMap().get(message).getTitleContent();
                placeholderAmount = 0;
                for (String placeholder : placeholders) {
                    if (placeholder.isEmpty()) break;
                    titleLine = titleLine.replace("{" + placeholderAmount + "}", placeholder);
                    ++placeholderAmount;
                }
                titleLine = titleLine.replace("{PREFIX}", main.getNHandler().getCacheHandler().getEditablePrefix());
                titleLine = IridiumColorAPI.process(titleLine);
                if (main.getNHandler().getHooksHandler().getPlaceholderAPIAvailable().booleanValue()) {
                    titleLine = MessageFeedbackPAPI.replacePlaceholders(p, titleLine);
                }
                String subtitleLine = main.getNHandler().getCacheHandler().getMessageMap().get(message).getSubtitleContent();
                int placeholderAmount1 = 0;
                for (String placeholder : placeholders) {
                    if (placeholder.isEmpty()) break;
                    subtitleLine = subtitleLine.replace("{" + placeholderAmount1 + "}", placeholder);
                    ++placeholderAmount1;
                }
                subtitleLine = subtitleLine.replace("{PREFIX}", main.getNHandler().getCacheHandler().getEditablePrefix());
                subtitleLine = IridiumColorAPI.process(subtitleLine);
                if (main.getNHandler().getHooksHandler().getPlaceholderAPIAvailable().booleanValue()) {
                    subtitleLine = MessageFeedbackPAPI.replacePlaceholders(p, subtitleLine);
                }
                p.sendTitle(IridiumColorAPI.process(titleLine), IridiumColorAPI.process(subtitleLine));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap<String, List<String>> getConsoleMessages() {
        return this.consoleMessages;
    }
}

