/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.clt.profiles.mojang;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import dev.norska.clt.profiles.PlayerProfiles;
import dev.norska.clt.profiles.PlayerUUIDs;
import dev.norska.clt.profiles.ProfileLogger;
import dev.norska.clt.profiles.ProfilesCore;
import dev.norska.clt.profiles.exceptions.MojangAPIException;
import dev.norska.clt.profiles.exceptions.UnknownPlayerException;
import dev.norska.clt.profiles.mojang.MinecraftClient;
import dev.norska.clt.profiles.mojang.MojangProfileCache;
import dev.norska.clt.profiles.mojang.PlayerProfile;
import dev.norska.clt.profiles.mojang.ProfileRequestConfiguration;
import dev.norska.clt.profiles.mojang.RateLimiter;
import dev.norska.clt.profiles.objects.ProfileInputType;
import dev.norska.clt.reflection.XReflection;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MojangAPI {
    private static final MojangProfileCache MOJANG_PROFILE_CACHE = !ProfilesCore.NULLABILITY_RECORD_UPDATE ? new MojangProfileCache.GameProfileCache(ProfilesCore.YggdrasilMinecraftSessionService_insecureProfiles) : new MojangProfileCache.ProfileResultCache(ProfilesCore.YggdrasilMinecraftSessionService_insecureProfiles);
    private static final Cache<UUID, Optional<GameProfile>> INSECURE_PROFILES = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build();
    private static final boolean REQUIRE_SECURE_PROFILES = false;
    private static final MinecraftClient USERNAME_TO_UUID = new MinecraftClient("GET", "https://api.mojang.com/users/profiles/minecraft/", new RateLimiter(600, Duration.ofMinutes(10L)));
    private static final MinecraftClient USERNAMES_TO_UUIDS = new MinecraftClient("POST", "https://api.minecraftservices.com/minecraft/profile/lookup/bulk/byname", new RateLimiter(600, Duration.ofMinutes(10L)));
    private static final MinecraftClient UUID_TO_PROFILE = new MinecraftClient("GET", "https://sessionserver.mojang.com/session/minecraft/profile/", new RateLimiter(200, Duration.ofMinutes(1L)));

    @Nullable
    public static UUID requestUsernameToUUID(@NotNull String username) throws IOException {
        JsonElement requestElement = USERNAME_TO_UUID.session(null).append(username).request();
        if (requestElement == null) {
            return null;
        }
        JsonObject userJson = requestElement.getAsJsonObject();
        JsonElement idElement = userJson.get("id");
        if (idElement == null) {
            throw new IllegalArgumentException("No 'id' field for UUID request for '" + username + "': " + userJson);
        }
        return PlayerUUIDs.UUIDFromDashlessString(idElement.getAsString());
    }

    @ApiStatus.Obsolete
    private static GameProfile getCachedProfileByUsername(String username) {
        try {
            @Nullable Object profile = ProfilesCore.GameProfileCache_get$profileByName$.invoke(ProfilesCore.USER_CACHE, username);
            if (profile instanceof Optional) {
                profile = ((Optional)profile).orElse(null);
            }
            GameProfile gameProfile = profile == null ? PlayerProfiles.createGameProfile(PlayerUUIDs.IDENTITY_UUID, username) : PlayerProfiles.sanitizeProfile((GameProfile)profile);
            ProfileLogger.debug("The cached profile for {} -> {}", username, profile);
            return gameProfile;
        }
        catch (Throwable throwable) {
            ProfileLogger.LOGGER.error("Unable to get cached profile by username: {}", (Object)username, (Object)throwable);
            return null;
        }
    }

    public static Optional<GameProfile> getMojangCachedProfileFromUsername(String username) {
        try {
            return MojangAPI.getMojangCachedProfileFromUsername0(username);
        }
        catch (Throwable e) {
            throw XReflection.throwCheckedException(e);
        }
    }

    private static Optional<GameProfile> getMojangCachedProfileFromUsername0(String username) throws Throwable {
        Optional<GameProfile> optional;
        String normalized = username.toLowerCase(Locale.ENGLISH);
        Object userCacheEntry = ProfilesCore.UserCache_profilesByName.get(normalized);
        if (userCacheEntry != null) {
            if (ProfilesCore.UserCacheEntry_setLastAccess != null && ProfilesCore.UserCache_getNextOperation != null) {
                long nextOperation = ProfilesCore.UserCache_getNextOperation.invoke(ProfilesCore.USER_CACHE);
                ProfilesCore.UserCacheEntry_setLastAccess.invoke(userCacheEntry, nextOperation);
            }
            optional = Optional.of(ProfilesCore.UserCacheEntry_getProfile.invoke(userCacheEntry));
        } else {
            UUID realUUID = PlayerUUIDs.getRealUUIDOfPlayer(username);
            if (realUUID == null) {
                return Optional.empty();
            }
            GameProfile profile = PlayerProfiles.createGameProfile(PlayerUUIDs.isOnlineMode() ? realUUID : PlayerUUIDs.getOfflineUUID(username), username);
            optional = Optional.of(profile);
            MojangAPI.cacheProfile(profile);
        }
        return optional;
    }

    public static Map<UUID, String> usernamesToUUIDs(@NotNull Collection<String> usernames, @Nullable ProfileRequestConfiguration config) {
        if (usernames == null || usernames.isEmpty()) {
            throw new IllegalArgumentException("Usernames are null or empty");
        }
        for (String username : usernames) {
            if (username != null && ProfileInputType.USERNAME.pattern.matcher(username).matches()) continue;
            throw new IllegalArgumentException("One of the requested usernames is invalid: " + username + " in " + usernames);
        }
        HashMap<UUID, String> mapped = new HashMap<UUID, String>(usernames.size());
        HashSet<String> finalUsernames = new HashSet<String>(usernames);
        Iterator usernameIter = finalUsernames.iterator();
        while (usernameIter.hasNext()) {
            String username = (String)usernameIter.next();
            UUID cached = PlayerUUIDs.USERNAME_TO_ONLINE.get(username);
            if (cached == null) continue;
            usernameIter.remove();
            mapped.put(cached, username);
        }
        if (finalUsernames.isEmpty()) {
            return mapped;
        }
        boolean onlineMode = PlayerUUIDs.isOnlineMode();
        Iterable partition = Iterables.partition(finalUsernames, (int)10);
        for (List batch : partition) {
            JsonArray response;
            try {
                response = USERNAMES_TO_UUIDS.session(config).body(batch).request().getAsJsonArray();
            }
            catch (IOException ex) {
                throw new MojangAPIException("Failed to request UUIDs for username batch: " + batch, ex);
            }
            for (JsonElement element : response) {
                String prev;
                JsonObject obj = element.getAsJsonObject();
                String name = obj.get("name").getAsString();
                UUID realId = PlayerUUIDs.UUIDFromDashlessString(obj.get("id").getAsString());
                UUID offlineId = PlayerUUIDs.getOfflineUUID(name);
                PlayerUUIDs.USERNAME_TO_ONLINE.put(name, realId);
                PlayerUUIDs.ONLINE_TO_OFFLINE.put(realId, offlineId);
                PlayerUUIDs.OFFLINE_TO_ONLINE.put(offlineId, realId);
                if (!ProfilesCore.UserCache_profilesByName.containsKey(name)) {
                    MojangAPI.cacheProfile(PlayerProfiles.createGameProfile(onlineMode ? realId : offlineId, name));
                }
                if ((prev = mapped.put(realId, name)) == null) continue;
                throw new IllegalArgumentException("Got duplicate usernames for UUID: " + realId + " (" + prev + " -> " + name + ')');
            }
        }
        return mapped;
    }

    @NotNull
    public static GameProfile getCachedProfileByUUID(UUID uuid) {
        uuid = PlayerUUIDs.isOnlineMode() ? uuid : PlayerUUIDs.ONLINE_TO_OFFLINE.getOrDefault(uuid, uuid);
        try {
            @Nullable Object profile = ProfilesCore.GameProfileCache_get$profileByUUID$.invoke(ProfilesCore.USER_CACHE, uuid);
            if (profile instanceof Optional) {
                profile = ((Optional)profile).orElse(null);
            }
            ProfileLogger.debug("The cached profile for {} -> {}", uuid, profile);
            return profile == null ? PlayerProfiles.createNamelessGameProfile(uuid) : PlayerProfiles.sanitizeProfile((GameProfile)profile);
        }
        catch (Throwable throwable) {
            ProfileLogger.LOGGER.error("Unable to get cached profile by UUID: {}", (Object)uuid, (Object)throwable);
            return PlayerProfiles.createNamelessGameProfile(uuid);
        }
    }

    private static void cacheProfile(GameProfile profile) {
        try {
            ProfilesCore.CACHE_PROFILE.invoke(ProfilesCore.USER_CACHE, profile);
            ProfileLogger.debug("Profile is now cached: {}", profile);
        }
        catch (Throwable throwable) {
            ProfileLogger.LOGGER.error("Unable to cache profile {}", (Object)profile);
            throwable.printStackTrace();
        }
    }

    @NotNull
    public static GameProfile getOrFetchProfile(@NotNull GameProfile profile) throws UnknownPlayerException {
        UUID realUUID;
        if (profile.getName().equals("XSeries")) {
            realUUID = profile.getId();
        } else {
            realUUID = PlayerUUIDs.getRealUUIDOfPlayer(profile.getName(), profile.getId());
            if (realUUID == null) {
                throw new UnknownPlayerException((Object)profile.getName(), "Player with the given properties not found: " + profile);
            }
        }
        GameProfile cached = MojangAPI.handleCache(profile, realUUID);
        if (cached != null) {
            return cached;
        }
        JsonElement request = MojangAPI.requestProfile(profile, realUUID);
        JsonObject profileData = request.getAsJsonObject();
        ArrayList<String> profileActions = new ArrayList<String>();
        GameProfile fetchedProfile = MojangAPI.createGameProfile(profileData, profileActions);
        fetchedProfile = PlayerProfiles.sanitizeProfile(fetchedProfile);
        MojangAPI.cacheProfile(fetchedProfile);
        INSECURE_PROFILES.put((Object)realUUID, Optional.of(fetchedProfile));
        MOJANG_PROFILE_CACHE.cache(new PlayerProfile(realUUID, profile, fetchedProfile, profileActions));
        return fetchedProfile;
    }

    @Nullable
    private static GameProfile handleCache(@NotNull GameProfile profile, UUID realUUID) {
        Optional cached = (Optional)INSECURE_PROFILES.getIfPresent((Object)realUUID);
        if (cached != null) {
            ProfileLogger.debug("Found cached profile from UUID ({}): {} -> {}", realUUID, profile, cached);
            if (cached.isPresent()) {
                return (GameProfile)cached.get();
            }
            throw new UnknownPlayerException(realUUID, "Player with the given properties not found: " + profile);
        }
        Optional<GameProfile> mojangCache = MOJANG_PROFILE_CACHE.get(realUUID, profile);
        if (mojangCache != null) {
            INSECURE_PROFILES.put((Object)realUUID, mojangCache);
            if (mojangCache.isPresent()) {
                return mojangCache.get();
            }
            throw new UnknownPlayerException(realUUID, "Player with the given properties not found: " + profile);
        }
        return null;
    }

    @NotNull
    private static JsonElement requestProfile(@NotNull GameProfile profile, UUID realUUID) {
        JsonElement request;
        try {
            request = UUID_TO_PROFILE.session(null).append(PlayerUUIDs.toUndashedUUID(realUUID) + "?unsigned=" + true).request();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to request profile: " + profile + " with real UUID: " + realUUID, e);
        }
        if (request == null) {
            INSECURE_PROFILES.put((Object)realUUID, Optional.empty());
            MOJANG_PROFILE_CACHE.cache(new PlayerProfile(realUUID, profile, null, null));
            throw new UnknownPlayerException(realUUID, "Player with the given properties not found: " + profile);
        }
        return request;
    }

    @NotNull
    private static GameProfile createGameProfile(JsonObject profileData, List<String> profileActions) {
        JsonElement profileActionsElement;
        UUID id = PlayerUUIDs.UUIDFromDashlessString(profileData.get("id").getAsString());
        String name = profileData.get("name").getAsString();
        GameProfile fetchedProfile = PlayerProfiles.createGameProfile(id, name);
        JsonElement propertiesEle = profileData.get("properties");
        if (propertiesEle != null) {
            JsonArray props = propertiesEle.getAsJsonArray();
            PropertyMap properties = fetchedProfile.getProperties();
            for (JsonElement prop : props) {
                JsonObject obj = prop.getAsJsonObject();
                String propName = obj.get("name").getAsString();
                String propValue = obj.get("value").getAsString();
                JsonElement sig = obj.get("signature");
                Property property = sig != null ? new Property(propName, propValue, sig.getAsString()) : new Property(propName, propValue);
                properties.put((Object)propName, (Object)property);
            }
        }
        if ((profileActionsElement = profileData.get("profileActions")) != null) {
            for (JsonElement action : profileActionsElement.getAsJsonArray()) {
                profileActions.add(action.getAsString());
            }
        }
        return fetchedProfile;
    }
}

