package com.ruslan.growsseth

object Constants {
    const val TRADES_DATA_FOLDER = "growsseth_researcher_trades"
    const val RESEARCHER_DIALOGUE_DATA_FOLDER = "growsseth_researcher_dialogue"
    const val RESEARCHER_DIALOGUE_CONVERTED_FOLDER = "growsseth_converted_researcher_dialogue"
    const val RESEARCHER_DIALOGUE_EXTRACTED_FOLDER = "growsseth_extracted_researcher_dialogue"
    const val PRESET_PLACES_FOLDER = "growsseth_places"
    const val PRESET_PLACES_EXTRACTED_FOLDER = "growsseth_extracted_places"

    const val EVENT_NAMESPACE = "event"

    const val TEMPLATE_FOLDER = "growsseth_templates"
    const val TEMPLATE_STRUCT_FOLDER = "structures"
    const val TEMPLATE_DIARY_FOLDER = "researcher_diary"

    const val DEFAULT_LANGUAGE = "en_us"

    const val LANG_DIALOGUE_PREFIX = "dialogue"
    const val LANG_PLACES_PREFIX = "places"

    const val ATTACHMENT_SERVER_PLAYER_DATA = "server-player-data"
    const val DATA_PLAYER_MET_RESEARCHER = "metResearcher"
    const val TAG_RESEARCHER_DONKEY = "researcher_donkey"

    const val ITEM_TAG_MAP_FAILED_LOCATE = "GrowssethFailedLocate"

    const val MIN_HEIGHT = -64
    const val MAX_HEIGHT = 310

    const val DAY_TICKS_DURATION = 24000L

    // For data files stored in world folder
    const val DATA_FOLDER = "growsseth"
    const val RESEARCHER_DATA = "$DATA_FOLDER/researcher_data"
    const val GLOBAL_TRADES_DATA = "$DATA_FOLDER/global_trades"
    const val PROGRESS_TRADES_DATA = "$DATA_FOLDER/progress_trades"
    const val DATASYNC_MEMORY_DATA = "$DATA_FOLDER/datasync_memory"
    const val EVENTS_DATA = "$DATA_FOLDER/events"
}
