package com.ruslan.growsseth.client.resource

import com.ruslan.growsseth.RuinsOfGrowsseth
import com.ruslan.growsseth.resource.MusicCommon
import com.ruslan.growsseth.utils.DecryptUtil
import com.ruslan.growsseth.utils.resLoc
import net.minecraft.resources.FileToIdConverter
import net.minecraft.resources.ResourceLocation
import net.minecraft.server.packs.resources.ResourceManager
import net.minecraft.server.packs.resources.ResourceManagerReloadListener
import java.io.IOException
import java.io.InputStream
import javax.crypto.AEADBadTagException
import javax.crypto.SecretKey

/**
 * Used to load encrypted music files that would normally be monetized, at the
 * artist's wishes, to avoid having the high quality files plainly in the jar. We are aware that
 * this is not usual for a Minecraft mod, but it should not affect performance in a relevant way.
 * (If it does, please report!)
 * Yes, it's possible to reverse this with some effort, but please support the official (free)
 * release on spotify by Il Coro di Mammonk rather than doing that!
 */
object EncryptedMusicResources {
    @JvmField
    val LISTER = FileToIdConverter("soundsx", ".oggx")

    private const val KEY_PATH = "sounds.key"
    private var key: SecretKey? = null

    @JvmStatic
    fun checkEncryptedSoundStream(resourceLocation: ResourceLocation, inputStream: InputStream): InputStream {
        return if (resourceLocation.path.startsWith("soundsx")) {
            if (!MusicCommon.hasMusicKey) {
                throw IOException("Couldn't load encrypted music as no key loaded in mod build!")
            }
            // inputStream // debug with plain files
            DecryptUtil.decryptInputStream(key ?: throw IllegalStateException("Didn't load decryption key yet!"), inputStream)
        } else {
            inputStream
        }
    }

    // self-mixinned in fabric module to use fabric's resource reload listener interfaces
    class KeyListener : ResourceManagerReloadListener {
        override fun onResourceManagerReload(resourceManager: ResourceManager) {
            if (MusicCommon.hasMusicKey) {
                try {
                    key = DecryptUtil.readKey(resourceManager.open(resLoc(KEY_PATH)), MusicCommon.musicPw)
                    RuinsOfGrowsseth.LOGGER.info("Read music key!")
                } catch (_: AEADBadTagException) {
                    RuinsOfGrowsseth.LOGGER.error("Music key could not be used to decrypt sounds.key file!")
                }
            } else {
                RuinsOfGrowsseth.LOGGER.warn("Cannot read music key, not setup during build correctly!")
            }
        }
    }
}