package com.ruslan.growsseth.config;

import com.ruslan.growsseth.structure.GrowssethStructures;
import com.teamresourceful.resourcefulconfig.api.annotations.*;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

import static com.ruslan.growsseth.config.GrowssethConfig.T_PREF;

@Category("worldpreset")
public class WorldPresetConfig {
    public static final Map<class_5321<class_3195>, PosPreset> PRESET_ORIGINAL = Map.of(
        GrowssethStructures.CydoniaVersion.RESEARCHER_TENT, new PosPreset(1374, 74, 162, class_2470.field_11464),
        GrowssethStructures.CydoniaVersion.CAVE_CAMP,       new PosPreset(934, 38, 340, class_2470.field_11467),
        GrowssethStructures.CydoniaVersion.MARKER,          new PosPreset(940, 68, 347, class_2470.field_11467),
        GrowssethStructures.CydoniaVersion.ENCHANT_TOWER,   new PosPreset(-1276, 123, 743, class_2470.field_11464),
        GrowssethStructures.CydoniaVersion.GOLEM_HOUSE,     new PosPreset(171, 144, 861, class_2470.field_11465),
        GrowssethStructures.CydoniaVersion.BEEKEEPER_HOUSE, new PosPreset(3086, 72, 989, class_2470.field_11465),
        GrowssethStructures.CydoniaVersion.NOTEBLOCK_LAB,   new PosPreset(2260, 69, -1674, class_2470.field_11467),
        GrowssethStructures.CydoniaVersion.CONDUIT_CHURCH,  new PosPreset(-1553, 39, 2527, class_2470.field_11464)
    );
    public static final Map<class_5321<class_3195>, PosPreset> PRESET_UPDATED = Map.of(
        GrowssethStructures.CydoniaVersion.RESEARCHER_TENT, new PosPreset(1374, 74, 162, class_2470.field_11464),
        GrowssethStructures.CydoniaVersion.CAVE_CAMP,       new PosPreset(934, 38, 340, class_2470.field_11467),
        GrowssethStructures.CydoniaVersion.MARKER,          new PosPreset(940, 68, 347, class_2470.field_11467),
        GrowssethStructures.CydoniaVersion.ENCHANT_TOWER,   new PosPreset(-1276, 123, 743, class_2470.field_11467), // tower changes
        GrowssethStructures.CydoniaVersion.GOLEM_HOUSE,     new PosPreset(171, 144, 861, class_2470.field_11465),
        GrowssethStructures.CydoniaVersion.BEEKEEPER_HOUSE, new PosPreset(3086, 72, 989, class_2470.field_11465),
        GrowssethStructures.CydoniaVersion.NOTEBLOCK_LAB,   new PosPreset(2260, 69, -1674, class_2470.field_11467),
        GrowssethStructures.CydoniaVersion.CONDUIT_CHURCH,  new PosPreset(-1553, 39, 2527, class_2470.field_11464)
    );

    @ConfigButton(text = "Apply updated preset")
    public static final Runnable useUpdatedPreset = () -> usePreset(PRESET_UPDATED);

    @ConfigButton(text = "Apply original preset")
    public static final Runnable useOriginalPreset = () -> usePreset(PRESET_ORIGINAL);

    private static void usePreset(Map<class_5321<class_3195>, PosPreset> preset) {
        researcherTent.assign(new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.RESEARCHER_TENT, preset));
        caveCamp.assign(new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.CAVE_CAMP, preset));
        caveCampMarker.assign(new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.MARKER, preset));
        enchantTower.assign(new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.ENCHANT_TOWER, preset));
        golemHouse.assign(new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.GOLEM_HOUSE, preset));
        beekeeperHouse.assign(new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.BEEKEEPER_HOUSE, preset));
        noteblockLab.assign(new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.NOTEBLOCK_LAB, preset));
        conduitChurch.assign(new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.CONDUIT_CHURCH, preset));
    }

    @ConfigEntry(id = "disableTrialChambers", translation = T_PREF + "disableTrialChambers.name")
    @Comment(value = "Prevents the Trial Chambers structure from spawning in the Growsseth world preset (since the original series was on 1.20.1 and they didn't exist yet)", translation = T_PREF + "disableTrialChambers.comment")
    public static boolean disableTrialChambers = true;

    @ConfigEntry(id = "researcherTent", translation = T_PREF + "researcherTent.name")
    public static final StructureInWorldConfig researcherTent = new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.RESEARCHER_TENT);

    @ConfigEntry(id = "caveCamp", translation = T_PREF + "caveCamp.name")
    public static final StructureInWorldConfig caveCamp = new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.CAVE_CAMP);

    @ConfigEntry(id = "caveCampMarker", translation = T_PREF + "caveCampMarker.name")
    public static final StructureInWorldConfig caveCampMarker = new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.MARKER);

    @ConfigEntry(id = "enchantTower", translation = T_PREF + "enchantTower.name")
    public static final StructureInWorldConfig enchantTower = new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.ENCHANT_TOWER);

    @ConfigEntry(id = "golemHouse", translation = T_PREF + "golemHouse.name")
    public static final StructureInWorldConfig golemHouse = new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.GOLEM_HOUSE);

    @ConfigEntry(id = "beekeeperHouse", translation = T_PREF + "beekeeperHouse.name")
    public static final StructureInWorldConfig beekeeperHouse = new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.BEEKEEPER_HOUSE);

    @ConfigEntry(id = "noteblockLab", translation = T_PREF + "noteblockLab.name")
    public static final StructureInWorldConfig noteblockLab = new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.NOTEBLOCK_LAB);

    @ConfigEntry(id = "conduitChurch", translation = T_PREF + "conduitChurch.name")
    public static final StructureInWorldConfig conduitChurch = new StructureInWorldConfig(GrowssethStructures.CydoniaVersion.CONDUIT_CHURCH);

    public static List<StructureInWorldConfig> getAll() {
        return List.of(
            researcherTent,
            caveCamp,
            caveCampMarker,
            enchantTower,
            golemHouse,
            beekeeperHouse,
            noteblockLab,
            conduitChurch
        );
    }

    @ConfigObject
    public static class StructureInWorldConfig {
        @ConfigEntry(id = "structureId", translation = T_PREF + "structId.name")
        public String structureId;
        @ConfigEntry(id = "enabled", translation = T_PREF + "enabled.name")
        public boolean enabled;
        @ConfigEntry(id = "x", translation = T_PREF + "structX.name")
        public int x;
        @ConfigEntry(id = "y", translation = T_PREF + "structY.name")
        public int y;
        @ConfigEntry(id = "z", translation = T_PREF + "structZ.name")
        public int z;
        @ConfigEntry(id = "rotation", translation = T_PREF + "rotation.name")
        public class_2470 rotation;

        public class_2960 structureId() {
            return class_2960.method_60654(structureId);
        }
        public class_5321<class_3195> structureKey() {
            return class_5321.method_29179(class_7924.field_41246, structureId());
        }

        public void assign(StructureInWorldConfig other) {
            this.structureId = other.structureId;
            this.enabled = other.enabled;
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
            this.rotation = other.rotation;
        }

        public StructureInWorldConfig(class_5321<class_3195> structureId, boolean enabled, int x, int y, int z, class_2470 rotation) {
            this.structureId = structureId.method_29177().toString();
            this.enabled = enabled;
            this.x = x;
            this.y = y;
            this.z = z;
            this.rotation = rotation;
        }

        public StructureInWorldConfig(class_5321<class_3195> structureId, boolean enabled, PosPreset posRot) {
            this(structureId, enabled, posRot.x, posRot.y, posRot.z, posRot.rotation);
        }

        public StructureInWorldConfig(class_5321<class_3195> structureId, boolean enabled, Map<class_5321<class_3195>, PosPreset> preset) {
            this(structureId, enabled, preset.get(structureId));
        }

        public StructureInWorldConfig(class_5321<class_3195> structureId, Map<class_5321<class_3195>, PosPreset> preset) {
            // default to enabled
            this(structureId, true, preset.get(structureId));
        }

        public StructureInWorldConfig(class_5321<class_3195> structureId) {
            // default to updated preset and enabled
            this(structureId, PRESET_UPDATED);
        }
    }

    public record PosPreset(int x, int y, int z, class_2470 rotation) { }
}
