package com.ruslan.growsseth.mixin.debug;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.DebugConfig;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2385;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_2897;
import net.minecraft.class_5321;
import net.minecraft.class_5485;
import net.minecraft.class_6872;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import net.minecraft.class_7225;
import net.minecraft.class_7655;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import net.minecraft.core.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class StructureDebugMixins {
    @Mixin(class_2794.class)
    public static class ChunkGeneratorMixin {
        @ModifyVariable(
            method = "tryGenerateStructure",
            at = @At("STORE")
        )
        private Predicate<class_6880<class_1959>> onSetBiomePredicate(Predicate<class_6880<class_1959>> value, @Local(argsOnly = true) class_7059.class_7060 structureSelectionEntry) {
            if (!DebugConfig.structuresDebugMode || !structureSelectionEntry.comp_512().method_40230().map(k -> k.method_29177().method_12836().equals(RuinsOfGrowsseth.MOD_ID)).orElse(false)) {
                return value;
            } else {
                return (h) -> true;
            }
        }
    }

    // This should cover all codec.parse calls
    @Mixin(class_7655.class)
    public static class RegistryDataLoaderMixin {
        @WrapOperation(
            method = "loadElementFromResource",
            at = @At(value = "INVOKE", target = "Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")
        )
        private static <E> DataResult<E> loadRegistryContents(
                Decoder<E> instance, DynamicOps<class_2520> ops, Object jsonElement, Operation<DataResult<E>> original,
                @Local(argsOnly = true) class_2385<E> registry
        ) {
            return growsseth$registryWrapper(instance, ops, jsonElement, original, registry);
        }

        @WrapOperation(
            method = "loadContentsFromNetwork",
            at = @At(value = "INVOKE", target = "Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")
        )
        private static <E> DataResult<E> loadRegistryContentsFromNetwork(
                Decoder<E> instance, DynamicOps<class_2520> ops, Object jsonElement, Operation<DataResult<E>> original,
                @Local(argsOnly = true) class_2385<E> registry
        ) {
            return growsseth$registryWrapper(instance, ops, jsonElement, original, registry);
        }


        // NOTE: equivalent code to this crashed when upgrading to 1.21 (or 1.21.1?) as it switched
        // from StructureSet to Optional<StructureSet> in vanilla code, failing the cast
        // Check here if it fails again!
        @Unique
        private static <E> DataResult<E> growsseth$registryWrapper(Decoder<E> instance, DynamicOps<class_2520> ops, Object jsonElement, Operation<DataResult<E>> original, class_2385<E> registry) {
            var result = original.call(instance, ops, jsonElement);
            var key = registry.method_30517();
            if (DebugConfig.structuresDebugMode && key.equals(class_7924.field_41248) && jsonElement.toString().contains("growsseth")) {
                result = growsseth$alterStructureSetWeight(key, result);
            }
            return result;
        }

        @Unique
        private static <E> DataResult<E> growsseth$alterStructureSetWeight(class_5321<?> key, DataResult<?> dataResult) {
            RuinsOfGrowsseth.LOGGER.info("(debug mode) Network | Increasing spawn frequency for {}", key);
            Optional<?> structureSetOpt = growsseth$assertCast(dataResult.getOrThrow(), Optional.class);
            class_7059 structureSet = growsseth$assertCast(structureSetOpt.orElseThrow(), class_7059.class);
            var placement = structureSet.comp_511();
            placement.field_37778 = 1;
            if (placement instanceof class_6872 randomSpread) {
                randomSpread.field_37772 = randomSpread.field_37772 / 4;
                randomSpread.field_37773 = randomSpread.field_37773 / 4;
            }
            //noinspection unchecked
            return (DataResult<E>) DataResult.success(Optional.of(structureSet));
        }

        @Unique
        private static <E> E growsseth$assertCast(Object value, Class<E> clazz) {
            if (!(value.getClass().isAssignableFrom(clazz))) {
                throw new IllegalArgumentException("Expected " + value + " to be an instance of " + clazz.getCanonicalName());
            }
            //noinspection unchecked
            return (E) value;
        }
    }

    @Mixin(class_2897.class)
    public static abstract class FlatLevelSourceMixin extends class_2794 {
        protected FlatLevelSourceMixin(class_1966 biomeSource) {
            super(biomeSource);
        }

        protected FlatLevelSourceMixin(class_1966 biomeSource, Function<class_6880<class_1959>, class_5485> generationSettingsGetter) {
            super(biomeSource, generationSettingsGetter);
        }

        @Inject(
            method = "createState(Lnet/minecraft/core/HolderLookup;Lnet/minecraft/world/level/levelgen/RandomState;J)Lnet/minecraft/world/level/chunk/ChunkGeneratorStructureState;",
            at = @At("HEAD"),
            cancellable = true
        )
        private void overrideStructuresInDebug(class_7225<class_7059> structureSetLookup, class_7138 randomState, long seed, CallbackInfoReturnable<class_7869> cir) {
            if (DebugConfig.structuresDebugMode) {
                RuinsOfGrowsseth.LOGGER.info("(debug mode) Replaced flat worldgen structure selection");
                cir.setReturnValue(super.method_46696(structureSetLookup, randomState, seed));
            }
        }
    }

    @Mixin(class_7869.class)
    public static class ChunkGeneratorStructureStateMixin {
        @Inject(
            method = "hasBiomesForStructureSet",
            at = @At("HEAD"),
            cancellable = true
        )
        private static void hasBiomesForStructureSet(class_7059 structureSet, class_1966 biomeSource, CallbackInfoReturnable<Boolean> cir) {
            if (DebugConfig.structuresDebugMode) {
                cir.setReturnValue(true);
            }
        }
    }
}
