package com.ruslan.growsseth.mixin.entity;

import com.ruslan.growsseth.effect.GrowssethEffects;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin {
    @Unique
    class_1309 entity = (class_1309)(Object)this;

    @ModifyVariable(method = "hurt", at = @At(value = "HEAD"), ordinal = 0, argsOnly = true)
    private float applyGrowssethEffects(float amount, class_1282 source) {
        // The effects are applied before any other computation, they do not affect void and /kill damage but affect starve damage
        if (!source.method_48789(class_8103.field_42242)) {
            if (entity.method_6059(GrowssethEffects.INSTANCE.getSERENITY()) &&        // attacks from creative players bypass the serenity effect
                    !(source.method_5529() instanceof class_1657 && ((class_1657) source.method_5529()).method_7337()))
                return 1f;
            else if (entity.method_6059(GrowssethEffects.INSTANCE.getFIGHTING_SPIRIT()))
                return amount - (amount * 0.35f);
        }
        return amount;
    }
}
