package com.ruslan.growsseth.mixin.entity.mob;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.utils.MixinHelpers;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1338;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5138;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1548.class)
public abstract class CreeperMixin extends class_1588 {

    protected CreeperMixin(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(at = @At("HEAD"), method = "registerGoals")
    private void avoidResearchers(CallbackInfo ci) {
        class_1548 th1s = (class_1548)(Object)this;
        field_6201.method_6277(3, new class_1338<>(th1s, Researcher.class, Researcher.WALK_LIMIT_DISTANCE + 6, 1.0, 1.2));
    }

    @WrapOperation(
            method = "explodeCreeper",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;explode(Lnet/minecraft/world/entity/Entity;DDDFLnet/minecraft/world/level/Level$ExplosionInteraction;)Lnet/minecraft/world/level/Explosion;")
    )
    private class_1927 preventExplosionInTent(class_1937 instance, @Nullable class_1297 source, double x, double y, double z, float radius, class_1937.class_7867 explosionInteraction, Operation<class_1927> original) {
        // already server side from vanilla code
        class_3218 serverLevel = (class_3218) instance;
        class_5138 structureManager = serverLevel.method_27056();
        if (structureManager.method_28388(source.method_23312(), MixinHelpers.researcherTent).method_16657()) {
            return serverLevel.method_8437(source, x, y, z, 0, class_1937.class_7867.field_40890);    // 0 radius to avoid damaging the donkey or leash
        } else {
            return original.call(instance, source, x, y, z, radius, explosionInteraction);
        }
    }
}
