package com.ruslan.growsseth.mixin.item;

import com.ruslan.growsseth.item.GrowssethJukeboxSongs;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_9792;
import net.minecraft.class_9793;

@Mixin(class_9792.class)
public class DiscCreditsMixin {
    // Inside addToTooltip
    @SuppressWarnings("UnresolvedMixinReference")
    @Inject(
        method = { "lambda$addToTooltip$1", "method_60748" },
        at = @At(value = "INVOKE", shift = At.Shift.AFTER, target = "Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V")
    )
    private static void addExtraCredits(Consumer<class_2561> tooltipAdder, class_6880<class_9793> holder, CallbackInfo ci) {
        if (holder.method_40230().map(GrowssethJukeboxSongs.credits::containsKey).orElse(false)) {
            var credits = GrowssethJukeboxSongs.credits.get(holder.method_40230().orElseThrow());
            Optional.ofNullable(credits.getTooltip()).ifPresent(x -> x.forEach(tooltipAdder));
        }
    }
}
