/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ruslan.growsseth.entity.researcher.Researcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0005\u001a\u00020\u0006H\u0016J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/ruslan/growsseth/client/model/ResearcherModel;", "Lnet/minecraft/client/model/HierarchicalModel;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "Lnet/minecraft/client/model/ArmedModel;", "Lnet/minecraft/client/model/HeadedModel;", "root", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "head", "hat", "getHat", "()Lnet/minecraft/client/model/geom/ModelPart;", "arms", "leftLeg", "rightLeg", "rightArm", "leftArm", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "getArm", "arm", "Lnet/minecraft/world/entity/HumanoidArm;", "getHead", "translateToHand", "side", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ruins-of-growsseth"})
public final class ResearcherModel
extends HierarchicalModel<Researcher>
implements ArmedModel,
HeadedModel {
    @NotNull
    private final ModelPart root;
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart hat;
    @NotNull
    private final ModelPart arms;
    @NotNull
    private final ModelPart leftLeg;
    @NotNull
    private final ModelPart rightLeg;
    @NotNull
    private final ModelPart rightArm;
    @NotNull
    private final ModelPart leftArm;

    public ResearcherModel(@NotNull ModelPart root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        ModelPart modelPart = this.root.getChild("head");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"getChild(...)");
        this.head = modelPart;
        ModelPart modelPart2 = this.head.getChild("hat");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"getChild(...)");
        this.hat = modelPart2;
        this.hat.visible = false;
        this.arms = this.root.getChild("arms");
        this.leftLeg = this.root.getChild("left_leg");
        this.rightLeg = this.root.getChild("right_leg");
        this.leftArm = this.root.getChild("left_arm");
        this.rightArm = this.root.getChild("right_arm");
    }

    @NotNull
    public final ModelPart getHat() {
        return this.hat;
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@NotNull Researcher entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean bl;
        boolean isUnhappy;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        boolean bl2 = isUnhappy = entity.getUnhappyCounter() > 0 && !entity.isAggressive();
        if (isUnhappy) {
            this.head.zRot = 0.3f * Mth.sin((float)(0.45f * ageInTicks));
            this.head.xRot = 0.4f;
        } else {
            this.head.zRot = 0.0f;
        }
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.yRot = 0.0f;
        AbstractIllager.IllagerArmPose illagerArmPose = entity.getArmPose();
        this.arms.visible = bl = illagerArmPose == AbstractIllager.IllagerArmPose.CROSSED;
        this.leftArm.visible = !bl;
        boolean bl3 = this.rightArm.visible = !bl;
        if (illagerArmPose == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (entity.isAggressive()) {
                if (entity.getMainHandItem().isEmpty()) {
                    AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.attackTime, (float)ageInTicks);
                } else if (!entity.isUsingItem()) {
                    AnimationUtils.swingWeaponDown((ModelPart)this.rightArm, (ModelPart)this.leftArm, (Mob)((Mob)entity), (float)this.attackTime, (float)ageInTicks);
                } else {
                    AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.attackTime, (float)ageInTicks);
                }
            } else if (entity.isUsingItem()) {
                AnimationUtils.swingWeaponDown((ModelPart)this.leftArm, (ModelPart)this.rightArm, (Mob)((Mob)entity), (float)this.attackTime, (float)ageInTicks);
            }
        }
    }

    private final ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    @NotNull
    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHand(@NotNull HumanoidArm side, @NotNull PoseStack poseStack) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        this.getArm(side).translateAndRotate(poseStack);
    }
}

