/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ruslan.growsseth.client.model.ResearcherModel;
import com.ruslan.growsseth.client.render.ResearcherProfessionLayer;
import com.ruslan.growsseth.entity.researcher.Researcher;
import com.ruslan.growsseth.item.AbstractResearcherDaggerItem;
import com.ruslan.growsseth.utils.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 \u00122\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/ruslan/growsseth/client/render/ResearcherRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Lcom/ruslan/growsseth/entity/researcher/Researcher;", "Lcom/ruslan/growsseth/client/model/ResearcherModel;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "entity", "scale", "", "livingEntity", "matrixStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "partialTickTime", "", "Companion", "ruins-of-growsseth"})
public final class ResearcherRenderer
extends MobRenderer<Researcher, ResearcherModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation RESEARCHER_SKIN = UtilsKt.resLoc("textures/entity/illager/researcher.png");
    @NotNull
    private static final ResourceLocation RESEARCHER_SKIN_ANGRY = UtilsKt.resLoc("textures/entity/illager/researcher_angry.png");
    @NotNull
    private static final ResourceLocation RESEARCHER_TYPE_SKIN = UtilsKt.resLoc("textures/entity/villager/type/researcher.png");
    @NotNull
    private static final ResourceLocation RESEARCHER_CLOTHES = UtilsKt.resLoc("textures/entity/villager/profession/researcher.png");
    @NotNull
    private static final ResourceLocation RESEARCHER_CLOTHES_UNSHEATED_DAGGER = UtilsKt.resLoc("textures/entity/villager/profession/researcher_unsheated.png");

    public ResearcherRenderer(final @NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModelPart modelPart = context.bakeLayer(ModelLayers.VINDICATOR);
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        super(context, (EntityModel)new ResearcherModel(modelPart), 0.5f);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer(new ResearcherProfessionLayer((RenderLayerParent)this, RESEARCHER_TYPE_SKIN, RESEARCHER_CLOTHES, RESEARCHER_CLOTHES_UNSHEATED_DAGGER));
        ItemInHandRenderer itemInHandRenderer = context.getItemInHandRenderer();
        this.addLayer((RenderLayer)new ItemInHandLayer<Researcher, ResearcherModel>(this, itemInHandRenderer){

            protected void renderArmWithItem(LivingEntity researcher, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
                Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
                Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
                Intrinsics.checkNotNullParameter((Object)displayContext, (String)"displayContext");
                Intrinsics.checkNotNullParameter((Object)arm, (String)"arm");
                Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                Researcher cfr_ignored_0 = (Researcher)researcher;
                if (itemStack.getItem() instanceof AbstractResearcherDaggerItem && ((Researcher)researcher).isAggressive()) {
                    poseStack.pushPose();
                    EntityModel entityModel = this.getParentModel();
                    Intrinsics.checkNotNull((Object)entityModel, (String)"null cannot be cast to non-null type net.minecraft.client.model.ArmedModel");
                    ((ArmedModel)entityModel).translateToHand(arm, poseStack);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.translate(-0.1, 0.0, 0.0);
                    boolean bl = arm == HumanoidArm.LEFT;
                    poseStack.translate((float)(bl ? -1 : 1) / 16.0f, 0.125f, -0.625f);
                    context.getItemInHandRenderer().renderItem(researcher, itemStack, displayContext, bl, poseStack, buffer, packedLight);
                    poseStack.popPose();
                } else if (((Researcher)researcher).isAggressive() || itemStack.getItem() instanceof PotionItem || itemStack.get(DataComponents.FOOD) != null || itemStack.is(Items.ENDER_PEARL)) {
                    super.renderArmWithItem(researcher, itemStack, displayContext, arm, poseStack, buffer, packedLight);
                }
            }
        });
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Researcher entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.isAggressive() ? RESEARCHER_SKIN_ANGRY : RESEARCHER_SKIN;
    }

    protected void scale(@NotNull Researcher livingEntity, @NotNull PoseStack matrixStack, float partialTickTime) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        matrixStack.scale(0.9375f, 0.9375f, 0.9375f);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ruslan/growsseth/client/render/ResearcherRenderer$Companion;", "", "<init>", "()V", "RESEARCHER_SKIN", "Lnet/minecraft/resources/ResourceLocation;", "RESEARCHER_SKIN_ANGRY", "RESEARCHER_TYPE_SKIN", "RESEARCHER_CLOTHES", "RESEARCHER_CLOTHES_UNSHEATED_DAGGER", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

