/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.ruslan.growsseth.config.ClientConfig;
import com.ruslan.growsseth.maps.CustomStructureMapKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MapDecorationTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J`\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0013H\u0002J^\u0010#\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020+R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0015\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/ruslan/growsseth/client/render/RuinsMapRenderer;", "", "<init>", "()V", "mapDecorations", "Lnet/minecraft/client/resources/MapDecorationTextureManager;", "kotlin.jvm.PlatformType", "getMapDecorations", "()Lnet/minecraft/client/resources/MapDecorationTextureManager;", "mapDecorations$delegate", "Lkotlin/Lazy;", "renderRuinsMapIcon", "", "Lnet/minecraft/world/item/ItemStack;", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "x", "", "y", "OFFSET_X", "OFFSET_Y", "renderCornerTexture", "texture", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "blitSprite", "sprite", "textureWidth", "textureHeight", "uPosition", "vPosition", "blitOffset", "uWidth", "vHeight", "innerBlit", "atlasLocation", "Lnet/minecraft/resources/ResourceLocation;", "x1", "x2", "y1", "y2", "minU", "", "maxU", "minV", "maxV", "ruins-of-growsseth"})
public final class RuinsMapRenderer {
    @NotNull
    public static final RuinsMapRenderer INSTANCE = new RuinsMapRenderer();
    @NotNull
    private static final Lazy mapDecorations$delegate = LazyKt.lazy(RuinsMapRenderer::mapDecorations_delegate$lambda$0);
    private static final int OFFSET_X = 4;
    private static final int OFFSET_Y = 4;

    private RuinsMapRenderer() {
    }

    private final MapDecorationTextureManager getMapDecorations() {
        Lazy lazy = mapDecorations$delegate;
        return (MapDecorationTextureManager)lazy.getValue();
    }

    @JvmStatic
    public static final void renderRuinsMapIcon(@NotNull ItemStack $this$renderRuinsMapIcon, @NotNull PoseStack pose, @NotNull MultiBufferSource.BufferSource bufferSource, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)$this$renderRuinsMapIcon, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        if (!ClientConfig.mapCornerIcons) {
            return;
        }
        Holder<MapDecorationType> holder = CustomStructureMapKt.getMapTargetIcon($this$renderRuinsMapIcon);
        if (holder == null || (holder = holder.getType()) == null) {
            return;
        }
        Holder<MapDecorationType> mapIcon = holder;
        TextureAtlasSprite texture = INSTANCE.getMapDecorations().getSprite(((MapDecorationType)mapIcon.value()).assetId());
        Intrinsics.checkNotNull((Object)texture);
        INSTANCE.renderCornerTexture(texture, bufferSource, pose, x, y);
    }

    private final void renderCornerTexture(TextureAtlasSprite texture, MultiBufferSource.BufferSource bufferSource, PoseStack pose, int x, int y) {
        pose.pushPose();
        pose.translate((double)x + (double)4, (double)y + (double)4, 200.0);
        pose.scale(1.0f, 1.0f, 3.0f);
        this.blitSprite(pose, texture, 8, 8, 0, 0, -4, -4, 0, 8, 8);
        pose.popPose();
    }

    private final void blitSprite(PoseStack pose, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int uPosition, int vPosition, int x, int y, int blitOffset, int uWidth, int vHeight) {
        if (uWidth != 0 && vHeight != 0) {
            ResourceLocation resourceLocation = sprite.atlasLocation();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"atlasLocation(...)");
            this.innerBlit(pose, resourceLocation, x, x + uWidth, y, y + vHeight, blitOffset, sprite.getU((float)uPosition / (float)textureWidth), sprite.getU((float)(uPosition + uWidth) / (float)textureWidth), sprite.getV((float)vPosition / (float)textureHeight), sprite.getV((float)(vPosition + vHeight) / (float)textureHeight));
        }
    }

    public final void innerBlit(@NotNull PoseStack pose, @NotNull ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)atlasLocation, (String)"atlasLocation");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(RuinsMapRenderer::innerBlit$lambda$1);
        Matrix4f matrix4f = pose.last().pose();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
        Matrix4f matrix4f2 = matrix4f;
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f2, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV);
        bufferBuilder.addVertex(matrix4f2, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix4f2, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix4f2, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    private static final MapDecorationTextureManager mapDecorations_delegate$lambda$0() {
        return Minecraft.getInstance().getMapDecorationTextures();
    }

    private static final ShaderInstance innerBlit$lambda$1() {
        return GameRenderer.getPositionTexShader();
    }
}

