/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.client.resource;

import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.resource.MusicCommon;
import com.ruslan.growsseth.utils.DecryptUtil;
import com.ruslan.growsseth.utils.UtilsKt;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.AEADBadTagException;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ruslan/growsseth/client/resource/EncryptedMusicResources;", "", "<init>", "()V", "LISTER", "Lnet/minecraft/resources/FileToIdConverter;", "KEY_PATH", "", "key", "Ljavax/crypto/SecretKey;", "checkEncryptedSoundStream", "Ljava/io/InputStream;", "resourceLocation", "Lnet/minecraft/resources/ResourceLocation;", "inputStream", "KeyListener", "ruins-of-growsseth"})
public final class EncryptedMusicResources {
    @NotNull
    public static final EncryptedMusicResources INSTANCE = new EncryptedMusicResources();
    @JvmField
    @NotNull
    public static final FileToIdConverter LISTER = new FileToIdConverter("soundsx", ".oggx");
    @NotNull
    private static final String KEY_PATH = "sounds.key";
    @Nullable
    private static SecretKey key;

    private EncryptedMusicResources() {
    }

    @JvmStatic
    @NotNull
    public static final InputStream checkEncryptedSoundStream(@NotNull ResourceLocation resourceLocation, @NotNull InputStream inputStream) {
        InputStream inputStream2;
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        String string = resourceLocation.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.startsWith$default((String)string, (String)"soundsx", (boolean)false, (int)2, null)) {
            if (!MusicCommon.INSTANCE.getHasMusicKey()) {
                throw new IOException("Couldn't load encrypted music as no key loaded in mod build!");
            }
            SecretKey secretKey = key;
            if (secretKey == null) {
                throw new IllegalStateException("Didn't load decryption key yet!");
            }
            inputStream2 = DecryptUtil.INSTANCE.decryptInputStream(secretKey, inputStream);
        } else {
            inputStream2 = inputStream;
        }
        return inputStream2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/ruslan/growsseth/client/resource/EncryptedMusicResources$KeyListener;", "Lnet/minecraft/server/packs/resources/ResourceManagerReloadListener;", "<init>", "()V", "onResourceManagerReload", "", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "ruins-of-growsseth"})
    public static final class KeyListener
    implements ResourceManagerReloadListener {
        public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
            Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
            if (MusicCommon.INSTANCE.getHasMusicKey()) {
                try {
                    InputStream inputStream = resourceManager.open(UtilsKt.resLoc(EncryptedMusicResources.KEY_PATH));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
                    key = DecryptUtil.INSTANCE.readKey(inputStream, MusicCommon.INSTANCE.getMusicPw$ruins_of_growsseth());
                    RuinsOfGrowsseth.LOGGER.info("Read music key!", new Object[0]);
                }
                catch (AEADBadTagException aEADBadTagException) {
                    RuinsOfGrowsseth.LOGGER.error("Music key could not be used to decrypt sounds.key file!", new Object[0]);
                }
            } else {
                RuinsOfGrowsseth.LOGGER.warn("Cannot read music key, not setup during build correctly!", new Object[0]);
            }
        }
    }
}

