/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.client.worldpreset;

import com.ruslan.growsseth.client.gui.locationtitles.LocationTitlesController;
import com.ruslan.growsseth.config.ClientConfig;
import com.ruslan.growsseth.utils.UtilsKt;
import com.ruslan.growsseth.worldgen.worldpreset.LocationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/ruslan/growsseth/client/worldpreset/GrowssethWorldPresetClient;", "", "<init>", "()V", "LOCATION_DATA", "", "Lcom/ruslan/growsseth/worldgen/worldpreset/LocationData;", "getLOCATION_DATA", "()Ljava/util/List;", "MIN_DELAY_TICKS", "", "MIN_DISTANCE_UPDATE", "locationData", "", "lastShowTime", "lastPos", "Lnet/minecraft/core/BlockPos;", "initLocationData", "", "locationTitlesController", "Lcom/ruslan/growsseth/client/gui/locationtitles/LocationTitlesController;", "Callbacks", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nGrowssethWorldPresetClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethWorldPresetClient.kt\ncom/ruslan/growsseth/client/worldpreset/GrowssethWorldPresetClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n774#2:54\n865#2,2:55\n*S KotlinDebug\n*F\n+ 1 GrowssethWorldPresetClient.kt\ncom/ruslan/growsseth/client/worldpreset/GrowssethWorldPresetClient\n*L\n25#1:54\n25#1:55,2\n*E\n"})
public final class GrowssethWorldPresetClient {
    @NotNull
    public static final GrowssethWorldPresetClient INSTANCE = new GrowssethWorldPresetClient();
    private static final int MIN_DELAY_TICKS = com.filloax.fxlib.api.UtilsKt.secondsToTicks((float)1.0f);
    private static final int MIN_DISTANCE_UPDATE = 6;
    @NotNull
    private static final List<LocationData> locationData = new ArrayList();
    private static int lastShowTime = -1;
    @NotNull
    private static BlockPos lastPos = new BlockPos(0, 0, 0);

    private GrowssethWorldPresetClient() {
    }

    @NotNull
    public final List<LocationData> getLOCATION_DATA() {
        return locationData;
    }

    /*
     * WARNING - void declaration
     */
    public final void initLocationData(@NotNull List<LocationData> locationData) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(locationData, (String)"locationData");
        GrowssethWorldPresetClient.locationData.clear();
        Iterable iterable = locationData;
        List<LocationData> list = GrowssethWorldPresetClient.locationData;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LocationData it = (LocationData)element$iv$iv;
            boolean bl = false;
            if (!(!it.getHidden() && UtilsKt.notNull(it.getBoundingBox()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
    }

    private final LocationTitlesController locationTitlesController() {
        return LocationTitlesController.Companion.get();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/ruslan/growsseth/client/worldpreset/GrowssethWorldPresetClient$Callbacks;", "", "<init>", "()V", "onClientTick", "", "client", "Lnet/minecraft/client/Minecraft;", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nGrowssethWorldPresetClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethWorldPresetClient.kt\ncom/ruslan/growsseth/client/worldpreset/GrowssethWorldPresetClient$Callbacks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n774#2:54\n865#2:55\n866#2:57\n2341#2,14:58\n1#3:56\n*S KotlinDebug\n*F\n+ 1 GrowssethWorldPresetClient.kt\ncom/ruslan/growsseth/client/worldpreset/GrowssethWorldPresetClient$Callbacks\n*L\n43#1:54\n43#1:55\n43#1:57\n44#1:58,14\n*E\n"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        /*
         * WARNING - void declaration
         */
        public final void onClientTick(@NotNull Minecraft client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            if (!ClientConfig.enableLocationTitles) {
                return;
            }
            LocalPlayer localPlayer = client.player;
            if (localPlayer == null) {
                return;
            }
            LocalPlayer player = localPlayer;
            if (lastShowTime > player.tickCount) {
                lastShowTime = 0;
            }
            if (player.tickCount - lastShowTime < MIN_DELAY_TICKS) {
                return;
            }
            BlockPos pos = player.blockPosition();
            if (pos.distManhattan((Vec3i)lastPos) > 6) {
                Object v2;
                void $this$minByOrNull$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Vec3 fPos = player.position();
                Iterable iterable = INSTANCE.getLOCATION_DATA();
                boolean $i$f$filter = false;
                void var8_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    LocationData it = (LocationData)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getBoundingBox() != null) {
                        AABB vol;
                        boolean bl3 = false;
                        bl = vol.contains(fPos) && !vol.contains(com.filloax.fxlib.api.UtilsKt.vec3((Vec3i)((Vec3i)lastPos)));
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = minElem$iv;
                    } else {
                        LocationData it = (LocationData)minElem$iv;
                        boolean bl = false;
                        double minValue$iv = it.getCenterPos().distanceToSqr(fPos);
                        do {
                            Object e$iv = iterator$iv.next();
                            LocationData it2 = (LocationData)e$iv;
                            $i$a$-minByOrNull-GrowssethWorldPresetClient$Callbacks$onClientTick$closestInside$2 = false;
                            double v$iv = it2.getCenterPos().distanceToSqr(fPos);
                            if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = minElem$iv;
                    }
                }
                LocationData closestInside = v2;
                if (closestInside != null) {
                    INSTANCE.locationTitlesController().showLocationTitle(closestInside.getName().getText());
                    lastShowTime = player.tickCount;
                }
                lastPos = pos;
            }
        }
    }
}

