/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.ruslan.growsseth.config.GrowssethConfigHandler;
import com.ruslan.growsseth.config.WebConfig;
import com.ruslan.growsseth.entity.researcher.trades.GlobalResearcherTradesProvider;
import com.ruslan.growsseth.http.DataRemoteSync;
import com.ruslan.growsseth.http.GrowssethApi;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lcom/ruslan/growsseth/commands/GamemasterCommand;", "", "<init>", "()V", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "registryAccess", "Lnet/minecraft/commands/CommandBuildContext;", "environment", "Lnet/minecraft/commands/Commands$CommandSelection;", "printHelp", "", "source", "printStatus", "formatTime", "", "time", "Ljava/time/LocalDateTime;", "reload", "setEnabled", "value", "", "setUrl", "url", "isValidUrl", "urlString", "restartAndReloadTrades", "server", "Lnet/minecraft/server/MinecraftServer;", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nGamemasterCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GamemasterCommand.kt\ncom/ruslan/growsseth/commands/GamemasterCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class GamemasterCommand {
    @NotNull
    public static final GamemasterCommand INSTANCE = new GamemasterCommand();

    private GamemasterCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull CommandBuildContext registryAccess, @NotNull Commands.CommandSelection environment) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gmaster").requires(GamemasterCommand::register$lambda$0)).then(Commands.literal((String)"help").executes(GamemasterCommand::register$lambda$1))).then(Commands.literal((String)"status").executes(GamemasterCommand::register$lambda$2))).then(Commands.literal((String)"reload").executes(GamemasterCommand::register$lambda$3))).then(Commands.literal((String)"enable").executes(GamemasterCommand::register$lambda$4))).then(Commands.literal((String)"disable").executes(GamemasterCommand::register$lambda$5))).then(Commands.literal((String)"url").then(Commands.argument((String)"webUrl", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(GamemasterCommand::register$lambda$6))));
    }

    private final int printHelp(CommandSourceStack source) {
        source.sendSuccess(GamemasterCommand::printHelp$lambda$8, false);
        return 1;
    }

    private final int printStatus(CommandSourceStack source) {
        if (!WebConfig.webDataSync) {
            source.sendSystemMessage((Component)Component.translatable((String)"growsseth.commands.gmaster.status_off"));
            return 0;
        }
        String suffix = DataRemoteSync.INSTANCE.getLastSyncSuccessful() ? "ok" : "ko";
        Object[] objectArray = new Object[]{WebConfig.dataSyncUrl, DataRemoteSync.INSTANCE.getLastSyncSuccessful()};
        source.sendSystemMessage((Component)Component.translatable((String)("growsseth.commands.gmaster.status_on_" + suffix), (Object[])objectArray));
        objectArray = new Object[]{this.formatTime(DataRemoteSync.INSTANCE.getLastSuccessfulUpdateTime()), this.formatTime(DataRemoteSync.INSTANCE.getLastUpdateTime())};
        source.sendSystemMessage((Component)Component.translatable((String)"growsseth.commands.gmaster.status_time", (Object[])objectArray));
        return 1;
    }

    private final String formatTime(LocalDateTime time) {
        Object object;
        block3: {
            block2: {
                object = time;
                if (object == null) break block2;
                LocalDateTime it = object;
                boolean bl = false;
                String string = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(it);
                object = string;
                if (string != null) break block3;
            }
            object = "-";
        }
        return object;
    }

    private final int reload(CommandSourceStack source) {
        if (WebConfig.webDataSync) {
            source.sendSystemMessage((Component)Component.translatable((String)"growsseth.commands.gmaster.reload_start"));
            try {
                GrowssethApi.Companion.getCurrent().reload().thenAccept(arg_0 -> GamemasterCommand.reload$lambda$12(arg_0 -> GamemasterCommand.reload$lambda$11(source, arg_0), arg_0));
            }
            catch (Throwable e) {
                e.printStackTrace();
                source.sendFailure((Component)Component.translatable((String)"growsseth.commands.gmaster.reload_failure"));
                return 0;
            }
            return 1;
        }
        source.sendFailure((Component)Component.translatable((String)"growsseth.commands.gmaster.disabled"));
        return 0;
    }

    private final int setEnabled(CommandSourceStack source, boolean value) {
        String suffix;
        String string = suffix = value ? "on" : "off";
        if (WebConfig.webDataSync != value) {
            WebConfig.webDataSync = value;
            GrowssethConfigHandler.INSTANCE.saveConfig();
            MinecraftServer minecraftServer = source.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            this.restartAndReloadTrades(minecraftServer);
            source.sendSuccess(() -> GamemasterCommand.setEnabled$lambda$13(suffix), true);
        } else {
            source.sendSuccess(() -> GamemasterCommand.setEnabled$lambda$14(suffix), true);
        }
        return 1;
    }

    private final int setUrl(CommandSourceStack source, String url) {
        if (!this.isValidUrl(url)) {
            Object[] objectArray = new Object[]{url};
            source.sendFailure((Component)Component.translatable((String)"growsseth.commands.gmaster.url_not_valid", (Object[])objectArray));
            return 0;
        }
        WebConfig.dataSyncUrl = url;
        GrowssethConfigHandler.INSTANCE.saveConfig();
        MinecraftServer minecraftServer = source.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        this.restartAndReloadTrades(minecraftServer);
        source.sendSuccess(() -> GamemasterCommand.setUrl$lambda$15(url), true);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidUrl(String urlString) {
        try {
            URL url = new URI(urlString).toURL();
            if (!Intrinsics.areEqual((Object)url.getProtocol(), (Object)"http")) {
                if (!Intrinsics.areEqual((Object)url.getProtocol(), (Object)"https")) return false;
            }
            String string = url.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            if (((CharSequence)string).length() <= 0) return false;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private final void restartAndReloadTrades(MinecraftServer server) {
        GlobalResearcherTradesProvider.Companion.reloadAll(server);
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$1(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.printHelp((CommandSourceStack)object);
    }

    private static final int register$lambda$2(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.printStatus((CommandSourceStack)object);
    }

    private static final int register$lambda$3(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.reload((CommandSourceStack)object);
    }

    private static final int register$lambda$4(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.setEnabled((CommandSourceStack)object, true);
    }

    private static final int register$lambda$5(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.setEnabled((CommandSourceStack)object, false);
    }

    private static final int register$lambda$6(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        String string = StringArgumentType.getString((CommandContext)ctx, (String)"webUrl");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.setUrl(commandSourceStack, string);
    }

    private static final Style printHelp$lambda$8$lambda$7(Style style) {
        return style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/filloax/ruins-of-growsseth/wiki/EN-%E2%80%90-Gamemaster-Mode"));
    }

    private static final Component printHelp$lambda$8() {
        MutableComponent wikiLink = Component.literal((String)"https://github.com/filloax/ruins-of-growsseth/wiki/EN---Gamemaster-Mode").withStyle(ChatFormatting.UNDERLINE).withStyle(GamemasterCommand::printHelp$lambda$8$lambda$7);
        return (Component)Component.translatable((String)"growsseth.commands.gmaster.help").append((Component)wikiLink);
    }

    private static final Component reload$lambda$11$lambda$10() {
        return (Component)Component.translatable((String)"growsseth.commands.gmaster.reload_success");
    }

    private static final Unit reload$lambda$11(CommandSourceStack $source, Boolean it) {
        if (it.booleanValue()) {
            $source.sendSuccess(GamemasterCommand::reload$lambda$11$lambda$10, true);
        } else {
            $source.sendFailure((Component)Component.translatable((String)"growsseth.commands.gmaster.reload_failure"));
        }
        return Unit.INSTANCE;
    }

    private static final void reload$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Component setEnabled$lambda$13(String $suffix) {
        Object[] objectArray = new Object[]{WebConfig.dataSyncUrl};
        return (Component)Component.translatable((String)("growsseth.commands.gmaster.set_" + $suffix), (Object[])objectArray).withStyle(ChatFormatting.YELLOW);
    }

    private static final Component setEnabled$lambda$14(String $suffix) {
        Object[] objectArray = new Object[]{WebConfig.dataSyncUrl};
        return (Component)Component.translatable((String)("growsseth.commands.gmaster.already_" + $suffix), (Object[])objectArray);
    }

    private static final Component setUrl$lambda$15(String $url) {
        Object[] objectArray = new Object[]{$url};
        return (Component)Component.translatable((String)"growsseth.commands.gmaster.url_set", (Object[])objectArray).withStyle(ChatFormatting.YELLOW);
    }
}

