/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.structure.locate.LocateResult;
import com.ruslan.growsseth.structure.locate.LocateTask;
import com.ruslan.growsseth.structure.locate.StoppableAsyncLocator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013JC\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJN\u0010\u001f\u001a\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\f\u0018\u00010 j\u0004\u0018\u0001`#2\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002JK\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/ruslan/growsseth/commands/GrowssethLocateCommand;", "", "<init>", "()V", "locationTasks", "", "Ljava/util/UUID;", "", "Lcom/ruslan/growsseth/structure/locate/LocateTask;", "ERROR_STRUCTURE_INVALID", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "registryAccess", "Lnet/minecraft/commands/CommandBuildContext;", "environment", "Lnet/minecraft/commands/Commands$CommandSelection;", "locateStructure", "", "source", "structure", "Lnet/minecraft/commands/arguments/ResourceOrTagKeyArgument$Result;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "timeout", "logProgress", "", "chatProgress", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/commands/arguments/ResourceOrTagKeyArgument$Result;Ljava/lang/Integer;ZZ)I", "getSignalProgress", "Lkotlin/Function3;", "Lcom/ruslan/growsseth/structure/locate/LocateTask$Phase;", "", "Lcom/ruslan/growsseth/structure/locate/SignalProgressFun;", "locateJigsawStructure", "jigsawId", "Lnet/minecraft/resources/ResourceLocation;", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/commands/arguments/ResourceOrTagKeyArgument$Result;Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Integer;ZZ)I", "stopLocating", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nGrowssethLocateCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethLocateCommand.kt\ncom/ruslan/growsseth/commands/GrowssethLocateCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1#2:193\n1863#3,2:194\n*S KotlinDebug\n*F\n+ 1 GrowssethLocateCommand.kt\ncom/ruslan/growsseth/commands/GrowssethLocateCommand\n*L\n185#1:194,2\n*E\n"})
public final class GrowssethLocateCommand {
    @NotNull
    public static final GrowssethLocateCommand INSTANCE = new GrowssethLocateCommand();
    @NotNull
    private static final Map<UUID, List<LocateTask>> locationTasks = new LinkedHashMap();
    @NotNull
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(GrowssethLocateCommand::ERROR_STRUCTURE_INVALID$lambda$0);

    private GrowssethLocateCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull CommandBuildContext registryAccess, @NotNull Commands.CommandSelection environment) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"glocate").requires(GrowssethLocateCommand::register$lambda$1)).then(Commands.literal((String)"structure").then(((RequiredArgumentBuilder)Commands.argument((String)"structure", (ArgumentType)((ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE))).executes(GrowssethLocateCommand::register$lambda$2)).then(((RequiredArgumentBuilder)Commands.argument((String)"timeout", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(GrowssethLocateCommand::register$lambda$3)).then(Commands.argument((String)"logProgress", (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(GrowssethLocateCommand::register$lambda$4)))))).then(Commands.literal((String)"jigsawStructure").then(Commands.argument((String)"structure", (ArgumentType)((ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE))).then(((RequiredArgumentBuilder)Commands.argument((String)"jigsawId", (ArgumentType)((ArgumentType)ResourceLocationArgument.id())).executes(GrowssethLocateCommand::register$lambda$5)).then(((RequiredArgumentBuilder)Commands.argument((String)"timeout", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(GrowssethLocateCommand::register$lambda$6)).then(Commands.argument((String)"logProgress", (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(GrowssethLocateCommand::register$lambda$7))))))).then(Commands.literal((String)"stop").executes(GrowssethLocateCommand::register$lambda$8)));
    }

    private final int locateStructure(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> structure, Integer timeout, boolean logProgress, boolean chatProgress) throws CommandSyntaxException {
        block1: {
            LocateTask locateTask;
            Registry registry = source.getLevel().registryAccess().registryOrThrow(Registries.STRUCTURE);
            Optional optional = LocateCommand.getHolders(structure, (Registry)registry);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getHolders(...)");
            HolderSet.ListBacked listBacked = (HolderSet.ListBacked)OptionalsKt.getOrNull((Optional)optional);
            if (listBacked == null) {
                throw ERROR_STRUCTURE_INVALID.create((Object)structure.asPrintable());
            }
            HolderSet.ListBacked holderSet = listBacked;
            BlockPos blockPos = BlockPos.containing((Position)((Position)source.getPosition()));
            ServerLevel serverLevel = source.getLevel();
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
            Intrinsics.checkNotNull((Object)serverLevel);
            HolderSet holderSet2 = (HolderSet)holderSet;
            Intrinsics.checkNotNull((Object)blockPos);
            LocateTask task = locateTask = StoppableAsyncLocator.locate$default(StoppableAsyncLocator.INSTANCE, serverLevel, holderSet2, blockPos, 100, false, null, null, timeout, this.getSignalProgress(source, structure, logProgress, chatProgress), 96, null);
            boolean bl = false;
            task.thenOnServerThread((Function1<? super LocateResult, Unit>)((Function1)arg_0 -> GrowssethLocateCommand.locateStructure$lambda$11$lambda$9(source, structure, blockPos, stopwatch, arg_0))).onExceptionOnServerThread((Function1<? super Throwable, Unit>)((Function1)arg_0 -> GrowssethLocateCommand.locateStructure$lambda$11$lambda$10(source, arg_0)));
            LocateTask task2 = locateTask;
            Entity entity = source.getEntity();
            if (entity == null) break block1;
            Entity it = entity;
            boolean bl2 = false;
            locationTasks.computeIfAbsent(it.getUUID(), arg_0 -> GrowssethLocateCommand.locateStructure$lambda$14$lambda$13(GrowssethLocateCommand::locateStructure$lambda$14$lambda$12, arg_0)).add(task2);
        }
        return 1;
    }

    static /* synthetic */ int locateStructure$default(GrowssethLocateCommand growssethLocateCommand, CommandSourceStack commandSourceStack, ResourceOrTagKeyArgument.Result result, Integer n, boolean bl, boolean bl2, int n2, Object object) throws CommandSyntaxException {
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        return growssethLocateCommand.locateStructure(commandSourceStack, (ResourceOrTagKeyArgument.Result<Structure>)result, n, bl, bl2);
    }

    private final Function3<LocateTask, LocateTask.Phase, Float, Unit> getSignalProgress(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> structure, boolean logProgress, boolean chatProgress) {
        Function3 chatProgressFun = (arg_0, arg_1, arg_2) -> GrowssethLocateCommand.getSignalProgress$lambda$15(source, arg_0, arg_1, arg_2);
        String str = structure.asPrintable();
        Function3 logProgressFun = (arg_0, arg_1, arg_2) -> GrowssethLocateCommand.getSignalProgress$lambda$16(str, arg_0, arg_1, arg_2);
        if (chatProgress && logProgress) {
            return (arg_0, arg_1, arg_2) -> GrowssethLocateCommand.getSignalProgress$lambda$17(chatProgressFun, logProgressFun, arg_0, arg_1, arg_2);
        }
        if (chatProgress) {
            return chatProgressFun;
        }
        if (logProgress) {
            return logProgressFun;
        }
        return null;
    }

    private final int locateJigsawStructure(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> structure, ResourceLocation jigsawId, Integer timeout, boolean logProgress, boolean chatProgress) throws CommandSyntaxException {
        block1: {
            LocateTask locateTask;
            Registry registry = source.getLevel().registryAccess().registryOrThrow(Registries.STRUCTURE);
            Optional optional = LocateCommand.getHolders(structure, (Registry)registry);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getHolders(...)");
            HolderSet.ListBacked listBacked = (HolderSet.ListBacked)OptionalsKt.getOrNull((Optional)optional);
            if (listBacked == null) {
                throw ERROR_STRUCTURE_INVALID.create((Object)structure.asPrintable());
            }
            HolderSet.ListBacked holderSet = listBacked;
            BlockPos blockPos = BlockPos.containing((Position)((Position)source.getPosition()));
            ServerLevel serverLevel = source.getLevel();
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
            Intrinsics.checkNotNull((Object)serverLevel);
            HolderSet holderSet2 = (HolderSet)holderSet;
            Collection collection = SetsKt.setOf((Object)jigsawId);
            Intrinsics.checkNotNull((Object)blockPos);
            LocateTask task = locateTask = StoppableAsyncLocator.INSTANCE.locateJigsaw(serverLevel, (HolderSet<Structure>)holderSet2, collection, blockPos, 100, false, timeout, this.getSignalProgress(source, structure, logProgress, chatProgress));
            boolean bl = false;
            task.thenOnServerThread((Function1<? super LocateResult, Unit>)((Function1)arg_0 -> GrowssethLocateCommand.locateJigsawStructure$lambda$20$lambda$18(source, structure, blockPos, stopwatch, arg_0))).onExceptionOnServerThread((Function1<? super Throwable, Unit>)((Function1)arg_0 -> GrowssethLocateCommand.locateJigsawStructure$lambda$20$lambda$19(source, arg_0)));
            LocateTask task2 = locateTask;
            Entity entity = source.getEntity();
            if (entity == null) break block1;
            Entity it = entity;
            boolean bl2 = false;
            locationTasks.computeIfAbsent(it.getUUID(), arg_0 -> GrowssethLocateCommand.locateJigsawStructure$lambda$23$lambda$22(GrowssethLocateCommand::locateJigsawStructure$lambda$23$lambda$21, arg_0)).add(task2);
        }
        return 1;
    }

    static /* synthetic */ int locateJigsawStructure$default(GrowssethLocateCommand growssethLocateCommand, CommandSourceStack commandSourceStack, ResourceOrTagKeyArgument.Result result, ResourceLocation resourceLocation, Integer n, boolean bl, boolean bl2, int n2, Object object) throws CommandSyntaxException {
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        return growssethLocateCommand.locateJigsawStructure(commandSourceStack, (ResourceOrTagKeyArgument.Result<Structure>)result, resourceLocation, n, bl, bl2);
    }

    private final int stopLocating(CommandSourceStack source) {
        List<LocateTask> list;
        block6: {
            block5: {
                if (source.getEntity() == null) {
                    source.sendFailure((Component)Component.translatable((String)"growsseth.commands.glocate.stop.nonEntity"));
                    return 0;
                }
                list = locationTasks.get(source.getEntityOrException().getUUID());
                if (list == null) break block5;
                List<LocateTask> it = list;
                boolean bl = false;
                List<LocateTask> list2 = it.size() > 0 ? it : null;
                list = list2;
                if (list2 != null) break block6;
            }
            GrowssethLocateCommand $this$stopLocating_u24lambda_u2425 = this;
            boolean bl = false;
            source.sendFailure((Component)Component.translatable((String)"growsseth.commands.glocate.stop.fail"));
            return 0;
        }
        List<LocateTask> tasks = list;
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocateTask it = (LocateTask)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getLevel().getServer(), (Object)source.getServer())) continue;
            it.cancel("command");
        }
        tasks.clear();
        source.sendSuccess(GrowssethLocateCommand::stopLocating$lambda$27, true);
        return 0;
    }

    private static final Message ERROR_STRUCTURE_INVALID$lambda$0(Object it) {
        Object[] objectArray = new Object[]{it};
        return (Message)Component.translatableEscape((String)"commands.locate.structure.invalid", (Object[])objectArray);
    }

    private static final boolean register$lambda$1(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$2(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ResourceOrTagKeyArgument.Result result = ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"getResourceOrTagKey(...)");
        return GrowssethLocateCommand.locateStructure$default(INSTANCE, commandSourceStack, result, null, false, false, 28, null);
    }

    private static final int register$lambda$3(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ResourceOrTagKeyArgument.Result result = ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"getResourceOrTagKey(...)");
        return GrowssethLocateCommand.locateStructure$default(INSTANCE, commandSourceStack, result, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"timeout"), false, false, 24, null);
    }

    private static final int register$lambda$4(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ResourceOrTagKeyArgument.Result result = ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"getResourceOrTagKey(...)");
        return INSTANCE.locateStructure(commandSourceStack, (ResourceOrTagKeyArgument.Result<Structure>)result, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"timeout"), BoolArgumentType.getBool((CommandContext)ctx, (String)"logProgress"), BoolArgumentType.getBool((CommandContext)ctx, (String)"logProgress"));
    }

    private static final int register$lambda$5(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ResourceOrTagKeyArgument.Result result = ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"getResourceOrTagKey(...)");
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)ctx, (String)"jigsawId");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        return GrowssethLocateCommand.locateJigsawStructure$default(INSTANCE, commandSourceStack, result, resourceLocation, null, false, false, 56, null);
    }

    private static final int register$lambda$6(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ResourceOrTagKeyArgument.Result result = ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"getResourceOrTagKey(...)");
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)ctx, (String)"jigsawId");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        return GrowssethLocateCommand.locateJigsawStructure$default(INSTANCE, commandSourceStack, result, resourceLocation, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"timeout"), false, false, 48, null);
    }

    private static final int register$lambda$7(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ResourceOrTagKeyArgument.Result result = ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"getResourceOrTagKey(...)");
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)ctx, (String)"jigsawId");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        return INSTANCE.locateJigsawStructure(commandSourceStack, (ResourceOrTagKeyArgument.Result<Structure>)result, resourceLocation, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"timeout"), BoolArgumentType.getBool((CommandContext)ctx, (String)"logProgress"), BoolArgumentType.getBool((CommandContext)ctx, (String)"logProgress"));
    }

    private static final int register$lambda$8(CommandContext ctx) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.stopLocating((CommandSourceStack)object);
    }

    private static final Unit locateStructure$lambda$11$lambda$9(CommandSourceStack $source, ResourceOrTagKeyArgument.Result $structure, BlockPos $blockPos, Stopwatch $stopwatch, LocateResult it) {
        if (it == null) {
            Object[] objectArray = new Object[]{$structure.asPrintable()};
            $source.sendFailure((Component)Component.translatable((String)"commands.locate.structure.invalid", (Object[])objectArray));
        } else {
            LocateCommand.showLocateResult((CommandSourceStack)$source, (ResourceOrTagKeyArgument.Result)$structure, (BlockPos)$blockPos, (Pair)new Pair((Object)it.getPos(), it.getStructure()), (String)"commands.locate.structure.success", (boolean)false, (Duration)$stopwatch.elapsed());
        }
        return Unit.INSTANCE;
    }

    private static final Unit locateStructure$lambda$11$lambda$10(CommandSourceStack $source, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = "Error in async search: %s";
        Object[] objectArray = new Object[]{it.getMessage()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        $source.sendFailure((Component)Component.literal((String)string2));
        return Unit.INSTANCE;
    }

    private static final List locateStructure$lambda$14$lambda$12(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List locateStructure$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Unit getSignalProgress$lambda$15(CommandSourceStack $source, LocateTask task, LocateTask.Phase phase, float pct) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        String string = "Async Locate progress: %s %.2f%%, time %.2fs";
        Object[] objectArray = new Object[]{phase, Float.valueOf(pct * (float)100), (double)task.timeElapsedMs() / 1000.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        $source.sendSystemMessage((Component)Component.literal((String)string2));
        return Unit.INSTANCE;
    }

    private static final Unit getSignalProgress$lambda$16(String $str, LocateTask task, LocateTask.Phase phase, float pct) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        String string = "%s %.2f%%, time %.2fs";
        Object[] objectArray = new Object[]{phase, Float.valueOf(pct * (float)100), (double)task.timeElapsedMs() / 1000.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        RuinsOfGrowsseth.LOGGER.info("Async Locate " + $str + " progress: " + string2, new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit getSignalProgress$lambda$17(Function3 $chatProgressFun, Function3 $logProgressFun, LocateTask task, LocateTask.Phase phase, float pct) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        $chatProgressFun.invoke((Object)task, (Object)phase, (Object)Float.valueOf(pct));
        $logProgressFun.invoke((Object)task, (Object)phase, (Object)Float.valueOf(pct));
        return Unit.INSTANCE;
    }

    private static final Unit locateJigsawStructure$lambda$20$lambda$18(CommandSourceStack $source, ResourceOrTagKeyArgument.Result $structure, BlockPos $blockPos, Stopwatch $stopwatch, LocateResult it) {
        if (it == null) {
            Object[] objectArray = new Object[]{$structure.asPrintable()};
            $source.sendFailure((Component)Component.translatable((String)"commands.locate.structure.invalid", (Object[])objectArray));
        } else {
            LocateCommand.showLocateResult((CommandSourceStack)$source, (ResourceOrTagKeyArgument.Result)$structure, (BlockPos)$blockPos, (Pair)new Pair((Object)it.getPos(), it.getStructure()), (String)"commands.locate.structure.success", (boolean)false, (Duration)$stopwatch.elapsed());
        }
        return Unit.INSTANCE;
    }

    private static final Unit locateJigsawStructure$lambda$20$lambda$19(CommandSourceStack $source, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = "Error in async jigsaw search: %s";
        Object[] objectArray = new Object[]{it.getMessage()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        $source.sendFailure((Component)Component.literal((String)string2));
        return Unit.INSTANCE;
    }

    private static final List locateJigsawStructure$lambda$23$lambda$21(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List locateJigsawStructure$lambda$23$lambda$22(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Component stopLocating$lambda$27() {
        return (Component)Component.translatable((String)"growsseth.commands.glocate.stop.success");
    }
}

